/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JToggleButton;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.common2.debugger.VariableModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.VariablesViewButtons;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.MaxObjectAction;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.actions.SystemAction;

public final class LocalModel
extends VariableModel
implements NodeActionsProvider {
    private Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node("variables_view");
    private VariablesPreferenceChangeListener prefListener = new VariablesPreferenceChangeListener();

    public LocalModel(ContextProvider ctx) {
        super(ctx);
        this.preferences.addPreferenceChangeListener(this.prefListener);
        VariablesViewButtons.createShowAutosButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JToggleButton) {
                    JToggleButton b = (JToggleButton)e.getSource();
                    LocalModel.this.debugger.setShowAutos(b.isSelected());
                }
            }
        });
    }

    protected boolean isLocal() {
        return true;
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        Object[] children;
        if (parent == "Root") {
            children = VariablesViewButtons.isShowAutos() ? this.debugger.getAutos() : this.debugger.getLocals();
        } else if (parent instanceof Variable) {
            Variable v = (Variable)parent;
            children = v.getChildren();
        } else {
            throw new UnknownTypeException(parent);
        }
        return children;
    }

    public int getChildrenCount(Object parent) throws UnknownTypeException {
        int count;
        if (parent == "Root") {
            count = VariablesViewButtons.isShowAutos() ? this.debugger.getAutosCount() : this.debugger.getLocalsCount();
        } else if (parent instanceof Variable) {
            Variable v = (Variable)parent;
            count = v.getNumChild();
        } else {
            throw new UnknownTypeException(parent);
        }
        return count;
    }

    public void addModelListener(ModelListener l) {
        if (super.addModelListenerHelp(l)) {
            this.debugger.setShowAutos(VariablesViewButtons.isShowAutos());
            this.debugger.registerLocalModel(this);
        }
    }

    public void removeModelListener(ModelListener l) {
        if (super.removeModelListenerHelp(l)) {
            this.debugger.setShowAutos(false);
            this.debugger.registerLocalModel(null);
        }
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return new Action[]{WatchModel.NEW_WATCH_ACTION, new WatchModel.DeleteAllAction(), null, Action_INHERITED_MEMBERS, Action_DYNAMIC_TYPE, Action_STATIC_MEMBERS, null, SystemAction.get(MaxObjectAction.class), null};
        }
        if (node instanceof Variable) {
            Variable v = (Variable)node;
            return v.getActions(false);
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (!(node instanceof Variable)) {
            throw new UnknownTypeException(node);
        }
        Variable variable = (Variable)node;
    }

    private class VariablesPreferenceChangeListener
    implements PreferenceChangeListener {
        private VariablesPreferenceChangeListener() {
        }

        public void preferenceChange(PreferenceChangeEvent evt) {
            String key = evt.getKey();
            if ("show_autos".equals(key)) {
                this.refresh();
            }
        }

        private void refresh() {
            try {
                LocalModel.this.treeChanged();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
            }
        }
    }
}

