/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.spi.viewmodel.Models;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class EvaluationWindow
extends TopComponent
implements ActionListener {
    static final String preferredID = "EvaluationWindow";
    static EvaluationWindow DEFAULT;
    private transient JComponent tree = null;
    private String name;
    private String view_name;
    private NativeDebugger debugger = null;
    private JMenuItem menuItemFollowSelectedPointer;
    private JMenuItem menuItemClear;
    private JPopupMenu popup;
    private JRadioButtonMenuItem rbMenuItem;
    private JTextArea ta;
    private JScrollPane ta_sp;
    private JPanel hp;
    private JPanel cp;
    private PopupListener popupListener;
    private String expr;
    private JTextField memory_length_jtf;
    private String[] formats = new String[]{Catalog.get("Default_format"), Catalog.get("l_Hexadecimal"), Catalog.get("L_Hexadecimal"), Catalog.get("l_Decimal"), Catalog.get("L_Decimal"), Catalog.get("l_U_Decimal"), Catalog.get("L_U_Decimal"), Catalog.get("l_Float"), Catalog.get("L_Float")};
    private String[] short_formats = new String[]{" ", "-fx ", "-flx ", "-fd ", "-fld ", "-fu ", "-flu ", "(float) ", "(double) "};
    private JComboBox format_jcb;
    private FormatListener format_listener;
    private int format;
    private boolean dontShowText = true;
    private JComboBox exprList;
    private String selected_text = null;

    public static EvaluationWindow getDefault() {
        EvaluationWindow tc;
        if (DEFAULT == null && (tc = (EvaluationWindow)WindowManager.getDefault().findTopComponent(preferredID)) == null) {
            new EvaluationWindow();
        }
        return DEFAULT;
    }

    public EvaluationWindow() {
        this.name = Catalog.get("TITLE_EvaluationWindow");
        this.view_name = Catalog.get("TITLE_EvaluationView");
        super.setName(this.name);
        DEFAULT = this;
        String iconDir = "org/netbeans/modules/cnd/debugger/common2/icons/";
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/debugger/common2/icons/evaluate_expression.png"));
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    protected void componentHidden() {
        if (this.exprList != null) {
            this.exprList.setSelectedIndex(0);
        }
        if (this.debugger != null) {
            this.debugger.registerEvaluationWindow(null);
        }
    }

    public void componentShowing() {
        super.componentShowing();
        this.connectToDebugger(DebuggerManager.get().currentDebugger());
        this.updateWindow();
    }

    protected void componentClosed() {
        super.componentClosed();
        if (this.debugger != null) {
            this.debugger.registerEvaluationWindow(null);
            this.ta.setText(null);
            this.ta.setCaretPosition(0);
            this.exprList.setSelectedIndex(0);
            this.invalidate();
        }
    }

    protected void connectToDebugger(NativeDebugger debugger) {
        this.debugger = debugger;
        if (debugger == null) {
            return;
        }
        debugger.registerEvaluationWindow(this);
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return this.view_name;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox cb;
        String ac = actionEvent.getActionCommand();
        if (ac != null && ac.equals("comboBoxChanged") && (cb = (JComboBox)actionEvent.getSource()) != null) {
            this.expr = (String)cb.getSelectedItem();
            if (this.expr != null && !this.expr.equals("")) {
                this.exprEval();
            }
        }
    }

    private void exprEval() {
        this.format = this.format_jcb.getSelectedIndex();
        if (this.expr != null && !this.expr.equals("")) {
            this.debugger.exprEval(this.short_formats[this.format], this.expr);
        }
    }

    private int exprMap(String expr) {
        for (int i = 0; i < this.exprList.getItemCount(); ++i) {
            if (!expr.equals((String)this.exprList.getItemAt(i))) continue;
            return i;
        }
        return -1;
    }

    public void evalResult(String result) {
        int index;
        int i;
        if (result == null) {
            return;
        }
        if (result.length() == 0) {
            result = " ";
        }
        if ((i = result.indexOf(" =")) == -1) {
            i = result.length() - 1;
        }
        if ((index = this.exprMap(this.expr)) == -1) {
            this.exprList.addItem(this.expr);
        }
        this.ta.append(result);
        this.updateWindow();
    }

    private void updateWindow() {
        if (this.tree == null) {
            this.ta = new JTextArea();
            this.ta_sp = new JScrollPane(this.ta);
            this.setLayout(new BorderLayout());
            this.tree = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
            this.tree.setName(this.view_name);
            this.ta.setEditable(false);
            this.ta.setWrapStyleWord(false);
            Font f = this.ta.getFont();
            this.ta.setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
            this.hp = new JPanel(new BorderLayout());
            this.expr = "";
            this.format = 0;
            this.cp = new JPanel(new GridBagLayout());
            this.cp.setToolTipText("Control panel to specify Expression. Use pop-up menu to specify output format.");
            JLabel cp_text1 = new JLabel(Catalog.get("LBL_Expression"));
            cp_text1.setToolTipText(Catalog.get("HINT_Expression"));
            this.exprList = new JComboBox();
            this.exprList.setMaximumSize(this.cp.getPreferredSize());
            this.exprList.addItem(this.expr);
            this.exprList.setEditable(true);
            this.exprList.addActionListener(this);
            JLabel cp_text3 = new JLabel(Catalog.get("LBL_Format"));
            cp_text3.setToolTipText(Catalog.get("HINT_Output_format"));
            this.format_listener = new FormatListener();
            this.format_jcb = new JComboBox<String>(this.formats);
            this.format_jcb.setSelectedIndex(this.format);
            this.format_jcb.addActionListener(this.format_listener);
            int gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 0, 8, 0);
            this.cp.add((Component)cp_text1, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            gridBagConstraints.weightx = 1.0;
            this.cp.add((Component)this.exprList, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.cp.add((Component)cp_text3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.cp.add((Component)this.format_jcb, gridBagConstraints);
            this.tree.add((Component)this.hp, "North");
            this.tree.add((Component)this.ta_sp, "Center");
            this.tree.add((Component)this.cp, "South");
            AccessibleContext ac = this.tree.getAccessibleContext();
            ac.setAccessibleDescription("Window to view  expression");
            ac.setAccessibleName(Catalog.get("TITLE_EvaluationView"));
            this.add(this.tree, "Center");
            this.popup = new JPopupMenu();
            this.popupListener = new PopupListener(this.popup);
            this.menuItemClear = new JMenuItem(new ClearBufferAction());
            this.popup.add(this.menuItemClear);
            this.ta.addMouseListener(this.popupListener);
            this.ta.setText(null);
            this.ta.setCaretPosition(0);
        }
        this.invalidate();
    }

    protected void FollowSelectedPointer(String s) {
        int i;
        for (i = 0; i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t'); ++i) {
        }
        if (i > 0 && i < s.length()) {
            s = s.substring(i);
        }
        for (i = 0; i < s.length() && s.charAt(i) != ':' && s.charAt(i) != ';' && s.charAt(i) != ' ' && s.charAt(i) != '\t'; ++i) {
        }
        if (i > 0 && i < s.length()) {
            s = s.substring(0, i);
        }
        if (s.length() > 0) {
            this.expr = s;
        }
        this.exprEval();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(preferredID);
    }

    class FollowSelectedPointerAction
    extends AbstractAction {
        public FollowSelectedPointerAction() {
            super("Follow Selected Pointer", new ImageIcon("paste.gif"));
        }

        public void actionPerformed(ActionEvent ev) {
            EvaluationWindow.this.FollowSelectedPointer(EvaluationWindow.this.selected_text);
        }
    }

    class ClearBufferAction
    extends AbstractAction {
        public ClearBufferAction() {
            super("Clear", new ImageIcon("org/netbeans/modules/cnd/debugger/common2/icons/Pointers.gif"));
        }

        public void actionPerformed(ActionEvent ev) {
            EvaluationWindow.this.ta.setText(null);
            EvaluationWindow.this.ta.setCaretPosition(0);
        }
    }

    class PopupListener
    extends MouseAdapter
    implements ActionListener,
    PopupMenuListener {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                EvaluationWindow.this.menuItemClear.setEnabled(true);
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void actionPerformed(ActionEvent ev) {
            JMenuItem source = (JMenuItem)ev.getSource();
            String s = source.getText();
            for (int i = 0; i < EvaluationWindow.this.formats.length; ++i) {
                if (!EvaluationWindow.this.formats[i].equals(s)) continue;
                EvaluationWindow.this.format = i;
                EvaluationWindow.this.format_jcb.setSelectedIndex(i);
                EvaluationWindow.this.exprEval();
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private class FormatListener
    implements ActionListener {
        private FormatListener() {
        }

        public void actionPerformed(ActionEvent ev) {
            String ac = ev.getActionCommand();
            if (ac.equals("comboBoxChanged")) {
                JComboBox cb = (JComboBox)ev.getSource();
                String s = (String)cb.getSelectedItem();
                for (int i = 0; i < EvaluationWindow.this.formats.length; ++i) {
                    if (!EvaluationWindow.this.formats[i].equals(s)) continue;
                    EvaluationWindow.this.format = i;
                    EvaluationWindow.this.format_jcb.setSelectedIndex(i);
                    EvaluationWindow.this.exprEval();
                }
            }
        }
    }
}

