/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;

public class Error {
    private final Msg[] errors;
    private Severity maxSeverity = Severity.NONE;
    private String errorToken = null;
    private String msg = null;
    private String text = null;
    private boolean processed = false;

    protected Error(Msg[] errors) {
        this.errors = errors;
    }

    public boolean isRedundantPathmap() {
        String theMsg = "dbx: Already mapping path";
        return this.errors.length > 0 && this.errors[0].msg != null && this.errors[0].msg.startsWith("dbx: Already mapping path");
    }

    public boolean isCancelled() {
        return IpeUtils.sameString("cancelled", this.errorToken());
    }

    public boolean isOodSrc() {
        return IpeUtils.sameString("source-modified", this.errorToken());
    }

    public boolean isXExec64() {
        return IpeUtils.sameString("xexec64", this.errorToken());
    }

    public boolean isXExec32() {
        return IpeUtils.sameString("xexec32", this.errorToken());
    }

    public boolean isBadcore() {
        return IpeUtils.sameString("badcore", this.errorToken());
    }

    public boolean isBadcoreOod() {
        return IpeUtils.sameString("badcore-timestamp", this.errorToken());
    }

    public boolean isBadcoreNoprog() {
        return IpeUtils.sameString("badcore-noprog", this.errorToken());
    }

    public boolean isRunFailed() {
        return IpeUtils.sameString("run-failed", this.errorToken());
    }

    private void process() {
        if (this.processed) {
            return;
        }
        StringBuffer buffer = new StringBuffer(this.errors.length * 40);
        for (int ex = 0; ex < this.errors.length; ++ex) {
            Msg err = this.errors[ex];
            if (err.severity.compareTo(this.maxSeverity) > 0) {
                this.maxSeverity = err.severity;
            }
            if (err.cookie != null) {
                this.errorToken = err.cookie;
            }
            if (ex > 0) {
                buffer.append(" / ");
            }
            buffer.append(err.msg);
        }
        this.msg = buffer.toString();
        this.processed = true;
    }

    public final Severity maxSeverity() {
        this.process();
        return this.maxSeverity;
    }

    public final String errorToken() {
        this.process();
        return this.errorToken;
    }

    public final String msg() {
        this.process();
        return this.msg;
    }

    public final String text() {
        if (this.text == null) {
            StringBuffer buffer = new StringBuffer();
            for (Msg e : this.errors) {
                buffer.append(e.msg + "\n");
            }
            this.text = buffer.toString();
        }
        return this.text;
    }

    public final String first() {
        if (this.errors.length > 0 && this.errors[0].msg != null) {
            return this.errors[0].msg;
        }
        return "";
    }

    public static final class Msg {
        private final Severity severity;
        private final String msg;
        private final String cookie;

        public Msg(Severity severity, String msg, String cookie) {
            this.severity = severity;
            this.msg = msg;
            this.cookie = cookie;
        }

        public Severity severity() {
            return this.severity;
        }

        public String msg() {
            return this.msg;
        }

        public String cookie() {
            return this.cookie;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        NONE,
        WARNING,
        ERROR;

    }
}

