/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.profiler.selector.java.nodes.JavaClassNode;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class SingleFileSelectionTreeBuilder
extends SelectionTreeBuilder {
    private FileObject file;

    public SingleFileSelectionTreeBuilder(FileObject file) {
        super(new SelectionTreeBuilder.Type("single-file", "Single File"), false);
        this.file = file;
    }

    public List<SelectorNode> buildSelectionTree() {
        final SelectorNode[] classNode = new SelectorNode[1];
        JavaSource js = JavaSource.forFileObject((FileObject)this.file);
        if (js != null) {
            try {
                js.runWhenScanFinished((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        TypeElement classElement = SingleFileSelectionTreeBuilder.getToplevelClass(controller);
                        classNode[0] = new JavaClassNode(controller.getClasspathInfo(), classElement, null);
                    }
                }, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return classNode[0] != null ? Collections.singletonList(classNode[0]) : Collections.EMPTY_LIST;
    }

    public int estimatedNodeCount() {
        return 1;
    }

    private static TypeElement getToplevelClass(final CompilationController controller) throws IOException {
        if (controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
            return null;
        }
        TreePathScanner<TypeElement, Void> scanner = new TreePathScanner<TypeElement, Void>(){

            @Override
            public TypeElement visitClass(ClassTree node, Void p) {
                try {
                    return (TypeElement)controller.getTrees().getElement(this.getCurrentPath());
                }
                catch (NullPointerException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    return null;
                }
            }
        };
        return (TypeElement)scanner.scan(controller.getCompilationUnit(), null);
    }
}

