/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.relaxng.impl.PatternFuture;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import com.thaiopensource.relaxng.impl.SchemaReaderImpl;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.ParseReceiver;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiver;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import java.io.IOException;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SchemaReceiverImpl
implements SchemaReceiver {
    private final ParseReceiver parser;
    private final PropertyMap properties;

    public SchemaReceiverImpl(ParseReceiver parser, PropertyMap properties) {
        this.parser = parser;
        this.properties = properties;
    }

    public SchemaFuture installHandlers(XMLReader xr) throws SAXException {
        final SchemaPatternBuilder pb = new SchemaPatternBuilder();
        ErrorHandler eh = ValidateProperty.ERROR_HANDLER.get(this.properties);
        DatatypeLibraryFactory dlf = RngProperty.DATATYPE_LIBRARY_FACTORY.get(this.properties);
        if (dlf == null) {
            dlf = new DatatypeLibraryLoader();
        }
        final PatternFuture pf = SchemaBuilderImpl.installHandlers(this.parser, xr, eh, dlf, pb);
        return new SchemaFuture(){

            public Schema getSchema() throws IncorrectSchemaException, SAXException, IOException {
                try {
                    return SchemaReaderImpl.wrapPattern(pf.getPattern(SchemaReceiverImpl.this.properties.contains(WrapProperty.ATTRIBUTE_OWNER)), pb, SchemaReceiverImpl.this.properties);
                }
                catch (IllegalSchemaException e) {
                    throw new IncorrectSchemaException();
                }
            }

            public RuntimeException unwrapException(RuntimeException e) throws SAXException, IOException, IncorrectSchemaException {
                if (e instanceof BuildException) {
                    try {
                        return SchemaBuilderImpl.unwrapBuildException((BuildException)e);
                    }
                    catch (IllegalSchemaException ise) {
                        throw new IncorrectSchemaException();
                    }
                }
                return e;
            }
        };
    }
}

