/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class ModulesNode
extends AbstractNode {
    public ModulesNode(NbMavenProjectImpl proj) {
        super(Children.create((ChildFactory)new ModulesChildFactory(proj), (boolean)true));
        this.setName("Modules");
        this.setDisplayName(NbBundle.getMessage(ModulesNode.class, (String)"LBL_Modules"));
    }

    public Action[] getActions(boolean bool) {
        return new Action[0];
    }

    private Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/modules-badge.png", (boolean)true);
        return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
    }

    public Image getIcon(int type) {
        return this.getIcon(false);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(true);
    }

    private static class OpenProjectAction
    extends AbstractAction
    implements ContextAwareAction {
        static final OpenProjectAction SINGLETON = new OpenProjectAction();

        private OpenProjectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(final Lookup context) {
            return new AbstractAction(NbBundle.getMessage(ModulesNode.class, (String)"BTN_Open_Project")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Collection projects = context.lookupAll(NbMavenProjectImpl.class);
                    OpenProjects.getDefault().open((Project[])projects.toArray(new NbMavenProjectImpl[projects.size()]), false, true);
                }
            };
        }
    }

    private static class RemoveModuleAction
    extends AbstractAction {
        private NbMavenProjectImpl project;
        private NbMavenProjectImpl parent;

        public RemoveModuleAction(NbMavenProjectImpl parent, NbMavenProjectImpl proj) {
            this.putValue("Name", NbBundle.getMessage(ModulesNode.class, (String)"BTN_Remove_Module"));
            this.project = proj;
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ModulesNode.class, (String)"MSG_Remove_Module"), 0);
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (ret == NotifyDescriptor.YES_OPTION) {
                FileObject fo = FileUtil.toFileObject((File)this.parent.getPOMFile());
                ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                    public void performOperation(POMModel model) {
                        List modules = model.getProject().getModules();
                        if (modules != null) {
                            for (String path : modules) {
                                File rel = new File(RemoveModuleAction.this.parent.getPOMFile().getParent(), path);
                                File norm = FileUtil.normalizeFile((File)rel);
                                FileObject folder = FileUtil.toFileObject((File)norm);
                                if (folder == null || !folder.equals(RemoveModuleAction.this.project.getProjectDirectory())) continue;
                                model.getProject().removeModule(path);
                                break;
                            }
                        }
                    }
                };
                Utilities.performPOMModelOperations((FileObject)fo, Collections.singletonList(operation));
                NbMavenProject.fireMavenProjectReload(this.project);
            }
        }
    }

    private static class ProjectFilterNode
    extends FilterNode {
        private NbMavenProjectImpl project;
        private NbMavenProjectImpl parent;

        ProjectFilterNode(NbMavenProjectImpl parent, NbMavenProjectImpl proj, Node original, boolean isPom) {
            super(original, isPom ? FilterNode.Children.create((ChildFactory)new ModulesChildFactory(proj), (boolean)true) : FilterNode.Children.LEAF);
            this.project = proj;
            this.parent = parent;
        }

        public Action[] getActions(boolean b) {
            ArrayList<AbstractAction> lst = new ArrayList<AbstractAction>();
            lst.add(OpenProjectAction.SINGLETON);
            lst.add(new RemoveModuleAction(this.parent, this.project));
            return lst.toArray(new Action[lst.size()]);
        }

        public Action getPreferredAction() {
            return OpenProjectAction.SINGLETON;
        }
    }

    static class ModulesChildFactory
    extends ChildFactory<Wrapper> {
        private final NbMavenProjectImpl project;
        private final PropertyChangeListener listener;

        ModulesChildFactory(NbMavenProjectImpl proj) {
            this.project = proj;
            NbMavenProject watcher = this.project.getProjectWatcher();
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MavenProject".equals(evt.getPropertyName())) {
                        ModulesChildFactory.this.refresh(false);
                    }
                }
            };
            watcher.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)watcher));
        }

        protected boolean createKeys(List<Wrapper> modules) {
            File base = this.project.getOriginalMavenProject().getBasedir();
            for (String elem : this.project.getOriginalMavenProject().getModules()) {
                File projDir = FileUtil.normalizeFile((File)new File(base, elem));
                FileObject fo = FileUtil.toFileObject((File)projDir);
                if (fo == null) continue;
                try {
                    Project prj = ProjectManager.getDefault().findProject(fo);
                    if (prj == null || prj.getLookup().lookup(NbMavenProjectImpl.class) == null) continue;
                    Wrapper wr = new Wrapper();
                    wr.proj = (NbMavenProjectImpl)prj;
                    wr.isPOM = "pom".equals(wr.proj.getOriginalMavenProject().getPackaging());
                    wr.provider = (LogicalViewProvider)prj.getLookup().lookup(LogicalViewProvider.class);
                    modules.add(wr);
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return true;
        }

        protected Node createNodeForKey(Wrapper wr) {
            return new ProjectFilterNode(this.project, wr.proj, wr.provider.createLogicalView(), wr.isPOM);
        }
    }

    static class Wrapper {
        boolean isPOM;
        LogicalViewProvider provider;
        NbMavenProjectImpl proj;

        Wrapper() {
        }
    }
}

