/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.ui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.codehaus.plexus.util.StringUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.TextValueCompleter;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.customizer.PropertySplitter;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.grammar.GoalsProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RunGoalsPanel
extends JPanel {
    private List<NetbeansActionMapping> historyMappings;
    private int historyIndex = 0;
    private TextValueCompleter goalcompleter;
    private TextValueCompleter profilecompleter;
    private JButton btnNext;
    private JButton btnPrev;
    private JCheckBox cbDebug;
    private JCheckBox cbOffline;
    private JCheckBox cbRecursive;
    private JCheckBox cbRemember;
    private JCheckBox cbSkipTests;
    private JCheckBox cbUpdateSnapshots;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblGoals;
    private JLabel lblProfiles;
    private JTextArea taProperties;
    private JTextField txtGoals;
    private JTextField txtProfiles;
    private JTextField txtRemember;

    public RunGoalsPanel() {
        this.initComponents();
        this.historyMappings = new ArrayList<NetbeansActionMapping>();
        this.btnPrev.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/back.png", (boolean)false));
        this.btnNext.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/forward.png", (boolean)false));
        this.goalcompleter = new TextValueCompleter(new ArrayList<String>(0), this.txtGoals, " ");
        this.goalcompleter.setLoading(true);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                GoalsProvider provider = (GoalsProvider)Lookup.getDefault().lookup(GoalsProvider.class);
                if (provider != null) {
                    final Set<String> strs = provider.getAvailableGoals();
                    try {
                        List phases = EmbedderFactory.getProjectEmbedder().getLifecyclePhases();
                        strs.addAll(phases);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RunGoalsPanel.this.goalcompleter.setValueList(strs);
                        }
                    });
                }
            }
        });
        this.profilecompleter = new TextValueCompleter(new ArrayList<String>(0), this.txtProfiles, " ");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.txtGoals.requestFocus();
    }

    private void readProfiles(final Project mavenProject) {
        this.profilecompleter.setLoading(true);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ProjectProfileHandler profileHandler = (ProjectProfileHandler)mavenProject.getLookup().lookup(ProjectProfileHandler.class);
                final List<String> ret = profileHandler.getAllProfiles();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RunGoalsPanel.this.profilecompleter.setValueList(ret);
                    }
                });
            }
        });
    }

    private String createSpaceSeparatedList(List list) {
        String str = "";
        if (list != null) {
            for (String elem : list) {
                str = str + elem + " ";
            }
        }
        return str;
    }

    public void readMapping(NetbeansActionMapping mapp, NbMavenProjectImpl project, ActionToGoalMapping historyMappings) {
        this.historyMappings.clear();
        this.historyMappings.addAll(historyMappings.getActions());
        this.historyMappings.add(mapp);
        this.historyIndex = this.historyMappings.size();
        this.readProfiles(project);
        this.moveHistory(-1);
    }

    public void readConfig(RunConfig config) {
        this.historyMappings.clear();
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(false);
        this.txtGoals.setText(this.createSpaceSeparatedList(config.getGoals()));
        if (config.getProperties() != null) {
            StringBuffer buf = new StringBuffer();
            for (String string : config.getProperties().keySet()) {
                buf.append(string).append("=").append(config.getProperties().getProperty(string)).append("\n");
            }
            this.taProperties.setText(buf.toString());
            if (buf.toString().matches(".*maven\\.test\\.skip\\s*=\\s*true\\s*.*")) {
                this.cbSkipTests.setSelected(true);
            }
        } else {
            this.taProperties.setText("");
        }
        List<String> activatedProfiles = config.getActivatedProfiles();
        if (config.getProject() != null) {
            ProjectProfileHandler profileHandler = (ProjectProfileHandler)config.getProject().getLookup().lookup(ProjectProfileHandler.class);
            List<String> list = profileHandler.getMergedActiveProfiles(false);
            this.txtProfiles.setText(this.createSpaceSeparatedList(list));
        } else {
            this.txtProfiles.setText(this.createSpaceSeparatedList(activatedProfiles));
        }
        this.setUpdateSnapshots(config.isUpdateSnapshots());
        this.setOffline(config.isOffline() != null ? config.isOffline() : false);
        this.setRecursive(config.isRecursive());
        this.setShowDebug(config.isShowDebug());
        if (config.getProject() != null) {
            this.readProfiles(config.getProject());
        }
    }

    private void readMapping(NetbeansActionMapping mapp) {
        this.txtGoals.setText(this.createSpaceSeparatedList(mapp.getGoals()));
        if (mapp.getProperties() != null) {
            StringBuffer buf = new StringBuffer();
            for (String string : mapp.getProperties().keySet()) {
                buf.append(string).append("=").append(mapp.getProperties().getProperty(string)).append("\n");
            }
            this.taProperties.setText(buf.toString());
            if (buf.toString().matches(".*maven\\.test\\.skip\\s*=\\s*true\\s*.*")) {
                this.cbSkipTests.setSelected(true);
            }
        } else {
            this.taProperties.setText("");
        }
        this.txtProfiles.setText(this.createSpaceSeparatedList(mapp.getActivatedProfiles()));
    }

    public void applyValues(NetbeansActionMapping mapp) {
        StringTokenizer tok = new StringTokenizer(this.txtGoals.getText().trim());
        ArrayList<String> lst = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            lst.add(tok.nextToken());
        }
        mapp.setGoals(lst.size() > 0 ? lst : null);
        PropertySplitter split = new PropertySplitter(this.taProperties.getText());
        String token = split.nextPair();
        Properties props = new Properties();
        while (token != null) {
            String[] prp = StringUtils.split((String)token, (String)"=", (int)2);
            if (prp.length == 2) {
                String key = prp[0];
                if (key.startsWith("-D")) {
                    key = key.substring("-D".length());
                }
                if (key.startsWith("-")) {
                    key = key.substring(1);
                }
                props.setProperty(key, prp[1]);
            }
            token = split.nextPair();
        }
        if (this.cbSkipTests.isSelected()) {
            props.setProperty("skipTests", "true");
        }
        mapp.setProperties(props);
        tok = new StringTokenizer(this.txtProfiles.getText().trim());
        lst = new ArrayList();
        while (tok.hasMoreTokens()) {
            lst.add(tok.nextToken());
        }
        mapp.setActivatedProfiles(lst);
        mapp.setRecursive(this.cbRecursive.isSelected());
    }

    public void applyValues(BeanRunConfig rc) {
        StringTokenizer tok = new StringTokenizer(this.txtGoals.getText().trim());
        ArrayList<String> lst = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            lst.add(tok.nextToken());
        }
        rc.setGoals(lst.size() > 0 ? lst : Collections.singletonList("install"));
        tok = new StringTokenizer(this.txtProfiles.getText().trim());
        lst = new ArrayList();
        while (tok.hasMoreTokens()) {
            lst.add(tok.nextToken());
        }
        rc.setActivatedProfiles(lst);
        PropertySplitter split = new PropertySplitter(this.taProperties.getText());
        String token = split.nextPair();
        Properties props = new Properties();
        while (token != null) {
            String[] prp = StringUtils.split((String)token, (String)"=", (int)2);
            if (prp.length == 2) {
                props.setProperty(prp[0], prp[1]);
            }
            token = split.nextPair();
        }
        if (this.cbSkipTests.isSelected()) {
            props.setProperty("skipTests", "true");
        }
        rc.setProperties(props);
        rc.setRecursive(this.isRecursive());
        rc.setShowDebug(this.isShowDebug());
        rc.setUpdateSnapshots(this.isUpdateSnapshots());
        rc.setOffline(this.isOffline());
    }

    private void initComponents() {
        this.lblGoals = new JLabel();
        this.txtGoals = new JTextField();
        this.lblProfiles = new JLabel();
        this.txtProfiles = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taProperties = new JTextArea();
        this.cbRecursive = new JCheckBox();
        this.cbOffline = new JCheckBox();
        this.cbDebug = new JCheckBox();
        this.cbUpdateSnapshots = new JCheckBox();
        this.cbSkipTests = new JCheckBox();
        this.btnNext = new JButton();
        this.btnPrev = new JButton();
        this.cbRemember = new JCheckBox();
        this.txtRemember = new JTextField();
        this.jSeparator1 = new JSeparator();
        Mnemonics.setLocalizedText((JLabel)this.lblGoals, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Goals"));
        Mnemonics.setLocalizedText((JLabel)this.lblProfiles, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Profiles"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Properties"));
        this.taProperties.setColumns(20);
        this.taProperties.setRows(5);
        this.jScrollPane1.setViewportView(this.taProperties);
        Mnemonics.setLocalizedText((AbstractButton)this.cbRecursive, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Recursive"));
        this.cbRecursive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbRecursive.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbOffline, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Offline"));
        this.cbOffline.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbOffline.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDebug, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Debug"));
        this.cbDebug.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbDebug.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbUpdateSnapshots, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Update_Snapshots"));
        this.cbUpdateSnapshots.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbUpdateSnapshots.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSkipTests, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Skip_Tests"));
        this.cbSkipTests.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSkipTests.setMargin(new Insets(0, 0, 0, 0));
        this.cbSkipTests.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunGoalsPanel.this.cbSkipTestsActionPerformed(evt);
            }
        });
        this.btnNext.setToolTipText(NbBundle.getMessage(RunGoalsPanel.class, (String)"TIP_Next"));
        this.btnNext.setMargin(new Insets(2, 2, 2, 2));
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunGoalsPanel.this.btnNextActionPerformed(evt);
            }
        });
        this.btnPrev.setToolTipText(NbBundle.getMessage(RunGoalsPanel.class, (String)"TIP_Prev"));
        this.btnPrev.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunGoalsPanel.this.btnPrevActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbRemember, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Remember"));
        this.cbRemember.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbRemember.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbRecursive).addComponent(this.cbOffline)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbDebug).addComponent(this.cbUpdateSnapshots))).addComponent(this.cbSkipTests).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblGoals).addComponent(this.lblProfiles).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 385, Short.MAX_VALUE).addComponent(this.txtGoals, -1, 385, Short.MAX_VALUE).addComponent(this.txtProfiles, -1, 385, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.btnPrev).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNext).addGap(52, 52, 52).addComponent(this.cbRemember).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtRemember, -1, 275, Short.MAX_VALUE)).addComponent(this.jSeparator1, -1, 477, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGoals).addComponent(this.txtGoals, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblProfiles).addComponent(this.txtProfiles, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jScrollPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbRecursive).addComponent(this.cbUpdateSnapshots)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbOffline).addComponent(this.cbDebug)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSkipTests).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnPrev).addComponent(this.btnNext).addComponent(this.cbRemember).addComponent(this.txtRemember, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cbSkipTestsActionPerformed(ActionEvent evt) {
        String current = this.taProperties.getText();
        if (current.contains("skipTests")) {
            this.taProperties.setText(current.replaceAll(".*\\QskipTests\\E\\s*=\\s*[a-z]*\\s*.*", "skipTests=" + (this.cbSkipTests.isSelected() ? "true" : "false")));
        } else if (this.cbSkipTests.isSelected()) {
            this.taProperties.setText(this.taProperties.getText() + "\n" + "skipTests" + "=true");
        }
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        this.moveHistory(1);
    }

    private void moveHistory(int step) {
        this.historyIndex += step;
        this.readMapping(this.historyMappings.get(this.historyIndex));
        this.btnPrev.setEnabled(this.historyIndex != 0);
        this.btnNext.setEnabled(this.historyIndex != this.historyMappings.size() - 1);
    }

    private void btnPrevActionPerformed(ActionEvent evt) {
        this.moveHistory(-1);
    }

    public boolean isOffline() {
        return this.cbOffline.isSelected();
    }

    public boolean isShowDebug() {
        return this.cbDebug.isSelected();
    }

    public void setOffline(boolean b) {
        this.cbOffline.setSelected(b);
    }

    public void setShowDebug(boolean b) {
        this.cbDebug.setSelected(b);
    }

    public void setUpdateSnapshots(boolean b) {
        this.cbUpdateSnapshots.setSelected(b);
    }

    public void setSkipTests(boolean b) {
        this.cbSkipTests.setSelected(b);
    }

    public void setRecursive(boolean b) {
        this.cbRecursive.setSelected(b);
    }

    public boolean isSkipTests() {
        return this.cbSkipTests.isSelected();
    }

    public boolean isRecursive() {
        return this.cbRecursive.isSelected();
    }

    public boolean isUpdateSnapshots() {
        return this.cbUpdateSnapshots.isSelected();
    }

    public String isRememberedAs() {
        String txt;
        if (this.cbRemember.isSelected() && (txt = this.txtRemember.getText().trim()).length() > 0) {
            return txt;
        }
        return null;
    }
}

