/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ReactorChecker
implements PrerequisitesChecker {
    @Override
    public boolean checkRunConfig(RunConfig config) {
        MavenProject parent;
        if (config.getPreExecution() != null && !this.checkRunConfig(config.getPreExecution())) {
            return false;
        }
        if (config.getReactorStyle() == RunConfig.ReactorStyle.NONE) {
            return true;
        }
        File dir = config.getExecutionDirectory();
        FileObject fo = FileUtil.toFileObject((File)dir);
        Project p = config.getProject();
        if (p == null || fo != p.getProjectDirectory()) {
            return true;
        }
        NbMavenProject mavenprj = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class);
        if (mavenprj == null) {
            return true;
        }
        MavenProject prj = mavenprj.getMavenProject();
        while ((parent = prj.getParent()) != null && parent.getBasedir() != null) {
            prj = parent;
        }
        config.setExecutionDirectory(prj.getBasedir());
        return true;
    }
}

