/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.NBPluginParameterExpressionEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class PluginPropertyUtils {
    private static List<String> LIFECYCLE_PLUGINS = Arrays.asList("maven-compiler-plugin", "maven-surefire-plugin", "maven-ear-plugin", "maven-jar-plugin", "maven-war-plugin", "maven-resources-plugin");

    private PluginPropertyUtils() {
    }

    public static String getPluginProperty(Project prj, String groupId, String artifactId, String property, String goal) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, property, goal);
    }

    public static String getPluginProperty(MavenProject prj, String groupId, String artifactId, String property, String goal) {
        return PluginPropertyUtils.getPluginPropertyImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, property, goal);
    }

    private static String getPluginPropertyImpl(MavenProject prj, NBPluginParameterExpressionEvaluator eval, String groupId, String artifactId, String property, String goal) {
        String toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Plugin plug : prj.getBuildPlugins()) {
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getExecutions() != null && goal != null) {
                PluginExecution exe;
                Iterator i$ = plug.getExecutions().iterator();
                while (i$.hasNext() && (!(exe = (PluginExecution)i$.next()).getGoals().contains(goal) && !("default-" + goal).equals(exe.getId()) || (toRet = PluginPropertyUtils.checkConfiguration(eval, exe.getConfiguration(), property)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkConfiguration(eval, plug.getConfiguration(), property);
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Plugin plug : prj.getPluginManagement().getPlugins()) {
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = PluginPropertyUtils.checkConfiguration(eval, plug.getConfiguration(), property);
                break;
            }
        }
        return toRet;
    }

    public static String getReportPluginProperty(Project prj, String groupId, String artifactId, String property, String report) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getReportPluginPropertyImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, property, report);
    }

    public static String getReportPluginProperty(MavenProject prj, String groupId, String artifactId, String property, String report) {
        return PluginPropertyUtils.getReportPluginPropertyImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, property, report);
    }

    private static String getReportPluginPropertyImpl(MavenProject prj, NBPluginParameterExpressionEvaluator eval, String groupId, String artifactId, String property, String report) {
        String toRet = null;
        for (ReportPlugin plug : prj.getReportPlugins()) {
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getReportSets() != null) {
                ReportSet exe;
                Iterator i$ = plug.getReportSets().iterator();
                while (i$.hasNext() && (!(exe = (ReportSet)i$.next()).getReports().contains(report) || (toRet = PluginPropertyUtils.checkConfiguration(eval, exe.getConfiguration(), property)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkConfiguration(eval, plug.getConfiguration(), property);
        }
        return toRet;
    }

    public static String getPluginVersion(MavenProject prj, String groupId, String artifactId) {
        String toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Plugin plug : prj.getBuildPlugins()) {
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            toRet = plug.getVersion();
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Plugin plug : prj.getPluginManagement().getPlugins()) {
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = plug.getVersion();
                break;
            }
        }
        return toRet;
    }

    private static String checkConfiguration(NBPluginParameterExpressionEvaluator eval, Object conf, String property) {
        Xpp3Dom dom;
        Xpp3Dom source;
        if (conf != null && (source = (dom = (Xpp3Dom)conf).getChild(property)) != null) {
            try {
                Object evaluated = eval.evaluate(source.getValue().trim());
                return evaluated != null ? "" + evaluated : source.getValue().trim();
            }
            catch (ExpressionEvaluationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return source.getValue().trim();
            }
        }
        return null;
    }

    public static String[] getPluginPropertyList(Project prj, String groupId, String artifactId, String multiproperty, String singleproperty, String goal) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyListImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, multiproperty, singleproperty, goal);
    }

    public static String[] getPluginPropertyList(MavenProject prj, String groupId, String artifactId, String multiproperty, String singleproperty, String goal) {
        return PluginPropertyUtils.getPluginPropertyListImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, multiproperty, singleproperty, goal);
    }

    private static String[] getPluginPropertyListImpl(MavenProject prj, NBPluginParameterExpressionEvaluator eval, String groupId, String artifactId, String multiproperty, String singleproperty, String goal) {
        String[] toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Plugin plug : prj.getBuildPlugins()) {
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getExecutions() != null && goal != null) {
                PluginExecution exe;
                Iterator i$ = plug.getExecutions().iterator();
                while (i$.hasNext() && (!(exe = (PluginExecution)i$.next()).getGoals().contains(goal) && !("default-" + goal).equals(exe.getId()) || (toRet = PluginPropertyUtils.checkListConfiguration(eval, exe.getConfiguration(), multiproperty, singleproperty)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkListConfiguration(eval, plug.getConfiguration(), multiproperty, singleproperty);
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Plugin plug : prj.getPluginManagement().getPlugins()) {
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = PluginPropertyUtils.checkListConfiguration(eval, plug.getConfiguration(), multiproperty, singleproperty);
                break;
            }
        }
        return toRet;
    }

    public static String[] getReportPluginPropertyList(Project prj, String groupId, String artifactId, String multiproperty, String singleproperty, String goal) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getReportPluginPropertyListImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, multiproperty, singleproperty, goal);
    }

    public static String[] getReportPluginPropertyList(MavenProject prj, String groupId, String artifactId, String multiproperty, String singleproperty, String goal) {
        return PluginPropertyUtils.getReportPluginPropertyListImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, multiproperty, singleproperty, goal);
    }

    private static String[] getReportPluginPropertyListImpl(MavenProject prj, NBPluginParameterExpressionEvaluator eval, String groupId, String artifactId, String multiproperty, String singleproperty, String goal) {
        String[] toRet = null;
        for (ReportPlugin plug : prj.getReportPlugins()) {
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getReportSets() != null) {
                ReportSet exe;
                Iterator i$ = plug.getReportSets().iterator();
                while (i$.hasNext() && (!(exe = (ReportSet)i$.next()).getReports().contains(goal) || (toRet = PluginPropertyUtils.checkListConfiguration(eval, exe.getConfiguration(), multiproperty, singleproperty)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkListConfiguration(eval, plug.getConfiguration(), multiproperty, singleproperty);
        }
        if (toRet == null && prj.getPluginManagement() != null) {
            for (ReportPlugin plug : prj.getPluginManagement().getPlugins()) {
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = PluginPropertyUtils.checkListConfiguration(eval, plug.getConfiguration(), multiproperty, singleproperty);
                break;
            }
        }
        return toRet;
    }

    private static String[] checkListConfiguration(NBPluginParameterExpressionEvaluator eval, Object conf, String multiproperty, String singleproperty) {
        Xpp3Dom dom;
        Xpp3Dom source;
        if (conf != null && (source = (dom = (Xpp3Dom)conf).getChild(multiproperty)) != null) {
            Xpp3Dom[] childs;
            ArrayList<String> toRet = new ArrayList<String>();
            for (Xpp3Dom ch : childs = source.getChildren(singleproperty)) {
                try {
                    String chvalue = ch.getValue() == null ? "" : ch.getValue().trim();
                    Object evaluated = eval.evaluate(chvalue);
                    toRet.add(evaluated != null ? "" + evaluated : chvalue);
                }
                catch (ExpressionEvaluationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return toRet.toArray(new String[toRet.size()]);
        }
        return null;
    }

    public static Properties getPluginPropertyParameter(Project prj, String groupId, String artifactId, String propertyParameter, String goal) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyParameterImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, propertyParameter, goal);
    }

    public static Properties getPluginPropertyParameter(MavenProject prj, String groupId, String artifactId, String propertyParameter, String goal) {
        return PluginPropertyUtils.getPluginPropertyParameterImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, propertyParameter, goal);
    }

    private static Properties getPluginPropertyParameterImpl(MavenProject prj, NBPluginParameterExpressionEvaluator eval, String groupId, String artifactId, String propertyParameter, String goal) {
        Properties toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Plugin plug : prj.getBuildPlugins()) {
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getExecutions() != null && goal != null) {
                PluginExecution exe;
                Iterator i$ = plug.getExecutions().iterator();
                while (i$.hasNext() && (!(exe = (PluginExecution)i$.next()).getGoals().contains(goal) && !("default-" + goal).equals(exe.getId()) || (toRet = PluginPropertyUtils.checkPropertiesConfiguration(eval, exe.getConfiguration(), propertyParameter)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkPropertiesConfiguration(eval, plug.getConfiguration(), propertyParameter);
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Plugin plug : prj.getPluginManagement().getPlugins()) {
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = PluginPropertyUtils.checkPropertiesConfiguration(eval, plug.getConfiguration(), propertyParameter);
                break;
            }
        }
        return toRet;
    }

    private static Properties checkPropertiesConfiguration(NBPluginParameterExpressionEvaluator eval, Object conf, String propertyParameter) {
        Xpp3Dom dom;
        Xpp3Dom source;
        if (conf != null && (source = (dom = (Xpp3Dom)conf).getChild(propertyParameter)) != null) {
            Xpp3Dom[] childs;
            Properties toRet = new Properties();
            for (Xpp3Dom ch : childs = source.getChildren()) {
                try {
                    String val = ch.getValue();
                    if (val == null) {
                        if (ch.getChildCount() != 2) continue;
                        Xpp3Dom nameDom = ch.getChild("name");
                        Xpp3Dom valueDom = ch.getChild("value");
                        if (nameDom == null || valueDom == null) continue;
                        String name = nameDom.getValue();
                        String value = valueDom.getValue();
                        Object evaluated = eval.evaluate(value);
                        if (name == null || value == null) continue;
                        toRet.put(name, evaluated != null ? "" + evaluated : value);
                        continue;
                    }
                    Object evaluated = eval.evaluate(val.trim());
                    toRet.put(ch.getName(), evaluated != null ? "" + evaluated : ch.getValue().trim());
                }
                catch (ExpressionEvaluationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return toRet;
        }
        return null;
    }

    private static NBPluginParameterExpressionEvaluator createEvaluator(NbMavenProjectImpl prj) {
        Settings ss = EmbedderFactory.getProjectEmbedder().getSettings();
        ss.setLocalRepository(EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir());
        return new NBPluginParameterExpressionEvaluator(prj.getOriginalMavenProject(), ss, prj.createSystemPropsForPropertyExpressions());
    }

    private static NBPluginParameterExpressionEvaluator createEvaluator(MavenProject prj) {
        NbMavenProjectImpl project;
        Project p;
        FileObject bsd;
        Properties props = new Properties();
        File basedir = prj.getBasedir();
        if (basedir != null && (bsd = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)basedir))) != null && (p = FileOwnerQuery.getOwner((FileObject)bsd)) != null && (project = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class)) != null) {
            props = project.createSystemPropsForPropertyExpressions();
        }
        Settings ss = EmbedderFactory.getProjectEmbedder().getSettings();
        ss.setLocalRepository(EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir());
        return new NBPluginParameterExpressionEvaluator(prj, ss, props);
    }
}

