/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.indent;

import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.indent.TokenItem;

public class IndentSupport {
    protected CodeStyle codeStyle;
    protected TokenSequence<TokenId> ts;

    protected TokenItem findToken(TokenItem startToken, TokenItem limitToken, CppTokenId tokenID, boolean backward) {
        if (backward) {
            if (startToken != null && startToken.equals(limitToken)) {
                return null;
            }
            startToken = this.getPreviousToken(startToken);
            if (limitToken != null) {
                limitToken = limitToken.getPrevious();
            }
        }
        while (startToken != null && startToken.equals(limitToken)) {
            if (startToken.getTokenID() == tokenID) {
                return startToken;
            }
            startToken = backward ? startToken.getPrevious() : startToken.getNext();
        }
        return null;
    }

    protected TokenItem findMatchingToken(TokenItem startToken, TokenItem limitToken, CppTokenId matchTokenID, boolean backward) {
        TokenItem token;
        int depth = 0;
        TokenId startTokenID = startToken.getTokenID();
        TokenItem tokenItem = token = backward ? startToken.getPrevious() : startToken.getNext();
        while (token != null && !token.equals(limitToken)) {
            if (token.getTokenID() == matchTokenID) {
                if (depth-- == 0) {
                    return token;
                }
            } else if (token.getTokenID() == startTokenID) {
                ++depth;
            }
            token = backward ? token.getPrevious() : token.getNext();
        }
        return null;
    }

    protected TokenItem findImportantToken(TokenItem startToken, TokenItem limitToken, boolean backward) {
        if (backward) {
            if (startToken != null && startToken.equals(limitToken)) {
                return null;
            }
            startToken = this.getPreviousToken(startToken);
            if (limitToken != null) {
                limitToken = limitToken.getPrevious();
            }
        }
        while (startToken != null && !startToken.equals(limitToken)) {
            if (this.isImportant(startToken)) {
                return startToken;
            }
            startToken = backward ? startToken.getPrevious() : startToken.getNext();
        }
        return null;
    }

    private boolean isComment(TokenItem token) {
        TokenId tokenID = token.getTokenID();
        if (tokenID instanceof CppTokenId) {
            switch ((CppTokenId)tokenID) {
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: 
                case DOXYGEN_LINE_COMMENT: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isImportant(TokenItem token) {
        return !this.isComment(token) && !this.isWhitespace(token);
    }

    private boolean isWhitespace(TokenItem token) {
        return "whitespace".equals(token.getTokenID().primaryCategory());
    }

    protected TokenItem findAnyToken(TokenItem startToken, TokenItem limitToken, CppTokenId[] tokenIDArray, boolean backward) {
        if (backward) {
            if (startToken != null && startToken.equals(limitToken)) {
                return null;
            }
            startToken = this.getPreviousToken(startToken);
            if (limitToken != null) {
                limitToken = limitToken.getPrevious();
            }
        }
        while (startToken != null && !startToken.equals(limitToken)) {
            for (int i = 0; i < tokenIDArray.length; ++i) {
                if (startToken.getTokenID() != tokenIDArray[i]) continue;
                return startToken;
            }
            startToken = backward ? startToken.getPrevious() : startToken.getNext();
        }
        return null;
    }

    protected TokenItem findStatementStart(TokenItem token) {
        return this.findStatementStart(token, false);
    }

    protected TokenItem findStatementStart(TokenItem token, boolean outermost) {
        TokenId tokenID;
        TokenItem t = this.findStatement(token);
        if (t != null && (tokenID = t.getTokenID()) instanceof CppTokenId) {
            switch ((CppTokenId)tokenID) {
                case SEMICOLON: {
                    TokenItem scss = this.findStatement(t);
                    if (scss == null) {
                        return token;
                    }
                    TokenId scssTokenID = scss.getTokenID();
                    if (scssTokenID instanceof CppTokenId) {
                        TokenId bscssTokenID;
                        switch ((CppTokenId)scssTokenID) {
                            case SEMICOLON: 
                            case LBRACE: 
                            case RBRACE: 
                            case COLON: 
                            case CASE: 
                            case DEFAULT: {
                                return t;
                            }
                            case DO: 
                            case FOR: 
                            case IF: 
                            case WHILE: 
                            case PRIVATE: 
                            case PROTECTED: 
                            case PUBLIC: {
                                return this.findStatementStart(t, outermost);
                            }
                            case ELSE: {
                                TokenItem ifss = this.findIf(scss);
                                if (ifss != null) {
                                    return this.findStatementStart(ifss, outermost);
                                }
                                return scss;
                            }
                        }
                        TokenItem bscss = this.findStatement(scss);
                        if (bscss != null && (bscssTokenID = bscss.getTokenID()) instanceof CppTokenId) {
                            switch ((CppTokenId)bscssTokenID) {
                                case SEMICOLON: 
                                case LBRACE: 
                                case RBRACE: 
                                case COLON: {
                                    return scss;
                                }
                                case DO: 
                                case FOR: 
                                case IF: 
                                case WHILE: {
                                    return this.findStatementStart(bscss, outermost);
                                }
                                case ELSE: {
                                    TokenItem ifss = this.findIf(bscss);
                                    if (ifss != null) {
                                        return this.findStatementStart(ifss, outermost);
                                    }
                                    return bscss;
                                }
                            }
                        }
                    }
                    return scss;
                }
                case LBRACE: {
                    return token;
                }
                case RBRACE: {
                    TokenItem lbss;
                    TokenItem lb = this.findMatchingToken(t, null, CppTokenId.LBRACE, true);
                    if (lb != null && (lbss = this.findStatement(lb)) != null) {
                        TokenId lbssTokenID = lbss.getTokenID();
                        if (lbssTokenID instanceof CppTokenId) {
                            switch ((CppTokenId)lbssTokenID) {
                                case ELSE: {
                                    TokenItem ifss = this.findIf(lbss);
                                    if (ifss != null) {
                                        return this.findStatementStart(ifss, outermost);
                                    }
                                    return lbss;
                                }
                                case CATCH: {
                                    TokenItem tryss = this.findTry(lbss);
                                    if (tryss != null) {
                                        return this.findStatementStart(tryss, outermost);
                                    }
                                    return lbss;
                                }
                                case DO: 
                                case FOR: 
                                case IF: 
                                case WHILE: {
                                    return this.findStatementStart(lbss, outermost);
                                }
                            }
                        }
                        if (lbss.getTokenID() == CppTokenId.LBRACE) {
                            return t;
                        }
                        return lbss;
                    }
                    return t;
                }
                case COLON: 
                case CASE: 
                case DEFAULT: {
                    return token;
                }
                case ELSE: {
                    TokenItem ifss = this.findIf(t);
                    if (ifss != null) {
                        if (!outermost) {
                            return ifss;
                        }
                        return this.findStatementStart(ifss, outermost);
                    }
                    return t;
                }
                case DO: 
                case FOR: 
                case IF: 
                case WHILE: {
                    if (!outermost) {
                        return t;
                    }
                    return this.findStatementStart(t, outermost);
                }
                case IDENTIFIER: {
                    return t;
                }
            }
            return t;
        }
        return token;
    }

    protected TokenItem findStatement(TokenItem token) {
        TokenItem lit = null;
        boolean firstColon = true;
        for (TokenItem t = this.getPreviousToken(token); t != null; t = t.getPrevious()) {
            TokenId tTokenID = t.getTokenID();
            if (tTokenID instanceof CppTokenId) {
                switch ((CppTokenId)tTokenID) {
                    case SEMICOLON: {
                        if (this.isForLoopSemicolon(t)) break;
                        return lit != null ? lit : t;
                    }
                    case LBRACE: 
                    case ELSE: {
                        return lit != null ? lit : t;
                    }
                    case RBRACE: {
                        if (!this.isArrayInitializationBraceBlock(t, null)) {
                            return lit != null ? lit : t;
                        }
                        t = this.findMatchingToken(t, null, CppTokenId.LBRACE, true);
                        break;
                    }
                    case COLON: {
                        TokenItem prev;
                        TokenId ttTokenID;
                        TokenItem tt = this.findAnyToken(t, null, new CppTokenId[]{CppTokenId.CASE, CppTokenId.DEFAULT, CppTokenId.PUBLIC, CppTokenId.PRIVATE, CppTokenId.PROTECTED, CppTokenId.LBRACE, CppTokenId.RBRACE, CppTokenId.SEMICOLON, CppTokenId.QUESTION}, true);
                        if (tt != null && (ttTokenID = tt.getTokenID()) instanceof CppTokenId) {
                            switch ((CppTokenId)ttTokenID) {
                                case CASE: 
                                case DEFAULT: 
                                case PRIVATE: 
                                case PROTECTED: 
                                case PUBLIC: {
                                    return lit != null ? lit : t;
                                }
                            }
                        }
                        if ((prev = this.findImportantToken(t, null, true)) != null && prev.getTokenID() == CppTokenId.RPAREN) {
                            t = prev;
                            break;
                        }
                        if (lit != null && firstColon && tt == null) {
                            return lit;
                        }
                        firstColon = false;
                        break;
                    }
                    case DO: 
                    case CASE: 
                    case DEFAULT: 
                    case SWITCH: {
                        return t;
                    }
                    case FOR: 
                    case IF: 
                    case WHILE: {
                        TokenItem mt;
                        if (lit != null && lit.getTokenID() == CppTokenId.LPAREN && (mt = this.findMatchingToken(lit, token, CppTokenId.RPAREN, false)) != null && (mt = mt.getNext()) != null && (mt = this.findImportantToken(mt, token, false)) != null) {
                            return mt;
                        }
                        return t;
                    }
                }
            }
            if (!this.isImportant(t)) continue;
            lit = t;
        }
        return lit;
    }

    protected TokenItem findIf(TokenItem elseToken) {
        assert (elseToken != null && elseToken.getTokenID() == CppTokenId.ELSE);
        int braceDepth = 0;
        int elseDepth = 0;
        block7: while ((elseToken = this.findStatement(elseToken)) != null) {
            TokenId elseTokenID = elseToken.getTokenID();
            if (!(elseTokenID instanceof CppTokenId)) continue;
            switch ((CppTokenId)elseTokenID) {
                case LBRACE: {
                    if (--braceDepth >= 0) break;
                    return null;
                }
                case RBRACE: {
                    ++braceDepth;
                    break;
                }
                case ELSE: {
                    if (braceDepth != 0) break;
                    ++elseDepth;
                    break;
                }
                case SEMICOLON: 
                case COLON: 
                case DO: 
                case FOR: 
                case WHILE: 
                case CASE: 
                case DEFAULT: {
                    break;
                }
                case IF: {
                    if (braceDepth != 0 || elseDepth-- != 0) continue block7;
                    return elseToken;
                }
            }
        }
        return null;
    }

    protected TokenItem findSwitch(TokenItem caseToken) {
        assert (caseToken != null && (caseToken.getTokenID() == CppTokenId.CASE || caseToken.getTokenID() == CppTokenId.DEFAULT));
        int braceDepth = 1;
        while ((caseToken = this.findStatement(caseToken)) != null) {
            TokenId caseTokenID = caseToken.getTokenID();
            if (!(caseTokenID instanceof CppTokenId)) continue;
            switch ((CppTokenId)caseTokenID) {
                case LBRACE: {
                    if (--braceDepth >= 0) break;
                    return null;
                }
                case RBRACE: {
                    ++braceDepth;
                    break;
                }
                case DEFAULT: 
                case SWITCH: {
                    if (braceDepth != 0) break;
                    return caseToken;
                }
            }
        }
        return null;
    }

    protected TokenItem findClassifier(TokenItem visibilityToken) {
        int braceDepth = 1;
        TokenItem classifierToken = visibilityToken;
        while ((classifierToken = this.findStatement(classifierToken)) != null) {
            TokenId classifierTokenID = classifierToken.getTokenID();
            if (!(classifierTokenID instanceof CppTokenId)) continue;
            switch ((CppTokenId)classifierTokenID) {
                case LBRACE: {
                    if (--braceDepth < 0) {
                        return null;
                    }
                    if (braceDepth != 0) break;
                    while ((classifierToken = classifierToken.getPrevious()) != null) {
                        classifierTokenID = classifierToken.getTokenID();
                        if (!(classifierTokenID instanceof CppTokenId)) continue;
                        switch ((CppTokenId)classifierTokenID) {
                            case CLASS: 
                            case STRUCT: 
                            case ENUM: 
                            case UNION: {
                                return classifierToken;
                            }
                        }
                    }
                    return null;
                }
                case RBRACE: {
                    ++braceDepth;
                }
            }
        }
        return null;
    }

    protected TokenItem findTry(TokenItem catchToken) {
        assert (catchToken != null && catchToken.getTokenID() == CppTokenId.CATCH);
        int braceDepth = 0;
        while ((catchToken = this.findStatement(catchToken)) != null) {
            TokenId catchTokenID = catchToken.getTokenID();
            if (!(catchTokenID instanceof CppTokenId)) continue;
            switch ((CppTokenId)catchTokenID) {
                case LBRACE: {
                    if (--braceDepth >= 0) break;
                    return null;
                }
                case RBRACE: {
                    ++braceDepth;
                    break;
                }
                case TRY: {
                    if (braceDepth != 0) break;
                    return catchToken;
                }
            }
        }
        return null;
    }

    protected boolean isFieldComma(TokenItem token) {
        TokenItem itm;
        while (token != null && token.getTokenID() == CppTokenId.COMMA && (itm = this.findStatementStart(token)) != token) {
            token = itm;
        }
        if (token != null) {
            itm = this.findImportantToken(token, null, true);
            if (itm != null && itm.getTokenID() == CppTokenId.LBRACE) {
                TokenItem startItem = this.findStatementStart(itm);
                if (startItem != null && (startItem.getTokenID() == CppTokenId.CLASS || startItem.getTokenID() == CppTokenId.STRUCT || startItem.getTokenID() == CppTokenId.UNION)) {
                    return true;
                }
            } else {
                if (itm != null && itm.getTokenID() == CppTokenId.SEMICOLON) {
                    return this.findClassifier(itm) != null;
                }
                if (itm != null && itm.getTokenID() == CppTokenId.RBRACE) {
                    return this.findClassifier(itm) != null;
                }
            }
        }
        return false;
    }

    protected boolean isEnumComma(TokenItem token) {
        TokenItem startItem;
        TokenItem itm;
        while (token != null && token.getTokenID() == CppTokenId.COMMA && (itm = this.findStatementStart(token)) != token) {
            token = itm;
        }
        return !(token == null || token.getTokenID() != CppTokenId.IDENTIFIER && token.getTokenID() != CppTokenId.DOT || (itm = this.findImportantToken(token, null, true)) == null || itm.getTokenID() != CppTokenId.LBRACE || (startItem = this.findStatementStart(itm)) == null || startItem.getTokenID() != CppTokenId.ENUM && this.findToken(startItem, itm, CppTokenId.ENUM, false) == null && this.findToken(startItem, itm, CppTokenId.EQ, false) == null);
    }

    protected boolean isForLoopSemicolon(TokenItem token) {
        assert (token != null && token.getTokenID() == CppTokenId.SEMICOLON);
        int parDepth = 0;
        int braceDepth = 0;
        boolean semicolonFound = false;
        block7: for (token = token.getPrevious(); token != null; token = token.getPrevious()) {
            TokenId tokenID = token.getTokenID();
            if (!(tokenID instanceof CppTokenId)) continue;
            switch ((CppTokenId)tokenID) {
                case LPAREN: {
                    if (parDepth == 0) {
                        TokenItem tp = this.findImportantToken(token, null, true);
                        return tp != null && tp.getTokenID() == CppTokenId.FOR;
                    }
                    --parDepth;
                    continue block7;
                }
                case RPAREN: {
                    ++parDepth;
                    continue block7;
                }
                case LBRACE: {
                    if (braceDepth == 0) {
                        return false;
                    }
                    --braceDepth;
                    continue block7;
                }
                case RBRACE: {
                    ++braceDepth;
                    continue block7;
                }
                case SEMICOLON: {
                    if (semicolonFound) {
                        return false;
                    }
                    semicolonFound = true;
                }
            }
        }
        return false;
    }

    protected boolean isStatement(TokenItem t) {
        boolean likeDeclaration = false;
        boolean findLParen = false;
        boolean findQuestion = false;
        int identifiers = 0;
        while (t != null) {
            TokenId tTokenID = t.getTokenID();
            if (tTokenID instanceof CppTokenId) {
                switch ((CppTokenId)tTokenID) {
                    case DO: 
                    case FOR: 
                    case IF: 
                    case WHILE: 
                    case ELSE: 
                    case CASE: 
                    case DEFAULT: 
                    case CATCH: 
                    case SWITCH: 
                    case TRY: 
                    case EQ: 
                    case LTLT: 
                    case GTGT: 
                    case PLUSEQ: 
                    case MINUSEQ: 
                    case LTLTEQ: 
                    case GTGTEQ: 
                    case AMPEQ: 
                    case BAREQ: 
                    case STAREQ: 
                    case SLASHEQ: 
                    case CARETEQ: 
                    case PERCENTEQ: 
                    case DELETE: 
                    case RETURN: 
                    case BREAK: 
                    case CONTINUE: 
                    case GOTO: 
                    case SIZEOF: 
                    case THIS: 
                    case THROW: 
                    case USING: {
                        return true;
                    }
                    case SEMICOLON: {
                        return !likeDeclaration;
                    }
                    case LBRACE: 
                    case PRIVATE: 
                    case PROTECTED: 
                    case PUBLIC: 
                    case CLASS: 
                    case ENUM: 
                    case UNION: 
                    case FRIEND: 
                    case EXPLICIT: 
                    case EXTERN: 
                    case STATIC: 
                    case OPERATOR: 
                    case NAMESPACE: 
                    case TEMPLATE: 
                    case VIRTUAL: 
                    case INLINE: {
                        return false;
                    }
                    case COLON: {
                        if (findQuestion) break;
                        return false;
                    }
                    case QUESTION: {
                        findQuestion = true;
                        break;
                    }
                    case SCOPE: {
                        if (findLParen || identifiers != 1) break;
                        likeDeclaration = true;
                        break;
                    }
                    case RPAREN: {
                        break;
                    }
                    case LPAREN: {
                        if (!findLParen && identifiers > 1) {
                            likeDeclaration = true;
                        }
                        findLParen = true;
                        break;
                    }
                    case STRUCT: 
                    case ASM: 
                    case AUTO: 
                    case BOOL: 
                    case CHAR: 
                    case DOUBLE: 
                    case EXPORT: 
                    case FLOAT: 
                    case INT: 
                    case LONG: 
                    case MUTABLE: 
                    case REGISTER: 
                    case SHORT: 
                    case SIGNED: 
                    case TYPEDEF: 
                    case TYPENAME: 
                    case UNSIGNED: 
                    case VOID: 
                    case WCHAR_T: 
                    case VOLATILE: 
                    case CONST: {
                        if (findLParen) break;
                        return false;
                    }
                    case IDENTIFIER: {
                        ++identifiers;
                    }
                }
            }
            t = t.getNext();
        }
        return true;
    }

    protected TokenItem findClassifierStart(TokenItem token) {
        while ((token = this.findStatement(token)) != null) {
            TokenId tokenID = token.getTokenID();
            if (!(tokenID instanceof CppTokenId)) continue;
            switch ((CppTokenId)tokenID) {
                case SEMICOLON: 
                case LBRACE: 
                case RBRACE: {
                    return null;
                }
                case TEMPLATE: {
                    return this.findStatementStart(token);
                }
            }
        }
        return null;
    }

    protected TokenItem getVisibility(TokenItem token) {
        TokenItem t = token;
        if (t != null) {
            t = token.getPrevious();
        }
        while (t != null) {
            TokenId tTokenID = t.getTokenID();
            if (tTokenID instanceof CppTokenId) {
                switch ((CppTokenId)tTokenID) {
                    case SEMICOLON: 
                    case LBRACE: 
                    case RBRACE: {
                        return null;
                    }
                    case PRIVATE: 
                    case PROTECTED: 
                    case PUBLIC: {
                        return t;
                    }
                }
            }
            t = t.getPrevious();
        }
        return null;
    }

    protected TokenItem getLeftParen(TokenItem token, TokenItem limitToken) {
        int depth = 0;
        block4: for (token = token.getPrevious(); token != null && !token.equals(limitToken); token = token.getPrevious()) {
            TokenId tokenID = token.getTokenID();
            if (!(tokenID instanceof CppTokenId)) continue;
            switch ((CppTokenId)tokenID) {
                case LPAREN: {
                    if (--depth >= 0) continue block4;
                    return token;
                }
                case RPAREN: {
                    ++depth;
                }
            }
        }
        return null;
    }

    protected boolean isArrayInitializationBraceBlock(TokenItem token, TokenItem limitToken) {
        int depth = 0;
        block5: for (token = token.getPrevious(); token != null && !token.equals(limitToken); token = token.getPrevious()) {
            TokenId tokenID = token.getTokenID();
            if (!(tokenID instanceof CppTokenId)) continue;
            switch ((CppTokenId)tokenID) {
                case RBRACE: {
                    ++depth;
                    continue block5;
                }
                case LBRACE: {
                    if (--depth >= 0) continue block5;
                    TokenItem prev = this.findImportantToken(token, limitToken, true);
                    return prev != null && (CppTokenId.RBRACKET.equals((Object)prev.getTokenID()) || CppTokenId.EQ.equals((Object)prev.getTokenID()));
                }
                case SEMICOLON: 
                case DO: 
                case FOR: 
                case IF: 
                case WHILE: {
                    if (depth != 0) continue block5;
                    return false;
                }
            }
        }
        return false;
    }

    protected CodeStyle getCodeStyle() {
        return this.codeStyle;
    }

    protected boolean expandTabs() {
        return this.codeStyle.expandTabToSpaces();
    }

    protected int getTabSize() {
        return this.codeStyle.getTabSize();
    }

    protected int getRightIndent() {
        int i = this.getShiftWidth();
        if (this.isHalfIndentNewlineBeforeBrace()) {
            return i / 2;
        }
        return i;
    }

    protected int getRightIndentSwitch() {
        int i = this.getShiftWidth();
        if (this.isHalfIndentNewlineBeforeBrace()) {
            return i / 2;
        }
        return i;
    }

    protected int getRightIndentDeclaration() {
        int i = this.getShiftWidth();
        if (this.isHalfIndentNewlineBeforeBraceDeclaration()) {
            return i / 2;
        }
        return i;
    }

    protected boolean indentCasesFromSwitch() {
        return this.getCodeStyle().indentCasesFromSwitch();
    }

    protected boolean indentNamespace() {
        return this.getCodeStyle().indentNamespace();
    }

    protected boolean isHalfIndentNewlineBeforeBrace() {
        return this.getCodeStyle().getFormatNewlineBeforeBrace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED;
    }

    protected boolean isHalfIndentNewlineBeforeBraceSwitch() {
        return this.getCodeStyle().getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED;
    }

    protected boolean isHalfIndentNewlineBeforeBraceDeclaration() {
        return this.getCodeStyle().getFormatNewlineBeforeBraceDeclaration() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED;
    }

    protected boolean isHalfIndentVisibility() {
        return this.getCodeStyle().indentVisibility() == CodeStyle.VisibilityIndent.HALF_INDENT;
    }

    protected boolean getFormatLeadingStarInComment() {
        return this.getCodeStyle().getFormatLeadingStarInComment();
    }

    protected int getFormatStatementContinuationIndent() {
        return this.getCodeStyle().getFormatStatementContinuationIndent();
    }

    protected int getShiftWidth() {
        return this.getCodeStyle().indentSize();
    }

    protected boolean alignMultilineCallArgs() {
        return this.getCodeStyle().alignMultilineCallArgs();
    }

    protected boolean alignMultilineIf() {
        return this.getCodeStyle().alignMultilineIfCondition();
    }

    protected boolean alignMultilineWhile() {
        return this.getCodeStyle().alignMultilineWhileCondition();
    }

    protected boolean alignMultilineFor() {
        return this.getCodeStyle().alignMultilineFor();
    }

    protected boolean alignMultilineMethodParams() {
        return this.getCodeStyle().alignMultilineMethodParams();
    }

    protected TokenItem getPreviousToken(TokenItem token) {
        if (token == null) {
            this.ts.moveEnd();
            while (this.ts.movePrevious()) {
                if (this.ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) continue;
                return new TokenItem(this.ts, true);
            }
            return null;
        }
        return token.getPrevious();
    }

    protected int go(TokenItem t) {
        TokenSequence<TokenId> tokenSeq = t.getTokenSequence();
        int aIndex = tokenSeq.index();
        tokenSeq.moveIndex(t.index());
        tokenSeq.moveNext();
        return aIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getTokenColumnAfterBrace(TokenItem t) {
        int column = this.getTokenColumn(t);
        TokenSequence<TokenId> tokenSeq = t.getTokenSequence();
        int aIndex = this.go(t);
        try {
            block12: while (tokenSeq.moveNext()) {
                TokenId tokenID = tokenSeq.token().id();
                if (!(tokenID instanceof CppTokenId)) continue;
                switch ((CppTokenId)tokenID) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        int n = column;
                        return n;
                    }
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: {
                        String text = ((Object)tokenSeq.token().text()).toString();
                        int i = text.lastIndexOf(10);
                        if (i < 0) {
                            column += text.length();
                        }
                        int n = column += text.length() - i + 1;
                        return n;
                    }
                    case WHITESPACE: {
                        int i;
                        String text = ((Object)tokenSeq.token().text()).toString();
                        for (i = 0; i < text.length(); ++i) {
                            char c = text.charAt(i);
                            if (c == '\t') {
                                column = (column / this.getTabSize() + 1) * this.getTabSize();
                                continue;
                            }
                            ++column;
                        }
                        continue block12;
                    }
                    case LBRACE: {
                        column += tokenSeq.token().length();
                        continue block12;
                    }
                }
                int n = column;
                return n;
            }
            int n = column;
            return n;
        }
        finally {
            tokenSeq.moveIndex(aIndex);
            tokenSeq.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTokenIndent(TokenItem t) {
        TokenSequence<TokenId> tokenSeq = t.getTokenSequence();
        int aIndex = this.go(t);
        try {
            int column = 0;
            block10: while (tokenSeq.movePrevious()) {
                TokenId tokenID = tokenSeq.token().id();
                if (!(tokenID instanceof CppTokenId)) continue;
                switch ((CppTokenId)tokenID) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        int n = column;
                        return n;
                    }
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: {
                        String text = ((Object)tokenSeq.token().text()).toString();
                        int i = text.lastIndexOf(10);
                        if (i < 0) {
                            column += text.length();
                            break;
                        }
                        int n = column += text.length() - i + 1;
                        return n;
                    }
                    case WHITESPACE: {
                        int i;
                        String text = ((Object)tokenSeq.token().text()).toString();
                        for (i = 0; i < text.length(); ++i) {
                            char c = text.charAt(i);
                            if (c == '\t') {
                                column = (column / this.getTabSize() + 1) * this.getTabSize();
                                continue;
                            }
                            ++column;
                        }
                        continue block10;
                    }
                    default: {
                        column = 0;
                    }
                }
            }
            int n = column;
            return n;
        }
        finally {
            tokenSeq.moveIndex(aIndex);
            tokenSeq.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTokenColumn(TokenItem t) {
        TokenSequence<TokenId> tokenSeq = t.getTokenSequence();
        int aIndex = this.go(t);
        try {
            int column = 0;
            block10: while (tokenSeq.movePrevious()) {
                TokenId tokenID = tokenSeq.token().id();
                if (!(tokenID instanceof CppTokenId)) continue;
                switch ((CppTokenId)tokenID) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        int n = column;
                        return n;
                    }
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: {
                        String text = ((Object)tokenSeq.token().text()).toString();
                        int i = text.lastIndexOf(10);
                        if (i < 0) {
                            column += text.length();
                            break;
                        }
                        int n = column += text.length() - i + 1;
                        return n;
                    }
                    case WHITESPACE: {
                        int i;
                        String text = ((Object)tokenSeq.token().text()).toString();
                        for (i = 0; i < text.length(); ++i) {
                            char c = text.charAt(i);
                            if (c == '\t') {
                                column = (column / this.getTabSize() + 1) * this.getTabSize();
                                continue;
                            }
                            ++column;
                        }
                        continue block10;
                    }
                    default: {
                        column += tokenSeq.token().length();
                    }
                }
            }
            int n = column;
            return n;
        }
        finally {
            tokenSeq.moveIndex(aIndex);
            tokenSeq.moveNext();
        }
    }
}

