/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.AddActionGroup;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.DeleteEJBDialog;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.GoToSourceActionGroup;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session.SessionChildren;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbTransferable;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbViewController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class SessionNode
extends AbstractNode
implements OpenCookie,
PropertyChangeListener {
    private final EjbViewController ejbViewController;

    public static SessionNode create(final String ejbClass, final EjbJar ejbModule, Project project) {
        SessionNode node = null;
        try {
            node = (SessionNode)ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, SessionNode>(){

                public SessionNode run(EjbJarMetadata metadata) throws Exception {
                    Ejb ejb = metadata.findByEjbClass(ejbClass);
                    if (ejb != null && ejb.getEjbName() != null) {
                        SessionNode node = new SessionNode(new InstanceContent(), new EjbViewController(ejbClass, ejbModule), ejb.getEjbName());
                        ejb.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)node, (Object)ejb));
                        return node;
                    }
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return node;
    }

    private SessionNode(InstanceContent instanceContent, EjbViewController controller, String ejbName) {
        super((Children)new SessionChildren(controller), (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.ejbViewController = controller;
        this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/ejb/session/SessionNodeIcon.gif");
        this.setName(ejbName + "");
        this.setDisplayName();
        instanceContent.add((Object)this);
        ElementHandle<TypeElement> beanClassHandle = this.ejbViewController.getBeanClass();
        if (beanClassHandle != null) {
            instanceContent.add(beanClassHandle);
        }
        if (this.ejbViewController.getBeanDo() != null) {
            instanceContent.add((Object)this.ejbViewController.getBeanDo().getPrimaryFile());
        }
        try {
            instanceContent.add((Object)this.ejbViewController.createEjbReference());
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    private void setDisplayName() {
        this.setDisplayName(this.ejbViewController.getDisplayName());
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if ("EjbName".equals(pce.getPropertyName())) {
            this.setDisplayName();
        }
    }

    public Action[] getActions(boolean context) {
        int nodesCount = Utilities.actionsGlobalContext().lookup(new Lookup.Template(Node.class)).allInstances().size();
        ArrayList<SystemAction> list = new ArrayList<SystemAction>();
        list.add(SystemAction.get(OpenAction.class));
        if (nodesCount == 1) {
            list.add(null);
            list.add(SystemAction.get(AddActionGroup.class));
            list.add(null);
            list.add(SystemAction.get(GoToSourceActionGroup.class));
        }
        return (Action[])list.toArray(new SystemAction[list.size()]);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return false;
    }

    public void destroy() throws IOException {
        super.destroy();
        String deleteOptions = DeleteEJBDialog.open(this.ejbViewController.getDisplayName());
        if (!deleteOptions.equals("deleteNothing")) {
            if (deleteOptions.equals("deleteOnlyDD")) {
                this.ejbViewController.delete(false);
            } else {
                this.ejbViewController.delete(true);
            }
        }
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        EjbReference ejbRef = this.ejbViewController.createEjbReference();
        StringBuffer ejbRefString = new StringBuffer();
        ejbRefString.append(this.ejbViewController.getLocalStringRepresentation("Session"));
        return new EjbTransferable(ejbRefString.toString(), ejbRef);
    }

    public Transferable clipboardCut() throws IOException {
        return this.clipboardCopy();
    }

    public void open() {
        FileObject fo = this.ejbViewController.getBeanFo();
        ElementHandle<TypeElement> beh = this.ejbViewController.getBeanClass();
        ElementOpen.open((FileObject)fo, beh);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Object getValue(String attributeName) {
        Object retValue = "customDelete".equals(attributeName) ? Boolean.TRUE : super.getValue(attributeName);
        return retValue;
    }
}

