/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.action;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.api.ejbjar.ResourceReference;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.MethodModelSupport;
import org.netbeans.modules.j2ee.common.queries.api.InjectionTargetQuery;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore._RetoucheUtil;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.ServiceLocatorStrategy;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class UseDatabaseGenerator {
    public void generate(FileObject fileObject, String className, J2eeModuleProvider j2eeModuleProvider, String datasourceReferenceName, Datasource datasource, boolean createServerResources, String serviceLocator) throws IOException, ConfigurationException {
        J2eeModule module;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        ServiceLocatorStrategy serviceLocatorStrategy = serviceLocator == null ? null : ServiceLocatorStrategy.create(project, fileObject, serviceLocator);
        EnterpriseReferenceContainer erc = (EnterpriseReferenceContainer)project.getLookup().lookup(EnterpriseReferenceContainer.class);
        if (Util.isJavaEE5orHigher((Project)project) && serviceLocatorStrategy == null && InjectionTargetQuery.isInjectionTarget((FileObject)fileObject, (String)className)) {
            boolean isStatic = InjectionTargetQuery.isStaticReferenceRequired((FileObject)fileObject, (String)className);
            String fieldName = Utils.makeJavaIdentifierPart(Utils.jndiNameToCamelCase(datasourceReferenceName, true, null));
            _RetoucheUtil.generateAnnotatedField(fileObject, className, "javax.annotation.Resource", fieldName, "javax.sql.DataSource", Collections.singletonMap("name", datasourceReferenceName), isStatic);
        } else {
            String jndiName = this.generateJNDILookup(datasourceReferenceName, erc, fileObject, className, datasource.getUrl());
            if (jndiName != null) {
                this.generateLookupMethod(fileObject, className, datasourceReferenceName, serviceLocatorStrategy);
            }
        }
        if (createServerResources) {
            try {
                j2eeModuleProvider.getConfigSupport().createDatasource(datasource.getJndiName(), datasource.getUrl(), datasource.getUsername(), datasource.getPassword(), datasource.getDriverClassName());
            }
            catch (DatasourceAlreadyExistsException daee) {
                Exceptions.printStackTrace((Throwable)daee);
            }
        }
        if (this.isWebOrAppClientModule(module = j2eeModuleProvider.getJ2eeModule())) {
            this.bindDataSourceReference(j2eeModuleProvider, datasourceReferenceName, datasource);
        } else if (this.isEjbModule(module)) {
            this.bindDataSourceReferenceForEjb(j2eeModuleProvider, datasourceReferenceName, datasource, fileObject, className);
        }
        if (serviceLocator != null) {
            erc.setServiceLocatorName(serviceLocator);
        }
    }

    private void bindDataSourceReference(J2eeModuleProvider j2eeModuleProvider, String dsRefName, Datasource datasource) throws ConfigurationException {
        String dsJndiName = datasource.getJndiName();
        j2eeModuleProvider.getConfigSupport().bindDatasourceReference(dsRefName, dsJndiName);
    }

    private void bindDataSourceReferenceForEjb(J2eeModuleProvider j2eeModuleProvider, String dsRefName, Datasource datasource, FileObject fileObject, final String className) throws ConfigurationException, IOException {
        final String[] ejbName = new String[1];
        final String[] ejbType = new String[1];
        MetadataModel metadataModel = EjbJar.getEjbJar((FileObject)fileObject).getMetadataModel();
        metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

            public Void run(EjbJarMetadata metadata) throws Exception {
                Ejb ejb = metadata.findByEjbClass(className);
                if (ejb != null) {
                    ejbName[0] = ejb.getEjbName();
                    if (ejb instanceof Session) {
                        ejbType[0] = "Session";
                    } else if (ejb instanceof MessageDriven) {
                        ejbType[0] = "MessageDriven";
                    } else if (ejb instanceof Entity) {
                        ejbType[0] = "Entity";
                    }
                }
                return null;
            }
        });
        if (ejbName[0] != null && ejbType[0] != null) {
            String dsJndiName = datasource.getJndiName();
            j2eeModuleProvider.getConfigSupport().bindDatasourceReferenceForEjb(ejbName[0], ejbType[0], dsRefName, dsJndiName);
        }
    }

    private boolean isWebOrAppClientModule(J2eeModule module) {
        J2eeModule.Type moduleType = module.getType();
        return J2eeModule.Type.WAR.equals(moduleType) || J2eeModule.Type.CAR.equals(moduleType);
    }

    private boolean isEjbModule(J2eeModule module) {
        return module.getType().equals(J2eeModule.Type.EJB);
    }

    private String generateJNDILookup(String datasourceReferenceName, EnterpriseReferenceContainer enterpriseReferenceContainer, FileObject fileObject, String className, String nodeName) throws IOException {
        ResourceReference resourceReference = ResourceReference.create((String)datasourceReferenceName, (String)DataSource.class.getName(), (String)"Container", (String)"Shareable", (String)nodeName);
        return enterpriseReferenceContainer.addResourceRef(resourceReference, fileObject, className);
    }

    private void generateLookupMethod(FileObject fileObject, final String className, final String datasourceReferenceName, ServiceLocatorStrategy slStrategy) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final String body = slStrategy == null ? this.getLookupCode(datasourceReferenceName) : this.getLookupCode(datasourceReferenceName, slStrategy, fileObject, className);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = workingCopy.getElements().getTypeElement(className);
                String methodName = "get" + Utils.makeJavaIdentifierPart(Utils.jndiNameToCamelCase(datasourceReferenceName, false, null));
                MethodModel methodModel = MethodModel.create((String)methodName, (String)DataSource.class.getName(), (String)body, Collections.emptyList(), Collections.singletonList(NamingException.class.getName()), Collections.singleton(Modifier.PRIVATE));
                MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                methodTree = (MethodTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)methodTree);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                ClassTree modifiedClassTree = workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
                workingCopy.rewrite((Tree)classTree, (Tree)modifiedClassTree);
            }
        }).commit();
    }

    private String getLookupCode(String jndiName, ServiceLocatorStrategy serviceLocatorStrategy, FileObject fileObject, String className) {
        String jdbcLookupString = serviceLocatorStrategy.genDataSource(jndiName, fileObject, className);
        return "return (javax.sql.DataSource) " + jdbcLookupString + ";\n";
    }

    private String getLookupCode(String jndiName) {
        return MessageFormat.format("javax.naming.Context c = new javax.naming.InitialContext();\nreturn (javax.sql.DataSource) c.lookup(\"java:comp/env/{0}\");\n", jndiName);
    }
}

