/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene;

import java.io.IOException;
import org.netbeans.modules.parsing.impl.indexing.IndexFactoryImpl;
import org.netbeans.modules.parsing.impl.indexing.lucene.DocumentBasedIndexManager;
import org.netbeans.modules.parsing.lucene.support.DocumentIndex;
import org.netbeans.modules.parsing.lucene.support.IndexDocument;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class LuceneIndexFactory
implements IndexFactoryImpl {
    private static final int VERSION = 1;

    @Override
    public IndexDocument createDocument(Indexable indexable) {
        assert (indexable != null);
        return IndexManager.createDocument((String)indexable.getRelativePath());
    }

    @Override
    public DocumentIndex createIndex(Context ctx) throws IOException {
        FileObject luceneIndexFolder = this.getIndexFolder(ctx.getIndexFolder());
        return DocumentBasedIndexManager.getDefault().getIndex(luceneIndexFolder.getURL(), DocumentBasedIndexManager.Mode.CREATE);
    }

    @Override
    public DocumentIndex getIndex(FileObject indexFolder) throws IOException {
        FileObject luceneIndexFolder = this.getIndexFolder(indexFolder);
        return DocumentBasedIndexManager.getDefault().getIndex(luceneIndexFolder.getURL(), DocumentBasedIndexManager.Mode.IF_EXIST);
    }

    private FileObject getIndexFolder(FileObject indexFolder) throws IOException {
        assert (indexFolder != null);
        String indexVersion = Integer.toString(1);
        FileObject luceneIndexFolder = FileUtil.createFolder((FileObject)indexFolder, (String)indexVersion);
        return luceneIndexFolder;
    }
}

