/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.parsing.impl.indexing.FileObjectProvider;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class FileObjectIndexable
implements IndexableImpl,
FileObjectProvider {
    private final FileObject root;
    private final String relativePath;
    private Object url;
    private String mimeType;
    private FileObject file;

    public FileObjectIndexable(FileObject root, FileObject file) {
        this(root, FileUtil.getRelativePath((FileObject)root, (FileObject)file));
        this.file = file;
    }

    public FileObjectIndexable(FileObject root, String relativePath) {
        Parameters.notNull((CharSequence)"root", (Object)root);
        Parameters.notNull((CharSequence)"relativePath", (Object)relativePath);
        this.root = root;
        this.relativePath = relativePath;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public URL getURL() {
        if (this.url == null) {
            try {
                FileObject f = this.getFileObject();
                this.url = f != null ? f.getURL() : Util.resolveUrl(this.root.getURL(), this.relativePath);
            }
            catch (FileStateInvalidException ex) {
                this.url = ex;
            }
            catch (MalformedURLException ex) {
                this.url = ex;
            }
        }
        return this.url instanceof URL ? (URL)this.url : null;
    }

    @Override
    public String getMimeType() {
        return this.mimeType == null ? "content/unknown" : this.mimeType;
    }

    @Override
    public boolean isTypeOf(String mimeType) {
        String mt;
        FileObject f;
        Parameters.notNull((CharSequence)"mimeType", (Object)mimeType);
        if (this.mimeType == null && (f = this.getFileObject()) != null && (mt = FileUtil.getMIMEType((FileObject)f, (String[])new String[]{mimeType})) != null && !mt.equals("content/unknown")) {
            this.mimeType = mt;
        }
        return this.mimeType == null ? false : this.mimeType.equals(mimeType);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileObjectIndexable other = (FileObjectIndexable)obj;
        if (!(this.root == other.root || this.root != null && this.root.equals(other.root))) {
            return false;
        }
        return this.relativePath == other.relativePath || this.relativePath != null && this.relativePath.equals(other.relativePath);
    }

    public int hashCode() {
        return this.relativePath != null ? this.relativePath.hashCode() : 0;
    }

    public String toString() {
        return "FileObjectIndexable@" + Integer.toHexString(System.identityHashCode(this)) + " [" + FileObjectIndexable.toURL(this.root) + "/" + this.getRelativePath() + "]";
    }

    @Override
    public FileObject getFileObject() {
        if (this.file == null) {
            this.file = this.root.getFileObject(this.relativePath);
        }
        return this.file == null ? null : (this.file.isValid() ? this.file : null);
    }

    private static String toURL(FileObject f) {
        try {
            return f.getURL().toString();
        }
        catch (FileStateInvalidException ex) {
            return f.getPath();
        }
    }
}

