/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public final class CacheFolder {
    private static final Logger LOG = Logger.getLogger(CacheFolder.class.getName());
    private static final String NB_USER_DIR = "netbeans.user";
    private static final String INDEX_DIR = "var" + File.separatorChar + "cache" + File.separatorChar + "index";
    private static final String SEGMENTS_FILE = "segments";
    private static final String SLICE_PREFIX = "s";
    private static FileObject cacheFolder;
    private static Properties segments;
    private static Map<String, String> invertedSegments;
    private static int index;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSegments(FileObject folder) throws IOException {
        if (segments == null) {
            assert (folder != null);
            segments = new Properties();
            invertedSegments = new HashMap<String, String>();
            FileObject segmentsFile = folder.getFileObject(SEGMENTS_FILE);
            if (segmentsFile != null) {
                InputStream in = segmentsFile.getInputStream();
                try {
                    segments.load(in);
                }
                finally {
                    in.close();
                }
            }
            for (Map.Entry<Object, Object> entry : segments.entrySet()) {
                String segment = (String)entry.getKey();
                String root = (String)entry.getValue();
                invertedSegments.put(root, segment);
                try {
                    index = Math.max(index, Integer.parseInt(segment.substring(SLICE_PREFIX.length())));
                }
                catch (NumberFormatException nfe) {
                    LOG.log(Level.FINE, null, nfe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeSegments(FileObject folder) throws IOException {
        assert (folder != null);
        File _file = FileUtil.toFile((FileObject)folder);
        assert (_file != null);
        FileObject segmentsFile = FileUtil.createData((File)new File(_file, SEGMENTS_FILE));
        OutputStream out = segmentsFile.getOutputStream();
        try {
            segments.store(out, null);
        }
        finally {
            out.close();
        }
    }

    public static synchronized URL getSourceRootForDataFolder(FileObject dataFolder) {
        FileObject segFolder = dataFolder.getParent();
        if (segFolder == null || !segFolder.equals(cacheFolder)) {
            return null;
        }
        String source = segments.getProperty(dataFolder.getName());
        if (source != null) {
            try {
                return new URL(source);
            }
            catch (IOException ioe) {
                LOG.log(Level.FINE, null, ioe);
            }
        }
        return null;
    }

    public static FileObject getDataFolder(URL root) throws IOException {
        return CacheFolder.getDataFolder(root, false);
    }

    public static FileObject getDataFolder(final URL root, final boolean onlyIfAlreadyExists) throws IOException {
        final FileObject _cacheFolder = CacheFolder.getCacheFolder();
        final FileObject[] dataFolder = new FileObject[]{null};
        _cacheFolder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                Class<CacheFolder> clazz = CacheFolder.class;
                synchronized (CacheFolder.class) {
                    CacheFolder.loadSegments(_cacheFolder);
                    String rootName = root.toExternalForm();
                    String slice = (String)invertedSegments.get(rootName);
                    if (slice == null) {
                        if (onlyIfAlreadyExists) {
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                        slice = CacheFolder.SLICE_PREFIX + ++index;
                        while (segments.getProperty(slice) != null) {
                            slice = CacheFolder.SLICE_PREFIX + ++index;
                        }
                        segments.put(slice, rootName);
                        invertedSegments.put(rootName, slice);
                        CacheFolder.storeSegments(_cacheFolder);
                    }
                    dataFolder[0] = onlyIfAlreadyExists ? _cacheFolder.getFileObject(slice) : FileUtil.createFolder((FileObject)_cacheFolder, (String)slice);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        return dataFolder[0];
    }

    public static synchronized Iterable<? extends FileObject> findRootsWithCacheUnderFolder(FileObject folder) throws IOException {
        URL folderURL = folder.getURL();
        String prefix = folderURL.toExternalForm();
        FileObject _cacheFolder = CacheFolder.getCacheFolder();
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        CacheFolder.loadSegments(_cacheFolder);
        for (Map.Entry<String, String> e : invertedSegments.entrySet()) {
            FileObject fo;
            if (!e.getKey().startsWith(prefix) || (fo = URLMapper.findFileObject((URL)new URL(e.getKey()))) == null) continue;
            result.add(fo);
        }
        return result;
    }

    public static synchronized FileObject getCacheFolder() {
        if (cacheFolder == null) {
            String nbUserDirProp = System.getProperty(NB_USER_DIR);
            if (nbUserDirProp == null) {
                throw new IllegalStateException("No netbeans.user system property");
            }
            File nbUserDir = new File(nbUserDirProp);
            File cache = FileUtil.normalizeFile((File)new File(nbUserDir, INDEX_DIR));
            if (!cache.exists()) {
                cache.mkdirs();
                if (!cache.exists()) {
                    throw new IllegalStateException("Can't create indices cache folder " + cache.getAbsolutePath());
                }
            }
            if (!cache.isDirectory()) {
                throw new IllegalStateException("Indices cache folder " + cache.getAbsolutePath() + " is not a folder");
            }
            if (!cache.canRead()) {
                throw new IllegalStateException("Can't read from indices cache folder " + cache.getAbsolutePath());
            }
            if (!cache.canWrite()) {
                throw new IllegalStateException("Can't write to indices cache folder " + cache.getAbsolutePath());
            }
            cacheFolder = FileUtil.toFileObject((File)cache);
            if (cacheFolder == null) {
                throw new IllegalStateException("Can't convert indices cache folder " + cache.getAbsolutePath() + " to FileObject");
            }
        }
        return cacheFolder;
    }

    public static synchronized void setCacheFolder(FileObject folder) {
        assert (folder != null && folder.canRead() && folder.canWrite());
        cacheFolder = folder;
        segments = null;
        invertedSegments = null;
        index = 0;
    }

    private CacheFolder() {
    }

    static {
        index = 0;
    }
}

