/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import java.util.List;
import org.netbeans.modules.mercurial.ui.log.DiffResultsView;
import org.netbeans.modules.mercurial.ui.log.DiffResultsViewForLine;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryAction;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryTopComponent;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class LogAction
extends SearchHistoryAction {
    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Log";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        this.openHistory(context, NbBundle.getMessage(LogAction.class, (String)"MSG_Log_TabTitle", (Object)Utils.getContextDisplayName((VCSContext)context)));
    }

    private void openHistory(VCSContext context, String title) {
        File repositoryRoot = this.getRepositoryRoot(context);
        File[] files = this.getFiles(context, repositoryRoot);
        if (files == null) {
            return;
        }
        LogAction.outputSearchContextTab(repositoryRoot, files, "MSG_Log_Title");
        SearchHistoryTopComponent tc = new SearchHistoryTopComponent(files);
        tc.setDisplayName(title);
        tc.open();
        tc.requestActive();
        if (files != null && (files.length == 1 && files[0].isFile() || files.length > 1 && Utils.shareCommonDataObject((File[])files))) {
            tc.search();
        }
    }

    public static void openSearch(File file, final int lineNumber) {
        SearchHistoryTopComponent tc = new SearchHistoryTopComponent(file, new SearchHistoryTopComponent.DiffResultsViewFactory(){

            @Override
            DiffResultsView createDiffResultsView(SearchHistoryPanel panel, List<RepositoryRevision> results) {
                return new DiffResultsViewForLine(panel, results, lineNumber);
            }
        });
        String tcTitle = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)file.getName());
        tc.setDisplayName(tcTitle);
        tc.open();
        tc.requestActive();
    }
}

