/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ActionsPanel
extends JPanel {
    private static final String DEFAULT_SUSPEND_ACTION = "default.suspend.action";
    private JPDABreakpoint breakpoint;
    private int defaultSuspendAction;
    private int checkedSuspendAction;
    private Preferences preferences = NbPreferences.forModule(JPDABreakpoint.class).node("debugging");
    private JComboBox cbSuspend;
    private JPanel checkBoxPanel;
    private JCheckBox defaultActionCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField tfPrintText;

    public ActionsPanel(JPDABreakpoint b) {
        this.breakpoint = b;
        this.initComponents();
        ResourceBundle bundle = NbBundle.getBundle(ActionsPanel.class);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultActionCheckBox, (String)bundle.getString("LBL_Use_As_Default_Option"));
        this.defaultActionCheckBox.setToolTipText(bundle.getString("TTT_Use_As_Default_Option"));
        this.checkBoxPanel.setPreferredSize(this.defaultActionCheckBox.getPreferredSize());
        this.cbSuspend.addItem(bundle.getString("LBL_CB_Actions_Panel_Suspend_None"));
        this.cbSuspend.addItem(bundle.getString("LBL_CB_Actions_Panel_Suspend_Current"));
        this.cbSuspend.addItem(bundle.getString("LBL_CB_Actions_Panel_Suspend_All"));
        switch (b.getSuspend()) {
            case 0: {
                this.cbSuspend.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.cbSuspend.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.cbSuspend.setSelectedIndex(2);
            }
        }
        this.checkedSuspendAction = this.defaultSuspendAction = this.preferences.getInt(DEFAULT_SUSPEND_ACTION, 1);
        if (this.defaultSuspendAction == this.cbSuspend.getSelectedIndex()) {
            this.defaultActionCheckBox.setVisible(false);
        } else {
            this.defaultActionCheckBox.setVisible(true);
            this.defaultActionCheckBox.setSelected(false);
        }
        if (b.getPrintText() != null) {
            this.tfPrintText.setText(b.getPrintText());
        }
        this.tfPrintText.setPreferredSize(new Dimension(30 * this.tfPrintText.getFontMetrics(this.tfPrintText.getFont()).charWidth('W'), this.tfPrintText.getPreferredSize().height));
        this.tfPrintText.setCaretPosition(0);
    }

    private void initComponents() {
        this.tfPrintText = new JTextField();
        this.jLabel1 = new JLabel();
        this.cbSuspend = new JComboBox();
        this.jLabel2 = new JLabel();
        this.checkBoxPanel = new JPanel();
        this.defaultActionCheckBox = new JCheckBox();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle");
        this.setBorder(BorderFactory.createTitledBorder(bundle.getString("L_Actions_Panel_BorderTitle")));
        this.setLayout(new GridBagLayout());
        this.tfPrintText.setToolTipText(bundle.getString("TTT_TF_Actions_Panel_Print_Text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.tfPrintText, gridBagConstraints);
        this.tfPrintText.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TF_Actions_Panel_Print_Text"));
        this.jLabel1.setLabelFor(this.cbSuspend);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)bundle.getString("L_Actions_Panel_Suspend"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(bundle.getString("ASCD_L_Actions_Panel_Suspend"));
        this.cbSuspend.setToolTipText(bundle.getString("TTT_CB_Actions_Panel_Suspend"));
        this.cbSuspend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.cbSuspendActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbSuspend, gridBagConstraints);
        this.cbSuspend.getAccessibleContext().setAccessibleDescription(bundle.getString("ASCD_CB_Actions_Panel_Suspend"));
        this.jLabel2.setLabelFor(this.tfPrintText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)bundle.getString("L_Actions_Panel_Print_Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionsPanel.class, (String)"ACSD_PrintText"));
        this.checkBoxPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.defaultActionCheckBox, (String)"jCheckBox1");
        this.defaultActionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.defaultActionCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.checkBoxPanel.add((Component)this.defaultActionCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.checkBoxPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionsPanel.class, (String)"ACSD_Actions"));
    }

    private void defaultActionCheckBoxActionPerformed(ActionEvent evt) {
        this.checkedSuspendAction = this.cbSuspend.getSelectedIndex();
    }

    private void cbSuspendActionPerformed(ActionEvent evt) {
        int selectedIndex = this.cbSuspend.getSelectedIndex();
        if (this.defaultSuspendAction == selectedIndex) {
            this.defaultActionCheckBox.setVisible(false);
        } else {
            this.defaultActionCheckBox.setVisible(true);
            this.defaultActionCheckBox.setSelected(false);
        }
        this.checkedSuspendAction = this.defaultSuspendAction;
    }

    public void ok() {
        String printText = this.tfPrintText.getText();
        if (printText.trim().length() > 0) {
            this.breakpoint.setPrintText(printText.trim());
        } else {
            this.breakpoint.setPrintText(null);
        }
        switch (this.cbSuspend.getSelectedIndex()) {
            case 0: {
                this.breakpoint.setSuspend(0);
                break;
            }
            case 1: {
                this.breakpoint.setSuspend(1);
                break;
            }
            case 2: {
                this.breakpoint.setSuspend(2);
            }
        }
        if (this.checkedSuspendAction != this.defaultSuspendAction) {
            this.preferences.putInt(DEFAULT_SUSPEND_ACTION, this.checkedSuspendAction);
        }
    }
}

