/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.connect.Connector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AbstractDICookie;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LaunchingDICookie;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.IOManager;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.util.NbBundle;

public class DebuggerOutput
extends LazyActionsManagerListener
implements PropertyChangeListener {
    private static Set<IOManager> managers = new HashSet<IOManager>();
    private JPDADebugger debugger;
    private SourcePath engineContext;
    private IOManager ioManager;
    private ContextProvider contextProvider;

    public DebuggerOutput(ContextProvider contextProvider) {
        String title;
        this.contextProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.engineContext = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        if (DebuggerManager.getDebuggerManager().getSessions().length == 1) {
            Iterator<IOManager> i = managers.iterator();
            while (i.hasNext()) {
                i.next().close();
            }
            managers = new HashSet<IOManager>();
        }
        if ((title = (String)contextProvider.lookupFirst(null, String.class)) == null) {
            title = NbBundle.getBundle(IOManager.class).getString("CTL_DebuggerConsole_Title");
        }
        this.ioManager = new IOManager(title);
        managers.add(this.ioManager);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
    }

    protected synchronized void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        this.debugger = null;
        this.engineContext = null;
        this.ioManager = null;
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        IOManager ioManager;
        int debuggerState;
        JPDAThread t;
        DebuggerOutput debuggerOutput = this;
        synchronized (debuggerOutput) {
            if (this.debugger == null) {
                return;
            }
            t = this.debugger.getCurrentThread();
            debuggerState = this.debugger.getState();
            ioManager = this.ioManager;
        }
        if (debuggerState == 1) {
            AbstractDICookie cookie = (AbstractDICookie)this.contextProvider.lookupFirst(null, AbstractDICookie.class);
            if (cookie instanceof AttachingDICookie) {
                AttachingDICookie c = (AttachingDICookie)cookie;
                if (c.getHostName() != null) {
                    this.print("CTL_Attaching_socket", new String[]{c.getHostName(), String.valueOf(c.getPortNumber())}, null);
                } else if (c.getSharedMemoryName() != null) {
                    this.print("CTL_Attaching_shmem", new String[]{c.getSharedMemoryName()}, null);
                } else if (c.getArgs().get("pid") != null) {
                    this.print("CTL_Attaching_pid", new String[]{((Connector.Argument)c.getArgs().get("pid")).toString()}, null);
                } else {
                    this.print("CTL_Attaching", null, null);
                }
            } else if (cookie instanceof ListeningDICookie) {
                ListeningDICookie c = (ListeningDICookie)cookie;
                if (c.getSharedMemoryName() != null) {
                    this.print("CTL_Listening_shmem", new String[]{c.getSharedMemoryName()}, null);
                } else {
                    this.print("CTL_Listening_socket", new String[]{String.valueOf(c.getPortNumber())}, null);
                }
            } else if (cookie instanceof LaunchingDICookie) {
                LaunchingDICookie c = (LaunchingDICookie)cookie;
                this.print("CTL_Launching", new String[]{c.getCommandLine()}, null);
            }
        } else if (debuggerState == 2) {
            this.print("CTL_Debugger_running", new String[0], null);
        } else if (debuggerState == 4) {
            Throwable e = null;
            try {
                DebuggerOutput c = this;
                synchronized (c) {
                    if (this.debugger != null) {
                        this.debugger.waitRunning();
                    }
                }
            }
            catch (DebuggerStartException ex) {
                e = ex.getTargetException();
            }
            if (e == null) {
                this.print("CTL_Debugger_finished", null, null);
            } else {
                String message = e.getMessage();
                if (e instanceof ConnectException) {
                    message = NbBundle.getBundle(DebuggerOutput.class).getString("CTL_Connection_refused");
                }
                if (e instanceof UnknownHostException) {
                    message = NbBundle.getBundle(DebuggerOutput.class).getString("CTL_Unknown_host");
                }
                if (message != null) {
                    ioManager.println(message, null);
                } else {
                    ioManager.println(e.toString(), null);
                }
            }
            ioManager.closeStream();
        } else if (debuggerState == 3) {
            if (t == null) {
                this.print("CTL_Debugger_stopped", null, null);
                return;
            }
            Session session = null;
            Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
            for (int i = 0; i < sessions.length; ++i) {
                if (sessions[i].lookupFirst(null, JPDADebugger.class) != this.debugger) continue;
                session = sessions[i];
                break;
            }
            String language = session != null ? session.getCurrentLanguage() : null;
            String threadName = t.getName();
            String methodName = t.getMethodName();
            String className = t.getClassName();
            int lineNumber = t.getLineNumber(language);
            EditorContext.Operation op = t.getCurrentOperation();
            List lastOperations = t.getLastOperations();
            EditorContext.Operation lastOperation = lastOperations != null && lastOperations.size() > 0 ? (EditorContext.Operation)lastOperations.get(lastOperations.size() - 1) : null;
            try {
                String sourceName = t.getSourceName(language);
                String relativePath = EditorContextBridge.getRelativePath(t, language);
                String url = null;
                DebuggerOutput debuggerOutput2 = this;
                synchronized (debuggerOutput2) {
                    if (relativePath != null && this.engineContext != null) {
                        url = this.engineContext.getURL(relativePath, true);
                    }
                }
                IOManager.Line line = null;
                if (lineNumber > 0 && url != null) {
                    line = new IOManager.Line(url, lineNumber, this.debugger);
                }
                if (op != null) {
                    boolean done;
                    boolean bl = done = op == lastOperation;
                    if (!done) {
                        this.print("CTL_Thread_stopped_before_op", new String[]{threadName, sourceName, methodName, String.valueOf(lineNumber), op.getMethodName()}, line);
                    } else {
                        this.print("CTL_Thread_stopped_after_op", new String[]{threadName, sourceName, methodName, String.valueOf(lineNumber), lastOperation.getMethodName()}, line);
                    }
                } else if (lineNumber > 0) {
                    this.print("CTL_Thread_stopped", new String[]{threadName, sourceName, methodName, String.valueOf(lineNumber)}, line);
                } else if (sourceName.length() > 0 && methodName.length() > 0) {
                    this.print("CTL_Thread_stopped_no_line", new String[]{threadName, sourceName, methodName}, line);
                } else {
                    this.print("CTL_Thread_stopped_no_line_no_source", new String[]{threadName}, line);
                }
            }
            catch (AbsentInformationException ex) {
                if (lineNumber > 0) {
                    this.print("CTL_Thread_stopped_no_info", new String[]{threadName, className, methodName, lineNumber > 0 ? String.valueOf(lineNumber) : ""}, null);
                }
                this.print("CTL_Thread_stopped_no_info_no_line", new String[]{threadName, className, methodName}, null);
            }
        }
    }

    public void actionPerformed(Object action, boolean success) {
        if (!success) {
            return;
        }
        if (action == ActionsManager.ACTION_CONTINUE) {
            this.print("CTL_Continue", null, null);
        } else if (action == ActionsManager.ACTION_STEP_INTO) {
            this.print("CTL_Step_Into", null, null);
        } else if (action == ActionsManager.ACTION_STEP_OUT) {
            this.print("CTL_Step_Out", null, null);
        } else if (action == ActionsManager.ACTION_STEP_OVER) {
            this.print("CTL_Step_Over", null, null);
        }
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(String message, String[] args, IOManager.Line line) {
        IOManager ioManager;
        String text = args == null ? NbBundle.getMessage(DebuggerOutput.class, (String)message) : new MessageFormat(NbBundle.getMessage(DebuggerOutput.class, (String)message)).format(args);
        DebuggerOutput debuggerOutput = this;
        synchronized (debuggerOutput) {
            ioManager = this.ioManager;
            if (ioManager == null) {
                return;
            }
        }
        ioManager.println(text, line);
    }
}

