/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class FieldBreakpoint
extends JPDABreakpoint {
    public static final String PROP_FIELD_NAME = "fieldName";
    public static final String PROP_CLASS_NAME = "className";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointType";
    public static final String PROP_INSTANCE_FILTERS = "instanceFilters";
    public static final String PROP_THREAD_FILTERS = "threadFilters";
    public static final int TYPE_ACCESS = 1;
    public static final int TYPE_MODIFICATION = 2;
    private String className = "";
    private String fieldName = "";
    private int type = 2;
    private String condition = "";
    private Map<JPDADebugger, ObjectVariable[]> instanceFilters;
    private Map<JPDADebugger, JPDAThread[]> threadFilters;

    private FieldBreakpoint() {
    }

    public static FieldBreakpoint create(String className, String fieldName, int breakpointType) {
        FieldBreakpointImpl b = new FieldBreakpointImpl();
        b.setClassName(className);
        b.setFieldName(fieldName);
        b.setBreakpointType(breakpointType);
        return b;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        if (className == this.className || className != null && this.className != null && this.className.equals(className)) {
            return;
        }
        String old = this.className;
        this.className = className;
        this.firePropertyChange(PROP_CLASS_NAME, old, className);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == this.fieldName || name != null && this.fieldName != null && this.fieldName.equals(name)) {
            return;
        }
        String old = this.fieldName;
        this.fieldName = name;
        this.firePropertyChange(PROP_FIELD_NAME, old, this.fieldName);
    }

    public ObjectVariable[] getInstanceFilters(JPDADebugger session) {
        if (this.instanceFilters != null) {
            return this.instanceFilters.get(session);
        }
        return null;
    }

    public void setInstanceFilters(JPDADebugger session, ObjectVariable[] instances) {
        Object[] objectArray;
        if (this.instanceFilters == null) {
            this.instanceFilters = new WeakHashMap<JPDADebugger, ObjectVariable[]>();
        }
        if (instances != null) {
            this.instanceFilters.put(session, instances);
        } else {
            this.instanceFilters.remove(session);
        }
        if (instances != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = session;
            objectArray = objectArray2;
            objectArray2[1] = instances;
        } else {
            objectArray = null;
        }
        this.firePropertyChange(PROP_INSTANCE_FILTERS, null, objectArray);
    }

    public JPDAThread[] getThreadFilters(JPDADebugger session) {
        if (this.threadFilters != null) {
            return this.threadFilters.get(session);
        }
        return null;
    }

    public void setThreadFilters(JPDADebugger session, JPDAThread[] threads) {
        Object[] objectArray;
        if (this.threadFilters == null) {
            this.threadFilters = new WeakHashMap<JPDADebugger, JPDAThread[]>();
        }
        if (threads != null) {
            this.threadFilters.put(session, threads);
        } else {
            this.threadFilters.remove(session);
        }
        if (threads != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = session;
            objectArray = objectArray2;
            objectArray2[1] = threads;
        } else {
            objectArray = null;
        }
        this.firePropertyChange(PROP_THREAD_FILTERS, null, objectArray);
    }

    public int getBreakpointType() {
        return this.type;
    }

    public void setBreakpointType(int type) {
        if (this.type == type) {
            return;
        }
        if (type != 2 && type != 1 && type != 3) {
            throw new IllegalArgumentException();
        }
        int old = this.type;
        this.type = type;
        this.firePropertyChange(PROP_BREAKPOINT_TYPE, old, type);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String cond) {
        if (cond != null) {
            cond = cond.trim();
        }
        String old = this.condition;
        this.condition = cond;
        this.firePropertyChange(PROP_CONDITION, old, cond);
    }

    public String toString() {
        return "FieldBreakpoint " + this.className + "." + this.fieldName;
    }

    private static final class FieldBreakpointImpl
    extends FieldBreakpoint
    implements ChangeListener,
    PropertyChangeListener {
        private FieldBreakpointImpl() {
        }

        public Breakpoint.GroupProperties getGroupProperties() {
            return new FieldGroupProperties();
        }

        @Override
        public void stateChanged(ChangeEvent chev) {
            Object source = chev.getSource();
            if (!(source instanceof Breakpoint.VALIDITY)) {
                throw new UnsupportedOperationException(chev.toString());
            }
            this.setValidity((Breakpoint.VALIDITY)source, chev.toString());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.enginePropertyChange(evt);
        }

        private final class FieldGroupProperties
        extends Breakpoint.GroupProperties {
            private FieldGroupProperties() {
            }

            public String getType() {
                return NbBundle.getMessage(FieldBreakpoint.class, (String)"FieldBrkp_Type");
            }

            public String getLanguage() {
                return "Java";
            }

            public FileObject[] getFiles() {
                ArrayList<FileObject> files = new ArrayList<FileObject>();
                String className = FieldBreakpointImpl.this.getClassName();
                if (!className.startsWith("*") && !className.endsWith("*")) {
                    JPDABreakpoint.fillFilesForClass(className, files);
                }
                return files.toArray(new FileObject[0]);
            }

            public Project[] getProjects() {
                FileObject[] files = this.getFiles();
                ArrayList<Project> projects = new ArrayList<Project>();
                for (FileObject f : files) {
                    while (!(f == null || (f = f.getParent()) != null && ProjectManager.getDefault().isProject(f))) {
                    }
                    if (f == null) continue;
                    try {
                        projects.add(ProjectManager.getDefault().findProject(f));
                    }
                    catch (IOException ex) {
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                }
                return projects.toArray(new Project[0]);
            }

            public DebuggerEngine[] getEngines() {
                return FieldBreakpointImpl.this.getEngines();
            }

            public boolean isHidden() {
                return FieldBreakpointImpl.this.isHidden();
            }
        }
    }
}

