/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.util;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Utils {
    private static final Pattern metadataPattern = Pattern.compile(".*\\" + File.separatorChar + "CVS(\\" + File.separatorChar + ".*|$)");
    private static Reference<Context> contextCached = new WeakReference<Object>(null);
    private static Reference<Node[]> contextNodesCached = new WeakReference<Object>(null);
    private static final FileFilter cvsFileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            if ("CVS".equals(pathname.getName())) {
                return false;
            }
            if (".cvsignore".equals(pathname.getName())) {
                return true;
            }
            return SharabilityQuery.getSharability((File)pathname) != 2;
        }
    };
    private static Logger T9Y_LOG = null;

    public static String createAnnotationFormat(String format) {
        String taf = org.netbeans.modules.versioning.util.Utils.skipUnsupportedVariables((String)format, (String[])new String[]{"{status}", "{tag}", "{revision}", "{binary}"});
        taf = taf.replaceAll("\\{revision}", "{0}").replaceAll("\\{status}", "{1}").replaceAll("\\{tag}", "{2}").replaceAll("\\{binary}", "{3}");
        return taf;
    }

    public static boolean isAnnotationFormatValid(String format) {
        boolean retval = true;
        if (format != null) {
            try {
                new MessageFormat(format);
            }
            catch (IllegalArgumentException ex) {
                CvsVersioningSystem.LOG.log(Level.FINER, "Bad user input - annotation format", ex);
                retval = false;
            }
        }
        return retval;
    }

    public static Context getCurrentContext(Node[] nodes) {
        Context ctx;
        if (nodes == null) {
            nodes = TopComponent.getRegistry().getActivatedNodes();
        }
        if (Arrays.equals(contextNodesCached.get(), nodes) && (ctx = contextCached.get()) != null) {
            return ctx;
        }
        VCSContext vcsCtx = VCSContext.forNodes((Node[])nodes);
        Context ctx2 = new Context(new HashSet(vcsCtx.computeFiles(cvsFileFilter)), new HashSet(vcsCtx.getRootFiles()), new HashSet(vcsCtx.getExclusions()));
        contextCached = new WeakReference<Context>(ctx2);
        contextNodesCached = new WeakReference<Node[]>(nodes);
        return ctx2;
    }

    public static Context getCurrentContext(Node[] nodes, int includingFileStatus, int includingFolderStatus, boolean onlyCachedStatus) {
        Context context = Utils.getCurrentContext(nodes);
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        File[] files = context.getRootFiles();
        for (int i = 0; i < files.length; ++i) {
            int status;
            File file = files[i];
            FileInformation fi = onlyCachedStatus ? cache.getCachedStatus(file) : cache.getStatus(file);
            int n = status = fi == null ? 8 : fi.getStatus();
            if (!(file.isDirectory() ? (status & includingFolderStatus) == 0 : (status & includingFileStatus) == 0)) continue;
            return Context.Empty;
        }
        if (context.getExclusions().isEmpty()) {
            return context;
        }
        HashSet<File> filteredFiles = new HashSet<File>(Arrays.asList(context.getFiles()));
        HashSet<File> rootFiles = new HashSet<File>(Arrays.asList(context.getRootFiles()));
        HashSet<File> rootFileExclusions = new HashSet<File>(context.getExclusions());
        Iterator i = filteredFiles.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            if (file.isDirectory()) {
                if ((cache.getStatus(file).getStatus() & includingFolderStatus) != 0) continue;
                i.remove();
                continue;
            }
            if ((cache.getStatus(file).getStatus() & includingFileStatus) != 0) continue;
            i.remove();
        }
        return new Context(filteredFiles, rootFiles, rootFileExclusions);
    }

    public static boolean isVersionedProject(Node node, boolean checkStatus) {
        Lookup lookup = node.getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        return Utils.isVersionedProject(project, checkStatus);
    }

    public static boolean isVersionedProject(Project project, boolean checkStatus) {
        if (project != null) {
            FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
            for (int j = 0; j < sourceGroups.length; ++j) {
                SourceGroup sourceGroup = sourceGroups[j];
                File f = FileUtil.toFile((FileObject)sourceGroup.getRootFolder());
                if (f == null) continue;
                if (checkStatus && (cache.getStatus(f).getStatus() & 0xFFFFFFFE) != 0) {
                    return true;
                }
                if (checkStatus || !CvsVersioningSystem.isManaged(f)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addProjectFiles(Collection filteredFiles, Collection rootFiles, Collection rootFilesExclusions, Project project) {
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
        for (int j = 0; j < sourceGroups.length; ++j) {
            SourceGroup sourceGroup = sourceGroups[j];
            FileObject srcRootFo = sourceGroup.getRootFolder();
            File rootFile = FileUtil.toFile((FileObject)srcRootFo);
            try {
                Utils.getCVSRootFor(rootFile);
            }
            catch (IOException e) {
                continue;
            }
            rootFiles.add(rootFile);
            boolean containsSubprojects = false;
            FileObject[] rootChildren = srcRootFo.getChildren();
            HashSet<File> projectFiles = new HashSet<File>(rootChildren.length);
            for (int i = 0; i < rootChildren.length; ++i) {
                FileObject rootChildFo = rootChildren[i];
                if ("CVS".equals(rootChildFo.getNameExt())) continue;
                File child = FileUtil.toFile((FileObject)rootChildFo);
                if (sourceGroup.contains(rootChildFo) || ".cvsignore".equals(rootChildFo.getNameExt())) {
                    projectFiles.add(child);
                    continue;
                }
                int status = cache.getStatus(child).getStatus();
                if (status == 2) continue;
                rootFilesExclusions.add(child);
                containsSubprojects = true;
            }
            if (containsSubprojects) {
                filteredFiles.addAll(projectFiles);
                continue;
            }
            filteredFiles.add(rootFile);
        }
    }

    public static Context getProjectsContext(Project[] projects) {
        HashSet filtered = new HashSet();
        HashSet roots = new HashSet();
        HashSet exclusions = new HashSet();
        for (int i = 0; i < projects.length; ++i) {
            Utils.addProjectFiles(filtered, roots, exclusions, projects[i]);
        }
        return new Context(filtered, roots, exclusions);
    }

    public static Context getProjectContext(Project project, File file) {
        Context context = Utils.getProjectsContext(new Project[]{project});
        if (context.getRootFiles().length == 0) {
            FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
            while (true) {
                File parent = file.getParentFile();
                assert (parent != null);
                if ((cache.getStatus(parent).getStatus() & 0xFF8) == 0) {
                    HashSet<File> files = new HashSet<File>(1);
                    files.add(file);
                    context = new Context(files, files, Collections.emptySet());
                    break;
                }
                file = parent;
            }
        }
        return context;
    }

    public static File[] toFileArray(Collection fileObjects) {
        HashSet<File> files = new HashSet<File>(fileObjects.size() * 4 / 3 + 1);
        Iterator i = fileObjects.iterator();
        while (i.hasNext()) {
            files.add(FileUtil.toFile((FileObject)((FileObject)i.next())));
        }
        files.remove(null);
        return files.toArray(new File[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCVSRootFor(File file) throws IOException {
        if (file.isFile()) {
            file = file.getParentFile();
        }
        while (file != null) {
            File rootFile = new File(file, "CVS/Root");
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(rootFile));
                String string = br.readLine();
                return string;
            }
            catch (FileNotFoundException e) {
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
            file = file.getParentFile();
        }
        throw new IOException("CVS/Root not found");
    }

    public static Window getCurrentWindow() {
        Window wnd = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (wnd instanceof Dialog || wnd instanceof Frame) {
            return wnd;
        }
        return WindowManager.getDefault().getMainWindow();
    }

    public static boolean isParentOrEqual(File parent, File file) {
        while (file != null) {
            if (file.equals(parent)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static String getRelativePath(File file) {
        String postfix = "";
        for (file = file.getParentFile(); file != null && !file.exists(); file = file.getParentFile()) {
            postfix = "/" + file.getName() + postfix;
        }
        if (file == null) {
            return "";
        }
        try {
            return CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getAbsolutePath(), "").substring(1) + postfix;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getSticky(File file) {
        if (file == null) {
            return null;
        }
        FileInformation info = CvsVersioningSystem.getInstance().getStatusCache().getStatus(file);
        if (info.getStatus() == 4) {
            return Utils.getSticky(file.getParentFile());
        }
        if (info.getStatus() == 2) {
            return null;
        }
        if (file.isDirectory()) {
            String std = CvsVersioningSystem.getInstance().getAdminHandler().getStickyTagForDirectory(file);
            if (std != null) {
                std = std.substring(1);
            }
            return std;
        }
        Entry entry = info.getEntry(file);
        if (entry != null) {
            String stickyInfo = null;
            if (entry.getTag() != null) {
                stickyInfo = entry.getTag();
            } else if (entry.getDate() != null) {
                stickyInfo = entry.getDateFormatted();
            }
            return stickyInfo;
        }
        return null;
    }

    public static String previousRevision(String revision) {
        int lastIndex;
        if (revision == null) {
            return null;
        }
        String[] nums = revision.split("\\.");
        assert (nums.length % 2 == 0) : "File revisions must consist from even tokens: " + revision;
        boolean cutoff = false;
        for (lastIndex = nums.length - 1; lastIndex > 1 && "1".equals(nums[lastIndex]); lastIndex -= 2) {
            cutoff = true;
        }
        if (lastIndex <= 0) {
            return null;
        }
        if (lastIndex == 1 && "1".equals(nums[lastIndex])) {
            return null;
        }
        int rev = Integer.parseInt(nums[lastIndex]);
        if (!cutoff) {
            --rev;
        }
        StringBuffer sb = new StringBuffer(nums[0]);
        for (int i = 1; i < lastIndex; ++i) {
            sb.append('.').append(nums[i]);
        }
        sb.append('.').append(rev);
        return sb.toString();
    }

    public static Project getProject(File file) {
        if (file == null) {
            return null;
        }
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return Utils.getProject(file.getParentFile());
        }
        return FileOwnerQuery.getOwner((FileObject)fo);
    }

    public static String createBranchRevisionNumber(String branchNumber) {
        StringBuilder sb = new StringBuilder();
        int idx = branchNumber.lastIndexOf(46);
        sb.append(branchNumber.substring(0, idx));
        sb.append(".0");
        sb.append(branchNumber.substring(idx));
        return sb.toString();
    }

    public static String formatBranches(LogInformation.Revision revision, boolean useNumbersIfNamesNotAvailable) {
        String branches = revision.getBranches();
        if (branches == null) {
            return "";
        }
        boolean branchNamesAvailable = true;
        StringBuilder branchNames = new StringBuilder();
        StringTokenizer st = new StringTokenizer(branches, ";");
        while (st.hasMoreTokens()) {
            String branchNumber = st.nextToken().trim();
            List names = revision.getLogInfoHeader().getSymNamesForRevision(Utils.createBranchRevisionNumber(branchNumber));
            if (names.size() > 0) {
                branchNames.append(((LogInformation.SymName)names.get(0)).getName());
            } else {
                branchNamesAvailable = false;
                if (!useNumbersIfNamesNotAvailable) break;
                branchNames.append(branchNumber);
            }
            branchNames.append("; ");
        }
        if (branchNamesAvailable || useNumbersIfNamesNotAvailable) {
            branchNames.delete(branchNames.length() - 2, branchNames.length());
        } else {
            branchNames.delete(0, branchNames.length());
        }
        return branchNames.toString();
    }

    public static boolean containsMetadata(File folder) {
        boolean ret;
        CvsVersioningSystem.LOG.log(Level.FINER, " containsMetadata {0}", new Object[]{folder});
        long t = System.currentTimeMillis();
        File repository = new File(folder, "CVS/Repository");
        File entries = new File(folder, "CVS/Entries");
        boolean bl = ret = repository.exists() && entries.exists();
        if (CvsVersioningSystem.LOG.isLoggable(Level.FINER)) {
            CvsVersioningSystem.LOG.log(Level.FINER, " containsMetadata returns {0} after {1} millis", new Object[]{ret, System.currentTimeMillis() - t});
        }
        return ret;
    }

    public static int getComparableStatus(int status) {
        switch (status) {
            case 64: {
                return 0;
            }
            case 128: {
                return 1;
            }
            case 2048: {
                return 10;
            }
            case 256: {
                return 11;
            }
            case 4: {
                return 12;
            }
            case 4096: {
                return 13;
            }
            case 16: {
                return 14;
            }
            case 1024: {
                return 30;
            }
            case 512: {
                return 31;
            }
            case 32: {
                return 32;
            }
            case 8: {
                return 50;
            }
            case 2: {
                return 100;
            }
            case 1: {
                return 101;
            }
            case 0: {
                return 102;
            }
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    public static boolean isPartOfCVSMetadata(File file) {
        return metadataPattern.matcher(file.getAbsolutePath()).matches();
    }

    public static FileObject mkfolders(File file) throws IOException {
        if ((file = FileUtil.normalizeFile((File)file)).isDirectory()) {
            return FileUtil.toFileObject((File)file);
        }
        File parent = file.getParentFile();
        String path = file.getName();
        while (!parent.isDirectory()) {
            path = parent.getName() + "/" + path;
            parent = parent.getParentFile();
        }
        FileObject fo = FileUtil.toFileObject((File)parent);
        return FileUtil.createFolder((FileObject)fo, (String)path);
    }

    public static boolean isTagValid(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '+' || c == '_') continue;
            return false;
        }
        return !name.equals("HEAD") && !name.equals("BASE");
    }

    public static void logT9Y(String msg) {
        if (T9Y_LOG == null) {
            T9Y_LOG = Logger.getLogger("org.netbeans.modules.versioning.system.cvss.t9y");
        }
        T9Y_LOG.log(Level.FINEST, msg);
    }

    public static class ByImportanceComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            FileInformation i1 = (FileInformation)o1;
            FileInformation i2 = (FileInformation)o2;
            return Utils.getComparableStatus(i1.getStatus()) - Utils.getComparableStatus(i2.getStatus());
        }
    }
}

