/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.system.cvss.CvsLiteAdminHandler;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class FileStatusCache {
    public static final Object EVENT_FILE_STATUS_CHANGED = new Object();
    private static final Map<File, FileInformation> NOT_MANAGED_MAP = new NotManagedMap();
    public static final int REPOSITORY_STATUS_UNKNOWN = 0;
    public static final int REPOSITORY_STATUS_UPDATED = 85;
    public static final int REPOSITORY_STATUS_PATCHED = 80;
    public static final int REPOSITORY_STATUS_MODIFIED = 77;
    public static final int REPOSITORY_STATUS_CONFLICT = 67;
    public static final int REPOSITORY_STATUS_MERGEABLE = 71;
    public static final int REPOSITORY_STATUS_ADDED = 65;
    public static final int REPOSITORY_STATUS_REMOVED = 82;
    public static final int REPOSITORY_STATUS_REMOVED_REMOTELY = 89;
    public static final int REPOSITORY_STATUS_UPTODATE = 65536;
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(2, false);
    private static final FileInformation FILE_INFORMATION_EXCLUDED_DIRECTORY = new FileInformation(2, true);
    private static final FileInformation FILE_INFORMATION_UPTODATE_DIRECTORY = new FileInformation(8, true);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(1, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED_DIRECTORY = new FileInformation(1, true);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(0, false);
    private final CvsVersioningSystem cvs;
    private final CvsLiteAdminHandler sah;
    private final Turbo turbo;
    private final String FILE_STATUS_MAP = "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP";
    private DiskMapTurboProvider cacheProvider;
    private final List<RefreshRequest> refreshRequests = new ArrayList<RefreshRequest>(10);
    private final RequestProcessor.Task refreshRequestsTask;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    FileStatusCache(CvsVersioningSystem cvsVersioningSystem) {
        this.cvs = cvsVersioningSystem;
        this.refreshRequestsTask = org.netbeans.modules.versioning.util.Utils.createTask((Runnable)new RefreshRequestRunnable());
        this.sah = (CvsLiteAdminHandler)this.cvs.getAdminHandler();
        this.cacheProvider = new DiskMapTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(FileStatusCache.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)200, (int)5000);
    }

    private File[] listFiles(File dir) {
        Set<File> files = this.getScannedFiles(dir).keySet();
        return files.toArray(new File[files.size()]);
    }

    public File[] listFiles(Context context, int includeStatus) {
        if (context.getRootFiles().length == 0) {
            return new File[0];
        }
        HashSet<File> set = new HashSet<File>();
        Map<File, FileInformation> allFiles = this.cacheProvider.getAllModifiedValues();
        block0: for (File file : allFiles.keySet()) {
            FileInformation info = allFiles.get(file);
            if (info.isDirectory() || (info.getStatus() & includeStatus) == 0) continue;
            File[] roots = context.getRootFiles();
            for (int j = 0; j < roots.length; ++j) {
                File root = roots[j];
                if (VersioningSupport.isFlat((File)root)) {
                    if (!file.getParentFile().equals(root)) continue;
                    set.add(file);
                    continue block0;
                }
                if (!org.netbeans.modules.versioning.util.Utils.isAncestorOrEqual((File)root, (File)file)) continue;
                set.add(file);
                continue block0;
            }
        }
        if (context.getExclusions().size() > 0) {
            for (File excluded : context.getExclusions()) {
                Iterator j = set.iterator();
                while (j.hasNext()) {
                    File file = (File)j.next();
                    if (!org.netbeans.modules.versioning.util.Utils.isAncestorOrEqual((File)excluded, (File)file)) continue;
                    j.remove();
                }
            }
        }
        return set.toArray(new File[set.size()]);
    }

    public FileInformation getStatus(File file) {
        if (file == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "File shouldn't be null");
            return FILE_INFORMATION_NOTMANAGED;
        }
        if (file.getName().equals("CVS")) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        File dir = file.getParentFile();
        if (dir == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<File, FileInformation> files = this.getScannedFiles(dir);
        if (files == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fi = files.get(file);
        if (fi != null) {
            return fi;
        }
        if (!this.exists(file)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (file.isDirectory()) {
            return this.refresh(file, 0);
        }
        return new FileInformation(8, false);
    }

    public void refresh(File file, int repositoryStatus, boolean forceChangeEvent) {
        this.refreshLater(new RefreshRequest(file, repositoryStatus, forceChangeEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLater(RefreshRequest request) {
        List<RefreshRequest> list = this.refreshRequests;
        synchronized (list) {
            this.refreshRequests.add(request);
        }
        this.refreshRequestsTask.schedule(777);
    }

    public FileInformation refreshNow(File file, int repositoryStatus, boolean forceChangeEvent) {
        File dir = file.getParentFile();
        if (dir == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<File, FileInformation> files = this.getScannedFiles(dir);
        if (files == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation current = files.get(file);
        Entry entry = null;
        try {
            entry = this.cvs.getAdminHandler().getEntry(file);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        FileInformation fi = this.createFileInformation(file, entry, repositoryStatus);
        if ((fi.getStatus() & 0x6A0) == 0 && repositoryStatus == 0 && current != null && (current.getStatus() & 0x6A0) != 0) {
            fi = (fi.getStatus() & 0x19D4) != 0 ? new FileInformation(128, fi.isDirectory()) : (current.getStatus() == 128 ? new FileInformation(32, current.isDirectory()) : current);
        }
        if (FileStatusCache.equivalent(fi, current)) {
            if (forceChangeEvent) {
                this.fireFileStatusChanged(file, current, fi);
            }
            return fi;
        }
        if (current == null && !fi.isDirectory() && fi.getStatus() == 8) {
            if (forceChangeEvent) {
                this.fireFileStatusChanged(file, current, fi);
            }
            return fi;
        }
        file = FileUtil.normalizeFile((File)file);
        dir = FileUtil.normalizeFile((File)dir);
        HashMap<File, FileInformation> newFiles = new HashMap<File, FileInformation>(files);
        if (fi.getStatus() == 0) {
            newFiles.remove(file);
            this.turbo.writeEntry((Object)file, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP", null);
        } else if (fi.getStatus() == 8 && file.isFile()) {
            newFiles.remove(file);
        } else {
            newFiles.put(file, fi);
        }
        this.turbo.writeEntry((Object)dir, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP", newFiles.size() == 0 ? null : newFiles);
        if (file.isDirectory() && this.needRecursiveRefresh(fi, current)) {
            File[] content = this.listFiles(file);
            for (int i = 0; i < content.length; ++i) {
                this.refresh(content[i], 0);
            }
        }
        this.fireFileStatusChanged(file, current, fi);
        return fi;
    }

    public FileInformation refresh(File file, int repositoryStatus) {
        return this.refreshNow(file, repositoryStatus, false);
    }

    FileInformation createFileInformation(File file) {
        Entry entry = null;
        try {
            entry = this.cvs.getAdminHandler().getEntry(file);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return this.createFileInformation(file, entry, 0);
    }

    private static boolean equivalent(FileInformation main, FileInformation other) {
        Entry e2;
        if (other == null || main.getStatus() != other.getStatus() || main.isDirectory() != other.isDirectory()) {
            return false;
        }
        Entry e1 = main.getEntry(null);
        return e1 == (e2 = other.getEntry(null)) || e1 == null || e2 == null || FileStatusCache.equal(e1, e2);
    }

    private static boolean equal(Entry e1, Entry e2) {
        if (!e1.getRevision().equals(e2.getRevision())) {
            return false;
        }
        return e1.getStickyInformation() == e2.getStickyInformation() || e1.getStickyInformation() != null && e1.getStickyInformation().equals(e2.getStickyInformation());
    }

    private boolean needRecursiveRefresh(FileInformation fi, FileInformation current) {
        if (fi.getStatus() == 2 || current != null && current.getStatus() == 2) {
            return true;
        }
        return fi.getStatus() == 1 || current != null && current.getStatus() == 1;
    }

    public void refreshCached(File file, int repositoryStatus) {
        this.refresh(file, repositoryStatus);
    }

    public void clearVirtualDirectoryContents(File dir, boolean recursive, File[] exclusions) {
        Map<File, FileInformation> files = this.cacheProvider.getAllModifiedValues();
        block0: for (Map.Entry<File, FileInformation> entry : files.entrySet()) {
            File file = entry.getKey();
            if (exclusions != null) {
                for (int j = 0; j < exclusions.length; ++j) {
                    if (Utils.isParentOrEqual(exclusions[j], file)) continue block0;
                }
            }
            if (!Utils.isParentOrEqual(dir, file) || !recursive && !dir.equals(file.getParentFile())) continue;
            this.refresh(file, 0);
        }
    }

    Map<File, FileInformation> getAllModifiedFiles() {
        return this.cacheProvider.getAllModifiedValues();
    }

    void directoryContentChanged(File dir) {
        Map originalFiles = (Map)this.turbo.readEntry((Object)dir, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP");
        if (originalFiles != null) {
            for (File file : originalFiles.keySet()) {
                this.refresh(file, 0, false);
            }
        }
    }

    private Map<File, FileInformation> getScannedFiles(File dir) {
        if (dir.getName().equals("CVS")) {
            return NOT_MANAGED_MAP;
        }
        Map<File, FileInformation> files = (Map<File, FileInformation>)this.turbo.readEntry((Object)dir, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP");
        if (files != null) {
            return files;
        }
        if (!dir.exists()) {
            return NOT_MANAGED_MAP;
        }
        dir = FileUtil.normalizeFile((File)dir);
        files = this.scanFolder(dir);
        this.turbo.writeEntry((Object)dir, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP", files);
        for (File file : files.keySet()) {
            FileInformation info = files.get(file);
            if ((info.getStatus() & 0x19D4) == 0) continue;
            this.fireFileStatusChanged(file, null, info);
        }
        return files;
    }

    private Map<File, FileInformation> scanFolder(File dir) {
        int i;
        File[] files = dir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        HashMap<File, FileInformation> folderFiles = new HashMap<File, FileInformation>(files.length);
        Entry[] entries = null;
        try {
            entries = this.sah.getEntriesAsArray(dir);
        }
        catch (IOException e) {
            // empty catch block
        }
        for (i = 0; i < files.length; ++i) {
            Entry entry;
            FileInformation fi;
            File file = files[i];
            String filename = file.getName();
            if (filename.equals("CVS") || !(fi = this.createFileInformation(file, entry = this.getEntry(dir, entries, file), 0)).isDirectory() && fi.getStatus() == 8) continue;
            folderFiles.put(file, fi);
        }
        if (entries != null) {
            block3: for (i = 0; i < entries.length; ++i) {
                Entry entry = entries[i];
                File entryFile = new File(dir, entry.getName());
                for (int j = 0; j < files.length; ++j) {
                    File file = files[j];
                    if (entryFile.equals(file)) continue block3;
                }
                FileInformation fi = this.createFileInformation(entryFile, entry, 0);
                folderFiles.put(entryFile, fi);
            }
        }
        return folderFiles;
    }

    private Entry getEntry(File dir, Entry[] entries, File file) {
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                Entry entry = entries[i];
                File entryFile = new File(dir, entry.getName());
                if (!file.equals(entryFile)) continue;
                return entry;
            }
        }
        return null;
    }

    private FileInformation createFileInformation(File file, Entry entry, int repositoryStatus) {
        if (entry == null) {
            if (!CvsVersioningSystem.isManaged(file)) {
                if (file.exists()) {
                    return file.isDirectory() ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_NOTMANAGED;
                }
                return FILE_INFORMATION_UNKNOWN;
            }
            return this.createMissingEntryFileInformation(file, repositoryStatus);
        }
        this.cvs.setNotUnignored(file);
        return this.createVersionedFileInformation(entry, file, repositoryStatus);
    }

    private FileInformation createVersionedFileInformation(Entry entry, File file, int repositoryStatus) {
        if (entry.isDirectory()) {
            if (file.exists()) {
                if (new File(file, "CVS").isDirectory()) {
                    return FILE_INFORMATION_UPTODATE_DIRECTORY;
                }
                return new FileInformation(4, true);
            }
            return new FileInformation(2048, true);
        }
        if (entry.isNewUserFile()) {
            return new FileInformation(4096, entry, false);
        }
        if (entry.isUserFileToBeRemoved()) {
            return new FileInformation(256, entry, false);
        }
        if (!this.exists(file)) {
            return new FileInformation(2048, entry, false);
        }
        if (repositoryStatus == 65536) {
            if (!this.entryTimestampMatches(entry, file)) {
                entry.setConflict(Entry.getLastModifiedDateFormatter().format(new Date(file.lastModified())));
                try {
                    this.sah.setEntry(file, entry);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            return new FileInformation(8, entry, false);
        }
        if (repositoryStatus == 85 || repositoryStatus == 80) {
            return new FileInformation(32, entry, false);
        }
        if (repositoryStatus == 77) {
            FileInformation fi = new FileInformation(16, entry, false);
            return fi;
        }
        if (repositoryStatus == 67) {
            if (this.isLocalConflict(entry, file)) {
                return new FileInformation(64, entry, false);
            }
            return new FileInformation(128, entry, false);
        }
        if (repositoryStatus == 71) {
            return new FileInformation(128, entry, false);
        }
        if (repositoryStatus == 89) {
            return new FileInformation(1024, entry, false);
        }
        if (repositoryStatus == 0 || repositoryStatus == 63) {
            if (this.exists(file)) {
                if (this.isLocalConflict(entry, file)) {
                    return new FileInformation(64, entry, false);
                }
                if (this.entryTimestampMatches(entry, file)) {
                    return new FileInformation(8, entry, false);
                }
                FileInformation fi = new FileInformation(16, entry, false);
                return fi;
            }
            return new FileInformation(2048, entry, false);
        }
        throw new IllegalArgumentException("Unknown repository status: " + (char)repositoryStatus);
    }

    private boolean isLocalConflict(Entry entry, File file) {
        return this.exists(file) && entry.hadConflicts() && this.entryTimestampMatches(entry, file);
    }

    private FileInformation createMissingEntryFileInformation(File file, int repositoryStatus) {
        boolean isDirectory = file.isDirectory();
        int parentStatus = this.getStatus(file.getParentFile()).getStatus();
        if (parentStatus == 2) {
            return isDirectory ? FILE_INFORMATION_EXCLUDED_DIRECTORY : FILE_INFORMATION_EXCLUDED;
        }
        if (parentStatus == 1) {
            if (isDirectory) {
                return this.isInsideCvsMetadata(file) ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_UPTODATE_DIRECTORY;
            }
            return FILE_INFORMATION_NOTMANAGED;
        }
        if (repositoryStatus == 65 && isDirectory) {
            return FILE_INFORMATION_UPTODATE_DIRECTORY;
        }
        if (repositoryStatus == 0 || repositoryStatus == 63) {
            if (this.exists(file)) {
                if (this.cvs.isIgnored(file)) {
                    return isDirectory ? FILE_INFORMATION_EXCLUDED_DIRECTORY : FILE_INFORMATION_EXCLUDED;
                }
                return new FileInformation(4, isDirectory);
            }
            return new FileInformation(0, false);
        }
        if (repositoryStatus == 85) {
            if (file.exists()) {
                return new FileInformation(64, isDirectory);
            }
            return new FileInformation(512, isDirectory);
        }
        if (repositoryStatus == 65536) {
            if (parentStatus == 4) {
                return new FileInformation(4, isDirectory);
            }
            if (this.exists(file) && Utils.getSticky(file) != null) {
                return new FileInformation(4, isDirectory);
            }
            return this.cvs.isUnignored(file) ? new FileInformation(4, isDirectory) : new FileInformation(2, isDirectory);
        }
        if (repositoryStatus == 89) {
            if (this.exists(file)) {
                return new FileInformation(4, isDirectory);
            }
            return FILE_INFORMATION_UNKNOWN;
        }
        if (repositoryStatus == 67) {
            return new FileInformation(64, false);
        }
        throw new IllegalArgumentException("Unknown repository status: " + (char)repositoryStatus + " for: " + file.getAbsolutePath());
    }

    private boolean isInsideCvsMetadata(File file) {
        return file.getAbsolutePath().indexOf(File.separator + "CVS" + File.separator) != -1;
    }

    private boolean exists(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.getAbsolutePath().equals(FileUtil.normalizeFile((File)file).getAbsolutePath());
    }

    private boolean entryTimestampMatches(Entry entry, File file) {
        Date d = entry.getLastModified();
        if (d == null) {
            return false;
        }
        long t0 = d.getTime();
        long t1 = file.lastModified() / 1000L * 1000L;
        if (TimeZone.getDefault().inDaylightTime(entry.getLastModified())) {
            t1 -= (long)TimeZone.getDefault().getDSTSavings();
        }
        return t0 == t1 || t0 - t1 == 3600000L || t1 - t0 == 3600000L;
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    private void fireFileStatusChanged(File file, FileInformation oldInfo, FileInformation newInfo) {
        this.listenerSupport.fireVersioningEvent(EVENT_FILE_STATUS_CHANGED, new Object[]{file, oldInfo, newInfo});
    }

    public FileInformation getCachedStatus(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        Map files = (Map)this.turbo.readEntry((Object)parent, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP");
        return files != null ? (FileInformation)files.get(file) : null;
    }

    private class RefreshRequest {
        final File file;
        final int repositoryStatus;
        final boolean forceChangeEvent;

        RefreshRequest(File file, int repositoryStatus, boolean forceChangeEvent) {
            this.file = file;
            this.repositoryStatus = repositoryStatus;
            this.forceChangeEvent = forceChangeEvent;
        }
    }

    private class RefreshRequestRunnable
    implements Runnable {
        private RefreshRequestRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<RefreshRequest> toProcess;
            List list = FileStatusCache.this.refreshRequests;
            synchronized (list) {
                toProcess = new ArrayList<RefreshRequest>(FileStatusCache.this.refreshRequests);
                FileStatusCache.this.refreshRequests.clear();
            }
            this.refresh(toProcess);
        }

        private void refresh(List<RefreshRequest> requests) {
            for (RefreshRequest request : requests) {
                FileStatusCache.this.refreshNow(request.file, request.repositoryStatus, request.forceChangeEvent);
            }
        }
    }

    private static final class NotManagedMap
    extends AbstractMap<File, FileInformation> {
        private NotManagedMap() {
        }

        @Override
        public Set entrySet() {
            return Collections.EMPTY_SET;
        }
    }
}

