/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.index.JsfIndexSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class JsfCustomIndexer
extends CustomIndexer {
    static final String INDEXER_NAME = "jsfCustomIndexer";
    static final int INDEXER_VERSION = 3;
    public static final Logger LOGGER = Logger.getLogger(JsfCustomIndexer.class.getSimpleName());

    protected void index(Iterable<? extends Indexable> files, Context context) {
        for (Indexable indexable : files) {
            String namespace;
            FileObject file;
            URL indexableURL = indexable.getURL();
            if (indexableURL == null || (file = URLMapper.findFileObject((URL)indexableURL)) == null) continue;
            if (JsfIndexSupport.isFaceletsLibraryDescriptor(file)) {
                LOGGER.log(Level.FINE, "indexing {0}", file);
                try {
                    namespace = FaceletsLibraryDescriptor.parseNamespace(file.getInputStream());
                    if (namespace == null) continue;
                    JsfIndexSupport.indexFaceletsLibraryDescriptor(context, file, namespace);
                    LOGGER.log(Level.FINE, "The file {0} indexed as a Facelets Library Descriptor", file);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                continue;
            }
            if (!JsfIndexSupport.isTagLibraryDescriptor(file)) continue;
            LOGGER.log(Level.FINE, "indexing {0}", file);
            try {
                namespace = FaceletsLibraryDescriptor.parseNamespace(file.getInputStream());
                if (namespace == null) continue;
                JsfIndexSupport.indexTagLibraryDescriptor(context, file, namespace);
                LOGGER.log(Level.FINE, "The file {0} indexed as a Tag Library Descriptor", file);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static class Factory
    extends CustomIndexerFactory {
        public CustomIndexer createIndexer() {
            return new JsfCustomIndexer();
        }

        public boolean supportsEmbeddedIndexers() {
            return false;
        }

        public boolean scanStarted(Context context) {
            try {
                return IndexingSupport.getInstance((Context)context).isValid();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }

        public void scanFinished(Context context) {
            super.scanFinished(context);
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return JsfCustomIndexer.INDEXER_NAME;
        }

        public int getIndexVersion() {
            return 3;
        }
    }
}

