/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.el.spi.ELPlugin;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.netbeans.modules.web.el.spi.ImplicitObjectType;
import org.netbeans.modules.web.jsf.api.editor.JSFResourceBundlesProvider;
import org.openide.filesystems.FileObject;

public class FaceletsELPlugin
implements ELPlugin {
    private static final String PLUGIN_NAME = "JSF Facelets EL Plugin";
    private static final String XHTML_MIMETYPE = "text/xhtml";
    private Collection<ImplicitObject> IMPL_OBJECTS;

    public String getName() {
        return PLUGIN_NAME;
    }

    public Collection<String> getMimeTypes() {
        return Collections.singletonList(XHTML_MIMETYPE);
    }

    public synchronized Collection<ImplicitObject> getImplicitObjects(FileObject fileObject) {
        if (!this.getMimeTypes().contains(fileObject.getMIMEType())) {
            return Collections.emptyList();
        }
        if (this.IMPL_OBJECTS == null) {
            this.IMPL_OBJECTS = new ArrayList<ImplicitObject>(9);
            this.IMPL_OBJECTS.addAll(FaceletsELPlugin.getScopeObjects());
            this.IMPL_OBJECTS.add(new FacesContextObject());
            this.IMPL_OBJECTS.add(new ApplicationObject());
            this.IMPL_OBJECTS.add(new ComponentObject());
            this.IMPL_OBJECTS.add(new FlashObject());
            this.IMPL_OBJECTS.add(new ResourceObject());
            this.IMPL_OBJECTS.add(new SessionObject());
            this.IMPL_OBJECTS.add(new ViewObject());
            this.IMPL_OBJECTS.add(new JsfImplicitObject("cookie", null, ImplicitObjectType.MAP_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("cc", null, ImplicitObjectType.RAW));
        }
        return this.IMPL_OBJECTS;
    }

    public List<String> getResourceBundles(FileObject fileObject) {
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            return Collections.emptyList();
        }
        return JSFResourceBundlesProvider.getResourceBundles((WebModule)webModule);
    }

    private static Collection<ImplicitObject> getScopeObjects() {
        ArrayList<ImplicitObject> arrayList = new ArrayList<ImplicitObject>(4);
        arrayList.add(new JsfImplicitObject("pageScope", null, ImplicitObjectType.SCOPE_TYPE));
        arrayList.add(new JsfImplicitObject("sessionScope", null, ImplicitObjectType.SCOPE_TYPE));
        arrayList.add(new JsfImplicitObject("applicationScope", null, ImplicitObjectType.SCOPE_TYPE));
        arrayList.add(new JsfImplicitObject("requestScope", null, ImplicitObjectType.SCOPE_TYPE));
        arrayList.add(new JsfImplicitObject("viewScope", null, ImplicitObjectType.SCOPE_TYPE));
        return arrayList;
    }

    private static class JsfImplicitObject
    implements ImplicitObject {
        private String name;
        private String clazz;
        private ImplicitObjectType type;

        public JsfImplicitObject(String string, String string2, ImplicitObjectType implicitObjectType) {
            this.name = string;
            this.clazz = string2;
            this.type = implicitObjectType;
        }

        public String getName() {
            return this.name;
        }

        public ImplicitObjectType getType() {
            return this.type;
        }

        public String getClazz() {
            return this.clazz;
        }
    }

    static class ViewObject
    extends JsfImplicitObject {
        public ViewObject() {
            super("view", "javax.faces.component.UIViewRoot", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class SessionObject
    extends JsfImplicitObject {
        public SessionObject() {
            super("session", "javax.servlet.http.HttpSession", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class ResourceObject
    extends JsfImplicitObject {
        public ResourceObject() {
            super("resource", "javax.faces.application.ResourceHandler", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class FlashObject
    extends JsfImplicitObject {
        public FlashObject() {
            super("flash", "javax.faces.context.Flash", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class ComponentObject
    extends JsfImplicitObject {
        public ComponentObject() {
            super("component", "javax.faces.component.UIComponent", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class ApplicationObject
    extends JsfImplicitObject {
        public ApplicationObject() {
            super("application", "javax.servlet.ServletContext", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class FacesContextObject
    extends JsfImplicitObject {
        public FacesContextObject() {
            super("facesContext", "javax.faces.context.FacesContext", ImplicitObjectType.OBJECT_TYPE);
        }
    }
}

