/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.api.EncapsulateFieldsRefactoring;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.Utilities;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.DeclarationGenerator;
import org.netbeans.modules.cnd.refactoring.ui.EncapsulateFieldPanel;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GeneratorUtils {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(GeneratorUtils.class.getName());
    private static final String ERROR = "<error>";

    private GeneratorUtils() {
    }

    public static String getGetterSetterDisplayName(Kind type) {
        if (type == Kind.GETTERS_ONLY) {
            return NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_generate_getter");
        }
        if (type == Kind.SETTERS_ONLY) {
            return NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_generate_setter");
        }
        return NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_generate_getter_and_setter");
    }

    public static Collection<CsmMember> getAllMembers(CsmClass typeElement) {
        return typeElement.getMembers();
    }

    public static Collection<CsmFunction> getAllOutOfClassMethodDefinitions(CsmClass clazz) {
        Iterator methods = CsmSelect.getClassMembers((CsmClass)clazz, (CsmSelect.CsmFilter)CsmSelect.FUNCTION_KIND_FILTER);
        ArrayList<CsmFunction> result = new ArrayList<CsmFunction>();
        while (methods.hasNext()) {
            CsmMethod method = (CsmMethod)methods.next();
            CsmFunctionDefinition definition = method.getDefinition();
            if (definition == null || definition == method) continue;
            result.add((CsmFunction)definition);
        }
        return result;
    }

    public static boolean isConstant(CsmVariable var) {
        return var.getType() != null && var.getType().isConst();
    }

    public static void scanForFieldsAndConstructors(CsmClass clsPath, Set<CsmField> initializedFields, Set<CsmField> uninitializedFields, List<CsmConstructor> constructors) {
        for (CsmMember member : clsPath.getMembers()) {
            if (CsmKindUtilities.isField((CsmObject)member)) {
                CsmField field = (CsmField)member;
                if (field.isStatic()) continue;
                if (field.getInitialValue() == null) {
                    if (initializedFields.remove(field)) continue;
                    uninitializedFields.add(field);
                    continue;
                }
                if (initializedFields.remove(field)) continue;
                uninitializedFields.add(field);
                continue;
            }
            if (!CsmKindUtilities.isConstructor((CsmObject)member)) continue;
            constructors.add((CsmConstructor)member);
        }
    }

    public static CsmFile[] getDeclarationDefinitionFiles(CsmClass clazz) {
        CsmFile declFile;
        CsmFile defFile = declFile = CsmRefactoringUtils.getCsmFile((CsmObject)clazz);
        if (declFile.isHeaderFile()) {
            CsmFile source;
            Iterator<CsmFunction> extDefs = GeneratorUtils.getAllOutOfClassMethodDefinitions(clazz).iterator();
            boolean found = false;
            while (extDefs.hasNext() && !found) {
                CsmFunction def = extDefs.next();
                defFile = CsmRefactoringUtils.getCsmFile((CsmObject)def);
                if (declFile.equals(defFile)) continue;
                found = true;
            }
            if (!found && (source = GeneratorUtils.findSource(declFile)) != null) {
                defFile = source;
            }
        }
        return new CsmFile[]{declFile, defFile};
    }

    private static CsmFile findSource(CsmFile header) {
        String name = GeneratorUtils.getFileName(header.getAbsolutePath());
        Collection includers = CsmIncludeHierarchyResolver.getDefault().getFiles(header);
        for (CsmFile f : includers) {
            if (!CndFileUtils.areFilenamesEqual((String)GeneratorUtils.getFileName(f.getAbsolutePath()), (String)name)) continue;
            return f;
        }
        for (CsmFile f : header.getProject().getSourceFiles()) {
            if (!CndFileUtils.areFilenamesEqual((String)GeneratorUtils.getFileName(((Object)f.getAbsolutePath()).toString()), (String)name)) continue;
            return f;
        }
        return null;
    }

    private static String getFileName(CharSequence file) {
        String name = new File(((Object)file).toString()).getName();
        return name;
    }

    public static InsertInfo[] getInsertPositons(CsmContext path, CsmClass enclClass, EncapsulateFieldPanel.InsertPoint insPt) {
        int declPos = -1;
        int defPos = -1;
        CsmFile declFile = null;
        CsmFile defFile = null;
        InsertInfo[] out = new InsertInfo[2];
        if (insPt == EncapsulateFieldPanel.InsertPoint.DEFAULT) {
            CsmOffsetable decl;
            CsmOffsetable csmOffsetable = decl = path == null ? null : path.getObjectUnderOffset();
            if (decl == null && path != null) {
                for (CsmObject csmObject : path.getPath()) {
                    if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
                        enclClass = (CsmClass)csmObject;
                        declPos = path.getCaretOffset();
                        if (declPos > enclClass.getLeftBracketOffset()) continue;
                        declPos = enclClass.getLeftBracketOffset() + 1;
                        continue;
                    }
                    if (!CsmKindUtilities.isOffsetableDeclaration((Object)csmObject)) continue;
                    decl = (CsmOffsetable)csmObject;
                }
            }
            if (decl != null) {
                declPos = decl.getEndOffset();
            }
            if (CsmKindUtilities.isClassMember((CsmObject)decl)) {
                enclClass = ((CsmMember)decl).getContainingClass();
                if (CsmKindUtilities.isField((CsmObject)decl)) {
                    declPos = -1;
                }
            } else if (enclClass == null) {
                enclClass = path.getEnclosingClass();
            }
        } else {
            if (enclClass == null) {
                enclClass = insPt.getContainerClass();
            }
            if (insPt.getElementDeclaration() != null) {
                declPos = insPt.getElementDeclaration().getEndOffset();
            } else if (insPt.getIndex() == Integer.MIN_VALUE) {
                declPos = enclClass.getLeftBracketOffset() + 1;
            }
        }
        if (declPos < 0) {
            CsmMethod lastPublicMethod = null;
            CsmMethod firstPublicMethod = null;
            CsmMethod lastPublicConstructor = null;
            CsmMethod firstPublicConstructor = null;
            for (CsmMember member : enclClass.getMembers()) {
                CsmMethod method;
                if (member.getVisibility() != CsmVisibility.PUBLIC || !CsmKindUtilities.isMethod((CsmObject)member)) continue;
                lastPublicMethod = method = (CsmMethod)member;
                if (firstPublicMethod == null) {
                    firstPublicMethod = method;
                }
                if (!CsmKindUtilities.isConstructor((CsmObject)method)) continue;
                lastPublicConstructor = method;
                if (firstPublicConstructor != null) continue;
                firstPublicConstructor = method;
            }
            if (lastPublicMethod != null) {
                CsmFunctionDefinition def;
                declPos = lastPublicMethod.getEndOffset();
                if (declFile == null) {
                    declFile = CsmRefactoringUtils.getCsmFile(lastPublicMethod);
                }
                if ((def = lastPublicMethod.getDefinition()) != null && def != lastPublicMethod) {
                    defFile = CsmRefactoringUtils.getCsmFile((CsmObject)def);
                    defPos = def.getEndOffset();
                }
            } else {
                declPos = enclClass.getLeftBracketOffset() + 1;
            }
        }
        if (declFile == null) {
            declFile = CsmRefactoringUtils.getCsmFile((CsmObject)enclClass);
        }
        if (defFile == null) {
            for (CsmFunction def : GeneratorUtils.getAllOutOfClassMethodDefinitions(enclClass)) {
                defFile = CsmRefactoringUtils.getCsmFile((CsmObject)def);
                defPos = def.getEndOffset();
                if (insPt.getIndex() == Integer.MAX_VALUE) continue;
                break;
            }
        }
        CloneableEditorSupport classDeclEditor = CsmUtilities.findCloneableEditorSupport((CsmFile)declFile);
        CloneableEditorSupport classDefEditor = CsmUtilities.findCloneableEditorSupport(defFile);
        PositionRef startDeclPos = classDeclEditor.createPositionRef(declPos, Position.Bias.Backward);
        PositionRef endDeclPos = classDeclEditor.createPositionRef(declPos, Position.Bias.Forward);
        out[0] = new InsertInfo(classDeclEditor, declPos, startDeclPos, endDeclPos);
        if (classDefEditor != null && defPos >= 0) {
            PositionRef startDefPos = classDefEditor.createPositionRef(defPos, Position.Bias.Backward);
            PositionRef endDefPos = classDefEditor.createPositionRef(defPos, Position.Bias.Forward);
            out[1] = new InsertInfo(classDefEditor, defPos, startDefPos, endDefPos);
        }
        return out;
    }

    public static Boolean checkStartWithUpperCase(CsmMethod method) {
        String name = "";
        if (!(CsmKindUtilities.isConstructor((CsmObject)method) || CsmKindUtilities.isOperator((CsmObject)method) || CsmKindUtilities.isDestructor((CsmObject)method))) {
            name = ((Object)method.getName()).toString();
        }
        return name.length() == 0 ? null : Boolean.valueOf(Character.isUpperCase(name.charAt(0)));
    }

    public static void generateGettersAndSetters(CsmContext path, Collection<? extends CsmField> fields, boolean inlineMethods, Kind type, boolean isUpperCase) {
        CsmClass enclosingClass = Utilities.extractEnclosingClass(path);
        if (enclosingClass == null) {
            System.err.println("why enclosing class is null? " + path);
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (fields.isEmpty()) {
            System.err.println("nothing to encapsulate");
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (inlineMethods) {
            InsertInfo[] ins = GeneratorUtils.getInsertPositons(path, enclosingClass, EncapsulateFieldPanel.InsertPoint.DEFAULT);
            final InsertInfo def = ins[0];
            final StringBuilder result = new StringBuilder();
            for (CsmField csmField : fields) {
                if (type != Kind.SETTERS_ONLY) {
                    result.append("\n");
                    result.append(DeclarationGenerator.createGetter(csmField, GeneratorUtils.computeGetterName(csmField, isUpperCase), DeclarationGenerator.Kind.INLINE_DEFINITION));
                }
                if (type == Kind.GETTERS_ONLY) continue;
                result.append("\n");
                result.append(DeclarationGenerator.createSetter(csmField, GeneratorUtils.computeSetterName(csmField, isUpperCase), DeclarationGenerator.Kind.INLINE_DEFINITION));
            }
            result.append("\n");
            final Document doc = path.getDocument();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        doc.insertString(def.dot, result.toString(), null);
                        Reformat format = Reformat.get((Document)doc);
                        format.lock();
                        try {
                            int start = def.start.getOffset();
                            int end = def.end.getOffset();
                            format.reformat(start, end);
                        }
                        finally {
                            format.unlock();
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            if (doc instanceof BaseDocument) {
                ((BaseDocument)doc).runAtomicAsUser(runnable);
            } else {
                runnable.run();
            }
        } else {
            RefactoringSession session = RefactoringSession.create((String)GeneratorUtils.getGetterSetterDisplayName(type));
            EncapsulateFieldsRefactoring refactoring = new EncapsulateFieldsRefactoring(null, path);
            ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> refFields = new ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo>();
            for (CsmField csmField : fields) {
                String gName = type != Kind.SETTERS_ONLY ? GeneratorUtils.computeGetterName(csmField, isUpperCase) : null;
                String sName = type != Kind.GETTERS_ONLY ? GeneratorUtils.computeSetterName(csmField, isUpperCase) : null;
                refFields.add(new EncapsulateFieldsRefactoring.EncapsulateFieldInfo(csmField, gName, sName, null, null));
            }
            refactoring.setRefactorFields(refFields);
            refactoring.setFieldModifiers(Collections.<CsmVisibility>emptySet());
            refactoring.getContext().add((Object)EncapsulateFieldPanel.InsertPoint.DEFAULT);
            refactoring.setMethodInline(false);
            Problem problem = refactoring.preCheck();
            if (problem != null && problem.isFatal()) {
                System.err.println("preCheck failed: not possible to refactor " + problem);
                return;
            }
            problem = refactoring.prepare(session);
            if (problem != null && problem.isFatal()) {
                System.err.println("prepare failed: not possible to refactor " + problem);
                return;
            }
            session.doRefactoring(false);
        }
    }

    public static boolean hasGetter(CsmField field, Map<String, List<CsmMethod>> methods, boolean isUpperCase) {
        String getter = GeneratorUtils.computeGetterName(field, isUpperCase);
        List<CsmMethod> candidates = methods.get(getter);
        if (candidates != null) {
            CsmType type = field.getType();
            for (CsmMethod candidate : candidates) {
                Collection parameters = candidate.getParameters();
                if (!parameters.isEmpty() || !GeneratorUtils.isSameType(candidate.getReturnType(), type)) continue;
                return true;
            }
        }
        return false;
    }

    public static String stripFieldPrefix(String identifierString) {
        String stripped = identifierString;
        if (stripped.startsWith("m_")) {
            stripped = identifierString.substring(2);
        }
        if (stripped.length() > 1 && stripped.charAt(0) == 'p' && Character.isUpperCase(stripped.charAt(1))) {
            stripped = stripped.substring(1);
        }
        return stripped;
    }

    private static StringBuilder getCapitalizedName(CsmField field) {
        StringBuilder name = new StringBuilder(GeneratorUtils.stripFieldPrefix(((Object)field.getName()).toString()));
        while (name.length() > 1 && name.charAt(0) == '_') {
            name.deleteCharAt(0);
        }
        if (name.length() > 0) {
            name.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        }
        name.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        return name;
    }

    public static String computeSetterName(CsmField field, boolean isUpperCase) {
        StringBuilder name = GeneratorUtils.getCapitalizedName(field);
        name.insert(0, GeneratorUtils.toPrefix("set", isUpperCase));
        return name.toString();
    }

    public static String computeGetterName(CsmField field, boolean isUpperCase) {
        StringBuilder name = GeneratorUtils.getCapitalizedName(field);
        CsmType type = field.getType();
        name.insert(0, GeneratorUtils.toPrefix(GeneratorUtils.getTypeKind(type) == TypeKind.BOOLEAN ? "is" : "get", isUpperCase));
        return name.toString();
    }

    private static String toPrefix(String str, boolean isUpperCase) {
        StringBuilder pref = new StringBuilder(str);
        char first = pref.charAt(0);
        first = isUpperCase ? Character.toUpperCase(first) : Character.toLowerCase(first);
        pref.setCharAt(0, first);
        return pref.toString();
    }

    public static TypeKind getTypeKind(CsmType type) {
        CharSequence text = type.getClassifierText();
        if (CharSequences.comparator().compare("void", text) == 0) {
            return TypeKind.VOID;
        }
        if (CharSequences.comparator().compare("bool", text) == 0 || CharSequences.comparator().compare("boolean", text) == 0) {
            return TypeKind.BOOLEAN;
        }
        return TypeKind.UNKNOWN;
    }

    public static boolean isSameType(CsmType type1, CsmType type2) {
        if (type1.equals(type2)) {
            return true;
        }
        if (type2 != null) {
            return CharSequences.comparator().compare(type1.getCanonicalText(), type2.getCanonicalText()) == 0;
        }
        return false;
    }

    public static boolean hasSetter(CsmField field, Map<String, List<CsmMethod>> methods, boolean isUpperCase) {
        String setter = GeneratorUtils.computeSetterName(field, isUpperCase);
        List<CsmMethod> candidates = methods.get(setter);
        if (candidates != null) {
            CsmType type = field.getType();
            for (CsmMethod candidate : candidates) {
                Collection parameters = candidate.getParameters();
                if (GeneratorUtils.getTypeKind(candidate.getReturnType()) != TypeKind.VOID || parameters.size() != 1 || !GeneratorUtils.isSameType(((CsmParameter)parameters.iterator().next()).getType(), type)) continue;
                return true;
            }
        }
        return false;
    }

    public static DialogDescriptor createDialogDescriptor(JComponent content, String label) {
        Object[] buttons = new JButton[2];
        buttons[0] = new JButton(NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_generate_button"));
        buttons[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorUtils.class, (String)"A11Y_Generate"));
        buttons[1] = new JButton(NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_cancel_button"));
        return new DialogDescriptor((Object)content, label, true, buttons, (Object)buttons[0], 0, null, null);
    }

    public static enum TypeKind {
        VOID,
        BOOLEAN,
        UNKNOWN;

    }

    public static final class InsertInfo {
        public final CloneableEditorSupport ces;
        public final PositionRef start;
        public final PositionRef end;
        public final int dot;

        public InsertInfo(CloneableEditorSupport ces, int dot, PositionRef start, PositionRef end) {
            this.ces = ces;
            this.start = start;
            this.end = end;
            this.dot = dot;
        }
    }

    public static enum Kind {
        GETTERS_ONLY,
        SETTERS_ONLY,
        GETTERS_SETTERS;

    }
}

