/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.netbeans.modules.i18n.regexp.ParseException;
import org.netbeans.modules.i18n.regexp.Translator;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaI18nFinder
implements I18nSupport.I18nFinder {
    protected static final int STATE_JAVA = 0;
    protected static final int STATE_JAVA_A_SLASH = 1;
    protected static final int STATE_LINECOMMENT = 2;
    protected static final int STATE_BLOCKCOMMENT = 3;
    protected static final int STATE_BLOCKCOMMENT_A_STAR = 4;
    protected static final int STATE_STRING = 5;
    protected static final int STATE_STRING_A_BSLASH = 6;
    protected static final int STATE_CHAR = 7;
    protected StyledDocument document;
    protected int state;
    protected boolean i18nSearch;
    protected Position lastPosition;
    protected StringBuffer lastJavaString;
    protected char[] buffer;
    protected int position;
    protected int currentStringStart;
    protected int currentStringEnd;

    public JavaI18nFinder(StyledDocument document) {
        this.document = document;
        this.init();
    }

    private void init() {
        this.state = 0;
        this.initJavaStringBuffer();
        this.lastPosition = null;
    }

    protected void reset() {
        this.init();
    }

    @Override
    public HardCodedString[] findAllHardCodedStrings() {
        this.reset();
        this.i18nSearch = false;
        return this.findAllStrings();
    }

    @Override
    public HardCodedString findNextHardCodedString() {
        this.i18nSearch = false;
        return this.findNextString();
    }

    @Override
    public HardCodedString[] findAllI18nStrings() {
        this.reset();
        this.i18nSearch = true;
        return this.findAllStrings();
    }

    @Override
    public HardCodedString findNextI18nString() {
        this.i18nSearch = true;
        return this.findNextString();
    }

    protected HardCodedString[] findAllStrings() {
        HardCodedString hardString;
        ArrayList<HardCodedString> list = new ArrayList<HardCodedString>();
        while ((hardString = this.findNextString()) != null) {
            list.add(hardString);
        }
        return !list.isEmpty() ? list.toArray(new HardCodedString[list.size()]) : null;
    }

    protected HardCodedString findNextString() {
        try {
            this.buffer = this.document.getText(0, this.document.getLength()).toCharArray();
        }
        catch (BadLocationException ble) {
            if (Boolean.getBoolean("netbeans.debug.exception")) {
                ble.printStackTrace();
            }
            return null;
        }
        this.position = this.lastPosition == null ? 0 : this.lastPosition.getOffset();
        this.currentStringStart = -1;
        this.currentStringEnd = -1;
        while (this.position < this.buffer.length) {
            char ch = this.buffer[this.position];
            if (ch != '\n') {
                HardCodedString foundHardString = this.handleCharacter(ch);
                if (foundHardString != null) {
                    return foundHardString;
                }
            } else {
                this.handleNewLineCharacter();
            }
            ++this.position;
        }
        return null;
    }

    protected HardCodedString handleCharacter(char character) {
        if (this.state == 0) {
            return this.handleStateJava(character);
        }
        if (this.state == 1) {
            return this.handleStateJavaASlash(character);
        }
        if (this.state == 7) {
            return this.handleStateChar(character);
        }
        if (this.state == 6) {
            return this.handleStateStringABSlash(character);
        }
        if (this.state == 2) {
            return this.handleStateLineComment(character);
        }
        if (this.state == 3) {
            return this.handleStateBlockComment(character);
        }
        if (this.state == 4) {
            return this.handleStateBlockCommentAStar(character);
        }
        if (this.state == 5) {
            return this.handleStateString(character);
        }
        return null;
    }

    protected void handleNewLineCharacter() {
        if (this.state == 0 || this.state == 1 || this.state == 7 || this.state == 2 || this.state == 5 || this.state == 6) {
            this.initJavaStringBuffer();
            this.currentStringStart = -1;
            this.currentStringEnd = -1;
            this.state = 0;
        } else if (this.state == 3 || this.state == 4) {
            this.state = 3;
        }
    }

    protected HardCodedString handleStateJava(char character) {
        this.lastJavaString.append(character);
        if (character == '/') {
            this.state = 1;
        } else if (character == '\"') {
            this.state = 5;
            if (this.currentStringStart == -1) {
                this.currentStringStart = this.position;
            }
        } else if (character == '\'') {
            this.state = 7;
        }
        return null;
    }

    protected HardCodedString handleStateJavaASlash(char character) {
        this.lastJavaString.append(character);
        if (character == '/') {
            this.state = 2;
        } else if (character == '*') {
            this.state = 3;
        }
        return null;
    }

    protected HardCodedString handleStateChar(char character) {
        this.lastJavaString.append(character);
        if (character == '\'') {
            this.state = 0;
        }
        return null;
    }

    protected HardCodedString handleStateStringABSlash(char character) {
        this.state = 5;
        return null;
    }

    protected HardCodedString handleStateLineComment(char character) {
        return null;
    }

    protected HardCodedString handleStateBlockComment(char character) {
        if (character == '*') {
            this.state = 4;
        }
        return null;
    }

    protected HardCodedString handleStateBlockCommentAStar(char character) {
        if (character == '/') {
            this.state = 0;
            this.initJavaStringBuffer();
        } else if (character != '*') {
            this.state = 3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HardCodedString handleStateString(char character) {
        if (character == '\\') {
            this.state = 6;
        } else if (character == '\"') {
            this.state = 0;
            if (this.currentStringEnd == -1 && this.currentStringStart != -1) {
                this.currentStringEnd = this.position + 1;
                int foundStringLength = this.currentStringEnd - this.currentStringStart;
                try {
                    Position hardStringStart = this.document.createPosition(this.currentStringStart);
                    Position hardStringEnd = this.document.createPosition(this.currentStringEnd);
                    String hardString = this.document.getText(hardStringStart.getOffset(), foundStringLength);
                    String restBuffer = new String(this.buffer, this.currentStringEnd, this.buffer.length - this.currentStringEnd);
                    int endOfLine = restBuffer.indexOf(10);
                    if (endOfLine == -1) {
                        endOfLine = restBuffer.length();
                    }
                    this.lastJavaString.append(this.document.getText(this.currentStringStart + 1, hardString.length()));
                    String restOfLine = this.document.getText(this.currentStringStart + 1 + hardString.length(), this.currentStringEnd + endOfLine - this.currentStringStart - hardString.length());
                    this.lastJavaString.append(restOfLine.replace('\"', '_'));
                    if (this.isSearchedString(this.lastJavaString.toString(), hardString)) {
                        this.lastPosition = hardStringEnd;
                        HardCodedString hardCodedString = new HardCodedString(this.extractString(hardString), hardStringStart, hardStringEnd);
                        return hardCodedString;
                    }
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify(1, (Throwable)ble);
                }
                finally {
                    this.currentStringStart = -1;
                    this.currentStringEnd = -1;
                    this.initJavaStringBuffer();
                }
            }
        }
        return null;
    }

    private void initJavaStringBuffer() {
        this.lastJavaString = new StringBuffer();
    }

    private String extractString(String sourceString) {
        if (sourceString == null) {
            return "";
        }
        if (sourceString.length() >= 2 && sourceString.charAt(0) == '\"' && sourceString.charAt(sourceString.length() - 1) == '\"') {
            sourceString = sourceString.substring(1, sourceString.length() - 1);
        }
        return sourceString;
    }

    protected boolean isSearchedString(String partHardLine, String hardString) {
        Boolean regexpTestResult;
        String lineToMatch = UtilConvert.unicodesToChars((String)partHardLine);
        Exception ex = null;
        try {
            String regexp = this.createRegularExpression(hardString);
            regexpTestResult = Pattern.compile(regexp).matcher(lineToMatch).find() == this.i18nSearch;
        }
        catch (ParseException ex1) {
            ex = ex1;
            regexpTestResult = null;
        }
        catch (PatternSyntaxException ex2) {
            ex = ex2;
            regexpTestResult = null;
        }
        if (Boolean.FALSE.equals(regexpTestResult)) {
            return false;
        }
        AnnotationDetector annotationDetector = new AnnotationDetector(this.currentStringStart);
        try {
            boolean firstTry = true;
            do {
                if (!firstTry) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException exInterrupted) {
                        Exceptions.printStackTrace((Throwable)exInterrupted);
                    }
                }
                annotationDetector.reset();
                JavaSource.forDocument((Document)this.document).runUserActionTask((Task)annotationDetector, true);
                firstTry = false;
            } while (annotationDetector.wasCancelled());
        }
        catch (IOException ioEx) {
            Exceptions.printStackTrace((Throwable)ioEx);
        }
        if (annotationDetector.wasAnnotationDetected()) {
            return false;
        }
        if (regexpTestResult != null) {
            assert (regexpTestResult.equals(Boolean.TRUE));
            return true;
        }
        ErrorManager.getDefault().notify(1, (Throwable)ex);
        String msg = NbBundle.getMessage(JavaI18nSupport.class, (String)"MSG_RegExpCompileError", (Object)hardString);
        Object answer = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)msg, 0, 0));
        return NotifyDescriptor.YES_OPTION.equals(answer);
    }

    private String createRegularExpression(String hardString) throws ParseException {
        String regexpForm = this.i18nSearch ? I18nUtil.getOptions().getI18nRegularExpression() : I18nUtil.getOptions().getRegularExpression();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("key", hardString);
        map.put("hardString", hardString);
        return Translator.translateRegexp(regexpForm, map);
    }

    static final class AnnotationDetector
    implements CancellableTask<CompilationController> {
        private final int caretPosition;
        private volatile boolean cancelled;
        private boolean annotationDetected = false;

        private AnnotationDetector(int caretPosition) {
            this.caretPosition = caretPosition;
        }

        void reset() {
            this.cancelled = false;
            this.annotationDetected = false;
        }

        public void run(CompilationController controller) throws IOException {
            if (this.cancelled) {
                return;
            }
            controller.toPhase(JavaSource.Phase.RESOLVED);
            if (this.cancelled) {
                return;
            }
            TreePath treePath = controller.getTreeUtilities().pathFor(this.caretPosition);
            if (treePath == null) {
                return;
            }
            Tree.Kind kind = treePath.getLeaf().getKind();
            if (kind == Tree.Kind.STRING_LITERAL) {
                if ((treePath = treePath.getParentPath()) == null) {
                    return;
                }
                kind = treePath.getLeaf().getKind();
            }
            if (kind == Tree.Kind.NEW_ARRAY) {
                if ((treePath = treePath.getParentPath()) == null) {
                    return;
                }
                kind = treePath.getLeaf().getKind();
            }
            if (kind == Tree.Kind.ASSIGNMENT) {
                if ((treePath = treePath.getParentPath()) == null) {
                    return;
                }
                kind = treePath.getLeaf().getKind();
            }
            this.annotationDetected = kind == Tree.Kind.ANNOTATION;
        }

        public void cancel() {
            this.cancelled = true;
        }

        boolean wasCancelled() {
            return this.cancelled;
        }

        boolean wasAnnotationDetected() {
            return this.annotationDetected;
        }
    }
}

