/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.maven;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.openide.util.Lookup;

public class HpiActionGoalProvider
implements MavenActionsProvider {
    private static final HashSet<String> ACTIONS = new HashSet<String>(Arrays.asList("run", "debug"));
    private static Map<Project, Boolean> IS_HPI = new WeakHashMap<Project, Boolean>();
    private static final AbstractMavenActionsProvider delegate = new AbstractMavenActionsProvider(){

        protected InputStream getActionDefinitionStream() {
            return HpiActionGoalProvider.class.getResourceAsStream("action-mappings.xml");
        }
    };

    private static synchronized boolean isHPI(Project p) {
        Boolean b = IS_HPI.get(p);
        if (b == null) {
            b = "hpi".equals(((NbMavenProject)p.getLookup().lookup(NbMavenProject.class)).getPackagingType());
            IS_HPI.put(p, b);
        }
        return b;
    }

    public RunConfig createConfigForDefaultAction(String actionName, Project project, Lookup lookup) {
        if (this.isActionEnable(actionName, project, null)) {
            return delegate.createConfigForDefaultAction(actionName, project, lookup);
        }
        return null;
    }

    public NetbeansActionMapping getMappingForAction(String actionName, Project project) {
        if (this.isActionEnable(actionName, project, null)) {
            return delegate.getMappingForAction(actionName, project);
        }
        return null;
    }

    public boolean isActionEnable(String action, Project project, Lookup lookup) {
        return ACTIONS.contains(action) && HpiActionGoalProvider.isHPI(project);
    }

    public Set<String> getSupportedDefaultActions() {
        return ACTIONS;
    }
}

