/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.ConnectException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.fs.CachedRemoteInputStream;
import org.netbeans.modules.remote.impl.fs.FileType;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.WritingQueue;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public final class RemotePlainFile
extends RemoteFileObjectBase {
    private final char fileTypeChar;
    private SoftReference<CachedRemoteInputStream> fileContentCache = new SoftReference<Object>(null);

    public RemotePlainFile(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteDirectory parent, String remotePath, File cache, FileType fileType) {
        super(fileSystem, execEnv, parent, remotePath, cache);
        this.fileTypeChar = fileType.toChar();
    }

    public final RemoteFileObjectBase[] getChildren() {
        return new RemoteFileObjectBase[0];
    }

    public final boolean isFolder() {
        return false;
    }

    public boolean isData() {
        return true;
    }

    public final RemoteFileObjectBase getFileObject(String name, String ext) {
        return null;
    }

    public RemoteFileObjectBase getFileObject(String relativePath) {
        return null;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        try {
            RemoteDirectory parent;
            CachedRemoteInputStream stream = this.fileContentCache.get();
            if (stream != null) {
                CachedRemoteInputStream reuse = stream.reuse();
                if (reuse != null) {
                    return reuse;
                }
                this.fileContentCache.clear();
            }
            if ((parent = RemoteFileSystemUtils.getCanonicalParent(this)) == null) {
                return RemoteFileSystemUtils.createDummyInputStream();
            }
            InputStream newStream = parent._getInputStream(this);
            if (newStream instanceof CachedRemoteInputStream) {
                this.fileContentCache = new SoftReference<CachedRemoteInputStream>((CachedRemoteInputStream)newStream);
            } else if (stream != null) {
                this.fileContentCache.clear();
            }
            return newStream;
        }
        catch (ConnectException ex) {
            return new ByteArrayInputStream(new byte[0]);
        }
        catch (IOException ex) {
            throw this.newFileNotFoundException(ex);
        }
        catch (InterruptedException ex) {
            throw this.newFileNotFoundException(ex);
        }
        catch (ExecutionException ex) {
            throw this.newFileNotFoundException(ex);
        }
        catch (CancellationException ex) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private FileNotFoundException newFileNotFoundException(Exception cause) {
        FileNotFoundException ex = new FileNotFoundException("" + this.execEnv + ':' + this.remotePath);
        ex.initCause(cause);
        return ex;
    }

    public FileObject createData(String name, String ext) throws IOException {
        throw new IOException("Plain file can not have children");
    }

    public FileObject createFolder(String name) throws IOException {
        throw new IOException("Plain file can not have children");
    }

    protected void postDeleteChild(FileObject child) {
        RemoteLogger.getInstance().log(Level.WARNING, "postDeleteChild is called on {0}", this.getClass().getSimpleName());
    }

    protected void deleteImpl() throws IOException {
        RemoteFileSystemUtils.delete(this.execEnv, this.remotePath, false);
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        if (!this.isValid()) {
            throw new FileNotFoundException("FileObject " + this + " is not valid.");
        }
        return new DelegateOutputStream();
    }

    protected void ensureSync() throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        RemoteDirectory parent = RemoteFileSystemUtils.getCanonicalParent(this);
        if (parent != null) {
            parent.ensureChildSync(this);
        }
    }

    public FileType getType() {
        return FileType.fromChar(this.fileTypeChar);
    }

    private class DelegateOutputStream
    extends OutputStream {
        FileOutputStream delegate;

        public DelegateOutputStream() throws IOException {
            this.delegate = new FileOutputStream(RemotePlainFile.this.cache);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        public void close() throws IOException {
            this.delegate.close();
            WritingQueue.getInstance(RemotePlainFile.this.execEnv).add(RemotePlainFile.this.cache, RemotePlainFile.this.remotePath, -1, null);
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }
    }
}

