/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.api.ui.ConnectionNotifier;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.util.NbBundle;

public class RemoteFileSupport
extends ConnectionNotifier.NamedRunnable {
    private final PendingFilesQueue pendingFilesQueue = new PendingFilesQueue();
    private final ExecutionEnvironment execEnv;

    public RemoteFileSupport(ExecutionEnvironment execEnv) {
        super(NbBundle.getMessage(RemoteFileSupport.class, (String)"RemoteDownloadTask.TITLE", (Object)RemoteFileSupport.getDisplayName(execEnv)));
        this.execEnv = execEnv;
    }

    protected void runImpl() {
        try {
            this.onConnect();
        }
        catch (ConnectException ex) {
            RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)this.execEnv), ex);
            ConnectionNotifier.addTask(this.execEnv, this);
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex);
        }
        catch (IOException ex) {
            RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)this.execEnv), ex);
            ConnectionNotifier.addTask(this.execEnv, this);
        }
        catch (ExecutionException ex) {
            RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)this.execEnv), ex);
            ConnectionNotifier.addTask(this.execEnv, this);
        }
    }

    private static String getDisplayName(ExecutionEnvironment env) {
        return env.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnect() throws InterruptedException, ConnectException, InterruptedIOException, IOException, ExecutionException {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"Progress_Title", (Object)RemoteFileSupport.getDisplayName(this.execEnv)));
        handle.start();
        handle.switchToDeterminate(this.pendingFilesQueue.size());
        int cnt = 0;
        try {
            PendingFile pendingFile;
            RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(this.execEnv);
            while ((pendingFile = this.pendingFilesQueue.poll(1L, TimeUnit.SECONDS)) != null) {
                RemoteFileObjectBase dir = fs.findResource(pendingFile.remotePath);
                if (dir != null) {
                    dir.ensureSync();
                } else {
                    RemoteLogger.getInstance().log(Level.INFO, "Directory {0}:{1} does not exist (was it removed?)", new Object[]{this.execEnv, pendingFile.remotePath});
                }
                handle.progress(NbBundle.getMessage(this.getClass(), (String)"Progress_Message", (Object)pendingFile.remotePath), cnt++);
            }
        }
        finally {
            handle.finish();
            RemoteFileSystemManager.getInstance().fireDownloadListeners(this.execEnv);
        }
    }

    public void addPendingFile(RemoteFileObjectBase fo) {
        RemoteLogger.getInstance().log(Level.FINEST, "Adding notification for {0}:{1}", new Object[]{this.execEnv, fo.remotePath});
        ConnectionNotifier.addTask(this.execEnv, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PendingFilesQueue {
        private final BlockingQueue<PendingFile> queue = new LinkedBlockingQueue<PendingFile>();
        private final Set<String> remoteAbsPaths = new TreeSet<String>();

        private PendingFilesQueue() {
        }

        public synchronized void add(String remotePath) {
            if (this.remoteAbsPaths.add(remotePath)) {
                this.queue.add(new PendingFile(remotePath));
            }
        }

        public synchronized PendingFile take() throws InterruptedException {
            PendingFile pendingFile = this.queue.take();
            this.remoteAbsPaths.remove(pendingFile.remotePath);
            return pendingFile;
        }

        public synchronized PendingFile poll(long timeout, TimeUnit unit) throws InterruptedException {
            PendingFile pendingFile = this.queue.poll(timeout, unit);
            if (pendingFile != null) {
                this.remoteAbsPaths.remove(pendingFile.remotePath);
            }
            return pendingFile;
        }

        public synchronized List<String> getPendingFiles() {
            return Collections.unmodifiableList(new ArrayList<String>(this.remoteAbsPaths));
        }

        public int size() {
            return this.remoteAbsPaths.size();
        }
    }

    private static class PendingFile {
        public final String remotePath;

        public PendingFile(String remotePath) {
            this.remotePath = remotePath;
        }
    }
}

