/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.fs.FileType;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteLink;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.netbeans.modules.remote.impl.fs.WeakCache;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class RemoteFileObjectFactory {
    private final ExecutionEnvironment env;
    private final RemoteFileSystem fileSystem;
    private final WeakCache<String, RemoteFileObjectBase> fileObjectsCache = new WeakCache();
    private final Object lock = new Object();
    private final RequestProcessor.Task cleaningTask;
    private static RequestProcessor RP = new RequestProcessor("File objects cache dead entries cleanup", 1);
    private static final int CLEAN_INTERVAL = Integer.getInteger("rfs.cache.cleanup.interval", 10000);
    private int cacheRequests = 0;
    private int cacheHits = 0;

    public RemoteFileObjectFactory(RemoteFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.env = fileSystem.getExecutionEnvironment();
        this.cleaningTask = RP.create(new Runnable(){

            public void run() {
                RemoteFileObjectFactory.this.cleanDeadEntries();
            }
        });
        this.scheduleCleanDeadEntries();
    }

    private void scheduleCleanDeadEntries() {
        this.cleaningTask.schedule(CLEAN_INTERVAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDeadEntries() {
        int size;
        Object object;
        boolean trace = RemoteLogger.getInstance().isLoggable(Level.FINEST);
        if (trace) {
            object = this.lock;
            synchronized (object) {
                size = this.fileObjectsCache.size();
            }
            if (RemoteLogger.getInstance().isLoggable(Level.FINEST)) {
                RemoteLogger.getInstance().log(Level.FINEST, "Cleaning file objects dead entries for {0} ... {1} entries and {2}% ({3} of {4}) hits so far", new Object[]{this.env, size, this.cacheRequests == 0 ? 0 : this.cacheHits * 100 / this.cacheRequests, this.cacheHits, this.cacheRequests});
            }
        }
        this.fileObjectsCache.cleanDeadEntries();
        if (trace) {
            object = this.lock;
            synchronized (object) {
                size = this.fileObjectsCache.size();
            }
            RemoteLogger.getInstance().log(Level.FINEST, "Cleaning file objects dead entries for {0} ... {1} entries left", new Object[]{this.env, size});
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.fileObjectsCache.size() > 0) {
                this.scheduleCleanDeadEntries();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteDirectory createRemoteDirectory(FileObject parent, String remotePath, File cacheFile) {
        ++this.cacheRequests;
        Object object = this.lock;
        synchronized (object) {
            RemoteFileObjectBase fo;
            if (this.fileObjectsCache.size() == 0) {
                this.scheduleCleanDeadEntries();
            }
            if ((fo = this.fileObjectsCache.get(remotePath)) instanceof RemoteDirectory && fo.isValid() && fo.cache.equals(cacheFile)) {
                ++this.cacheHits;
                return (RemoteDirectory)fo;
            }
            if (fo != null) {
                fo.invalidate();
            }
            fo = new RemoteDirectory(this.fileSystem, this.env, parent, remotePath, cacheFile);
            this.fileObjectsCache.put(remotePath, fo);
            return (RemoteDirectory)fo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemotePlainFile createRemotePlainFile(RemoteDirectory parent, String remotePath, File cacheFile, FileType fileType) {
        ++this.cacheRequests;
        Object object = this.lock;
        synchronized (object) {
            RemoteFileObjectBase fo;
            if (this.fileObjectsCache.size() == 0) {
                this.scheduleCleanDeadEntries();
            }
            if ((fo = this.fileObjectsCache.get(remotePath)) instanceof RemotePlainFile && fo.isValid() && fo.cache.equals(cacheFile) && fo.getType() == fileType) {
                ++this.cacheHits;
                return (RemotePlainFile)fo;
            }
            if (fo != null) {
                fo.invalidate();
            }
            fo = new RemotePlainFile(this.fileSystem, this.env, parent, remotePath, cacheFile, fileType);
            this.fileObjectsCache.put(remotePath, fo);
            return (RemotePlainFile)fo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteLink createRemoteLink(RemoteFileObjectBase parent, String remotePath, String link) {
        ++this.cacheRequests;
        Object object = this.lock;
        synchronized (object) {
            RemoteFileObjectBase fo;
            if (this.fileObjectsCache.size() == 0) {
                this.scheduleCleanDeadEntries();
            }
            if ((fo = this.fileObjectsCache.get(remotePath)) instanceof RemotePlainFile && fo.isValid() && fo.getType() == FileType.Symlink) {
                ++this.cacheHits;
                return (RemoteLink)fo;
            }
            if (fo != null) {
                fo.invalidate();
            }
            fo = new RemoteLink(this.fileSystem, this.env, (FileObject)parent, remotePath, link);
            this.fileObjectsCache.put(remotePath, fo);
            return (RemoteLink)fo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(String remotePath) {
        Object object = this.lock;
        synchronized (object) {
            RemoteFileObjectBase fo = this.fileObjectsCache.remove(remotePath);
            if (fo != null) {
                fo.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLink(RemoteDirectory parent, String linkRemotePath, String linkTarget) {
        Object object = this.lock;
        synchronized (object) {
            RemoteFileObjectBase fo = this.fileObjectsCache.get(linkRemotePath);
            if (fo != null) {
                if (fo instanceof RemoteLink) {
                    ((RemoteLink)fo).setLink(linkTarget, parent);
                } else {
                    RemoteLogger.getInstance().log(Level.FINE, "Called setLink on {0} - invalidating", fo.getClass().getSimpleName());
                    fo.invalidate();
                }
            }
        }
    }
}

