/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.ui;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoringElement;
import org.netbeans.modules.groovy.refactoring.Utils;
import org.netbeans.modules.groovy.refactoring.WhereUsedQueryConstants;
import org.netbeans.modules.groovy.refactoring.ui.WhereUsedPanel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WhereUsedQueryUI
implements RefactoringUI {
    private WhereUsedQuery query = null;
    private final String name;
    private WhereUsedPanel panel;
    private final GroovyRefactoringElement element;
    private ElementKind kind;
    private AbstractRefactoring delegate;
    private ResourceBundle bundle;

    public WhereUsedQueryUI(GroovyRefactoringElement jmiObject) {
        this.query = new WhereUsedQuery(Lookups.singleton((Object)((Object)jmiObject)));
        this.query.getContext().add((Object)Utils.getClasspathInfoFor(jmiObject.getFileObject()));
        this.element = jmiObject;
        this.name = jmiObject.getName();
        this.kind = jmiObject.getKind();
    }

    public WhereUsedQueryUI(GroovyRefactoringElement jmiObject, String name, AbstractRefactoring delegate) {
        this.delegate = delegate;
        this.element = jmiObject;
        this.name = name;
    }

    public boolean isQuery() {
        return true;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new WhereUsedPanel(this.name, this.element, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.query.putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.panel.isSearchInComments());
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.checkParameters();
        }
        if (this.kind == ElementKind.MODULE || this.kind == ElementKind.CLASS) {
            this.setForClass();
            return this.query.checkParameters();
        }
        return null;
    }

    private void setForMethod() {
        if (this.panel.isMethodFromBaseClass()) {
            this.query.setRefactoringSource(Lookups.singleton((Object)((Object)this.panel.getBaseMethod())));
        } else {
            this.query.setRefactoringSource(Lookups.singleton((Object)((Object)this.element)));
        }
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)this.panel.isMethodOverriders());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isMethodFindUsages());
    }

    private void setForClass() {
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES, (Object)this.panel.isClassSubTypes());
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES, (Object)this.panel.isClassSubTypesDirectOnly());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isClassFindUsages());
    }

    public Problem checkParameters() {
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.fastCheckParameters();
        }
        if (this.kind == ElementKind.CLASS || this.kind == ElementKind.MODULE) {
            this.setForClass();
            return this.query.fastCheckParameters();
        }
        return null;
    }

    public AbstractRefactoring getRefactoring() {
        return this.query != null ? this.query : this.delegate;
    }

    public String getDescription() {
        if (this.panel != null) {
            if (this.kind == ElementKind.MODULE || this.kind == ElementKind.CLASS) {
                if (!this.panel.isClassFindUsages()) {
                    if (!this.panel.isClassSubTypesDirectOnly()) {
                        return this.getString("DSC_WhereUsedFindAllSubTypes", this.name);
                    }
                    return this.getString("DSC_WhereUsedFindDirectSubTypes", this.name);
                }
            } else if (this.kind == ElementKind.METHOD) {
                String description = null;
                if (this.panel.isMethodFindUsages()) {
                    description = this.getString("DSC_FindUsages");
                }
                if (this.panel.isMethodOverriders()) {
                    description = description != null ? description + " " + this.getString("DSC_And") + " " : "";
                    description = description + this.getString("DSC_WhereUsedMethodOverriders");
                }
                description = description + " " + this.getString("DSC_WhereUsedOf", this.panel.getMethodDeclaringClass() + '.' + this.name);
                return description;
            }
        }
        return this.getString("DSC_WhereUsed", this.name);
    }

    private String getString(String key) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(WhereUsedQueryUI.class);
        }
        return this.bundle.getString(key);
    }

    private String getString(String key, String value) {
        return new MessageFormat(this.getString(key)).format(new Object[]{value});
    }

    public String getName() {
        return new MessageFormat(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed")).format(new Object[]{this.name});
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WhereUsedQueryUI.class);
    }
}

