/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.WebActionProvider;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class WebProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private WebProject project;
    private String libraryPath;
    private File libraryFile;
    private boolean libraryWithinProject;
    private String absolutesRelPath;

    public WebProjectOperations(WebProject webProject) {
        this.project = webProject;
    }

    private static void addFile(FileObject fileObject, String string, List<FileObject> list) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            list.add(fileObject2);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject fileObject = this.project.getProjectDirectory();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        WebProjectOperations.addFile(fileObject, "nbproject", arrayList);
        WebProjectOperations.addFile(fileObject, this.project.getBuildXmlName(), arrayList);
        WebProjectOperations.addFile(fileObject, "catalog.xml", arrayList);
        return arrayList;
    }

    public List<FileObject> getDataFiles() {
        FileObject fileObject;
        File file;
        FileObject fileObject2;
        FileObject fileObject3;
        FileObject fileObject4;
        File file2;
        FileObject fileObject5;
        FileObject fileObject6;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        FileObject fileObject7 = this.project.getAPIWebModule().getDocumentBase();
        if (fileObject7 != null) {
            arrayList.add(fileObject7);
        }
        if ((fileObject6 = this.project.getWebModule().getConfDir()) != null) {
            arrayList.add(fileObject6);
        }
        if (!((fileObject5 = this.project.getWebModule().getPersistenceXmlDir()) == null || fileObject6 != null && FileUtil.toFile((FileObject)fileObject5).equals(FileUtil.toFile((FileObject)fileObject6)))) {
            arrayList.add(fileObject5);
        }
        if ((file2 = this.project.getWebModule().getResourceDirectory()) != null && (fileObject4 = FileUtil.toFileObject((File)file2)) != null) {
            arrayList.add(fileObject4);
        }
        fileObject4 = this.project.getSourceRoots();
        FileObject[] fileObjectArray = fileObject4.getRoots();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (fileObjectArray[i] == null) continue;
            arrayList.add(fileObjectArray[i]);
        }
        PropertyEvaluator propertyEvaluator = this.project.evaluator();
        String string = propertyEvaluator.getProperty("source.root");
        if (string != null) {
            fileObject3 = this.project.getProjectDirectory();
            fileObject2 = this.project.getAntProjectHelper().resolveFileObject(string);
            if (fileObject2 != null && fileObject3 != fileObject2 && !arrayList.contains(fileObject2)) {
                arrayList.add(fileObject2);
            }
        }
        fileObject3 = this.project.getTestSourceRoots();
        fileObject2 = fileObject3.getRoots();
        for (int i = 0; i < ((FileObject)fileObject2).length; ++i) {
            if (fileObject2[i] == null) continue;
            arrayList.add(fileObject2[i]);
        }
        AntProjectHelper antProjectHelper = this.project.getAntProjectHelper();
        if (antProjectHelper.getLibrariesLocation() != null && (file = antProjectHelper.resolveFile(antProjectHelper.getLibrariesLocation())) != null && file.exists() && (fileObject = FileUtil.toFileObject((File)file).getParent()) != null && FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject)) {
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public void notifyDeleting() throws IOException {
        WebActionProvider webActionProvider = (WebActionProvider)((Object)this.project.getLookup().lookup(WebActionProvider.class));
        assert (webActionProvider != null);
        Lookup lookup = Lookups.fixed((Object[])new Object[0]);
        Properties properties = new Properties();
        String[] stringArray = webActionProvider.getTargetNames("clean", lookup, properties);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("build.xml");
        assert (stringArray != null);
        assert (stringArray.length > 0);
        ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, (Properties)properties).waitFinished();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
        this.rememberLibraryLocation();
    }

    public void notifyCopied(Project project, File file, final String string) {
        if (project == null) {
            return;
        }
        final String string2 = this.project.getName();
        this.project.getReferenceHelper().fixReferences(file);
        WebProjectOperations webProjectOperations = (WebProjectOperations)project.getLookup().lookup(WebProjectOperations.class);
        this.fixLibraryLocation(webProjectOperations);
        this.project.setName(string);
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                ProjectWebModule projectWebModule;
                AntProjectHelper antProjectHelper = WebProjectOperations.this.project.getAntProjectHelper();
                EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                String string4 = editableProperties.get((Object)"war.name");
                String string22 = editableProperties.get((Object)"war.ear.name");
                String string3 = string4.substring(0, string4.length() - 4);
                if (string4.endsWith(".war") && string3.equals(string2)) {
                    editableProperties.put("war.name", PropertyUtils.getUsablePropertyName((String)string) + ".war");
                }
                if (string22.endsWith(".war") && string3.equals(string2)) {
                    editableProperties.put("war.ear.name", PropertyUtils.getUsablePropertyName((String)string) + ".war");
                }
                if ((projectWebModule = (ProjectWebModule)WebProjectOperations.this.project.getLookup().lookup(ProjectWebModule.class)) != null) {
                    projectWebModule.setContextPath("/" + string);
                }
                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
            }
        });
    }

    public void notifyMoving() throws IOException {
        this.rememberLibraryLocation();
        this.notifyDeleting();
    }

    public void notifyMoved(Project project, File file, final String string) {
        if (project == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        final String string2 = this.project.getName();
        this.project.setName(string);
        this.project.getReferenceHelper().fixReferences(file);
        WebProjectOperations webProjectOperations = (WebProjectOperations)project.getLookup().lookup(WebProjectOperations.class);
        this.fixLibraryLocation(webProjectOperations);
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                String string6;
                ProjectWebModule projectWebModule;
                String string22;
                AntProjectHelper antProjectHelper = WebProjectOperations.this.project.getAntProjectHelper();
                EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/private/private.properties");
                String string3 = editableProperties.get((Object)"war.name");
                String string4 = editableProperties.get((Object)"war.ear.name");
                String string5 = string3.substring(0, string3.length() - 4);
                if (string3.endsWith(".war") && string5.equals(string2)) {
                    editableProperties.put("war.name", string + ".war");
                }
                if (string4.endsWith(".war") && string5.equals(string2)) {
                    editableProperties.put("war.ear.name", string + ".war");
                }
                if ((string22 = (projectWebModule = (ProjectWebModule)WebProjectOperations.this.project.getLookup().lookup(ProjectWebModule.class)).getContextPath(string6 = editableProperties2.getProperty("j2ee.server.instance"))) != null && string5.equals(string22.substring(1))) {
                    projectWebModule.setContextPath(string6, "/" + string);
                }
                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
            }
        });
    }

    private void fixLibraryLocation(WebProjectOperations webProjectOperations) throws IllegalArgumentException {
        String string = webProjectOperations.libraryPath;
        if (string != null) {
            if (!new File(string).isAbsolute()) {
                if (!webProjectOperations.libraryWithinProject) {
                    File file = webProjectOperations.libraryFile;
                    if (file == null) {
                        return;
                    }
                    String string2 = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)file);
                    if (string2 != null) {
                        this.project.getAntProjectHelper().setLibrariesLocation(string2);
                    } else {
                        this.project.getAntProjectHelper().setLibrariesLocation(file.getAbsolutePath());
                    }
                }
            } else if (webProjectOperations.libraryWithinProject && webProjectOperations.absolutesRelPath != null) {
                this.project.getAntProjectHelper().setLibrariesLocation(PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)webProjectOperations.absolutesRelPath).getAbsolutePath());
            }
        }
    }

    private void rememberLibraryLocation() {
        this.libraryWithinProject = false;
        this.absolutesRelPath = null;
        this.libraryPath = this.project.getAntProjectHelper().getLibrariesLocation();
        if (this.libraryPath != null) {
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            this.libraryFile = PropertyUtils.resolveFile((File)file, (String)this.libraryPath);
            if (FileOwnerQuery.getOwner((URI)this.libraryFile.toURI()) == this.project && this.libraryFile.getAbsolutePath().startsWith(file.getAbsolutePath())) {
                this.libraryWithinProject = true;
                FileObject fileObject = FileUtil.toFileObject((File)this.libraryFile);
                if (new File(this.libraryPath).isAbsolute() && fileObject != null) {
                    this.absolutesRelPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject);
                }
            }
        }
    }
}

