/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.javadoc.hints.Analyzer;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.openide.filesystems.FileObject;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class JavadocGenerator {
    private final SourceVersion srcVersion;
    private String author = System.getProperty("user.name");

    public JavadocGenerator(SourceVersion version) {
        this.srcVersion = version;
    }

    public String generateComment(TypeElement clazz, CompilationInfo javac) {
        StringBuilder builder = new StringBuilder("/**\n\n");
        if (clazz.getNestingKind() == NestingKind.TOP_LEVEL) {
            builder.append("@author " + this.author + "\n");
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0) {
            for (TypeParameterElement typeParameterElement : clazz.getTypeParameters()) {
                builder.append("@param <" + typeParameterElement.getSimpleName().toString() + "> \n");
            }
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(javac, clazz)) {
            builder.append("@deprecated\n");
        }
        builder.append("*/\n");
        return builder.toString();
    }

    public String generateComment(ExecutableElement method, CompilationInfo javac) {
        MethodTree tree;
        StringBuilder builder = new StringBuilder("/**\n\n");
        for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
            builder.append("@param <").append(typeParameterElement.getSimpleName().toString()).append("> \n");
        }
        for (VariableElement variableElement : method.getParameters()) {
            builder.append("@param ").append(variableElement.getSimpleName().toString()).append(" \n");
        }
        if (method.getReturnType().getKind() != TypeKind.VOID) {
            builder.append("@return \n");
        }
        List<? extends ExpressionTree> list = (tree = javac.getTrees().getTree(method)) != null ? tree.getThrows() : null;
        int i = 0;
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            CharSequence name;
            Element exception;
            if (TypeKind.DECLARED == typeMirror.getKind() || TypeKind.ERROR == typeMirror.getKind()) {
                exception = (TypeElement)((DeclaredType)typeMirror).asElement();
                name = exception.getQualifiedName();
                if (list != null) {
                    name = Analyzer.resolveThrowsName(exception, name.toString(), list.get(i));
                }
            } else if (TypeKind.TYPEVAR == typeMirror.getKind()) {
                exception = (TypeParameterElement)((TypeVariable)typeMirror).asElement();
                name = exception.getSimpleName();
            } else {
                throw new IllegalStateException("Illegal kind: " + (Object)((Object)typeMirror.getKind()));
            }
            builder.append("@throws ").append(name).append(" \n");
            ++i;
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(javac, method)) {
            builder.append("@deprecated\n");
        }
        builder.append("*/\n");
        return builder.toString();
    }

    public String generateComment(VariableElement field, CompilationInfo javac) {
        StringBuilder builder = new StringBuilder("/**\n\n");
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(javac, field)) {
            builder.append("@deprecated\n");
        }
        builder.append("*/\n");
        return builder.toString();
    }

    public String generateComment(Element elm, CompilationInfo javac) {
        switch (elm.getKind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                return this.generateComment((TypeElement)elm, javac);
            }
            case CONSTRUCTOR: 
            case METHOD: {
                return this.generateComment((ExecutableElement)elm, javac);
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                return this.generateComment((VariableElement)elm, javac);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)elm.getKind()) + ", " + elm.getClass() + ": " + elm.toString());
    }

    public String generateInheritComment() {
        return "/** {@inheritDoc} */";
    }

    public void updateSettings(FileObject file) {
        DataObject dobj = null;
        DataFolder folder = null;
        try {
            dobj = DataObject.find((FileObject)file);
            folder = dobj.getFolder();
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (dobj == null || folder == null) {
            return;
        }
        for (CreateFromTemplateAttributesProvider provider : Lookup.getDefault().lookupAll(CreateFromTemplateAttributesProvider.class)) {
            Object aName;
            Map attrs = provider.attributesFor(dobj, folder, "XXX");
            if (attrs == null || (aName = attrs.get("user")) == null) continue;
            this.author = aName.toString();
            break;
        }
    }
}

