/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.perfan.spi.datafilter.CollectedObjectsFilter;
import org.netbeans.modules.dlight.perfan.spi.datafilter.SunStudioFiltersProvider;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.DataraceImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.DeadlockImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.Erprint;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintCommand;
import org.netbeans.modules.dlight.perfan.storage.impl.ExperimentStatistics;
import org.netbeans.modules.dlight.perfan.storage.impl.FunctionStatistic;
import org.netbeans.modules.dlight.perfan.storage.impl.LeaksStatistics;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.perfan.storage.impl.ThreadsStatistic;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Exceptions;

public class ErprintSession {
    private static final AtomicInteger idCounter = new AtomicInteger(0);
    private static final Logger log = DLightLogger.getLogger(Erprint.class);
    private final int id = idCounter.incrementAndGet();
    private final NativeProcessBuilder npb;
    private volatile Erprint er_print;
    private final SunStudioFiltersProvider dataFiltersProvider;
    private String filterString;
    private volatile boolean ready;
    private volatile boolean error;
    private volatile boolean stopped;

    private ErprintSession(ExecutionEnvironment execEnv, String sproHome, String experimentDirectory, SunStudioFiltersProvider dataFiltersProvider) {
        String er_printCmd = sproHome + "/bin/er_print";
        NativeProcessBuilder erProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
        erProcessBuilder.setExecutable(er_printCmd);
        erProcessBuilder.setWorkingDirectory(experimentDirectory);
        erProcessBuilder.setArguments(new String[]{experimentDirectory}).unbufferOutput(true);
        this.dataFiltersProvider = dataFiltersProvider;
        this.npb = erProcessBuilder;
        this.npb.getEnvironment().put("LC_ALL", "C");
    }

    public static ErprintSession createNew(final ExecutionEnvironment execEnv, String sproHome, final String experimentDirectory, SunStudioFiltersProvider dataFiltersProvider) {
        final ErprintSession session = new ErprintSession(execEnv, sproHome, experimentDirectory, dataFiltersProvider);
        session.ready = false;
        session.error = false;
        session.stopped = false;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                while (!session.stopped && !Thread.interrupted()) {
                    try {
                        if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)(experimentDirectory + "/overview"))) {
                            Thread.sleep(200L);
                            continue;
                        }
                        session.ready = true;
                        return;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    catch (ConnectException ex) {
                        session.error = true;
                        return;
                    }
                    catch (IOException ex) {
                        session.error = true;
                        return;
                    }
                    break;
                }
                return;
            }
        };
        DLightExecutorService.submit((Runnable)r, (String)"ErprintSession: session warmup");
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFilters() {
        if (this.dataFiltersProvider != null) {
            List<DataFilter> filters;
            List<DataFilter> list = filters = this.dataFiltersProvider.getDataFilters();
            synchronized (list) {
                for (DataFilter filter : filters) {
                    try {
                        if (!(filter instanceof CollectedObjectsFilter)) continue;
                        this.er_print.selectObjects((CollectedObjectsFilter)filter);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        try {
            this.er_print.setFilter(this.filterString);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private synchronized Erprint restartAndLock(boolean restart) throws IOException {
        while (!this.ready) {
            if (Thread.interrupted()) {
                throw new IOException("Interrupted during warmup");
            }
            if (this.error) {
                throw new IOException("Error during warmup");
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        try {
            if (this.er_print == null || restart) {
                this.stop_er_print();
                this.er_print = new Erprint(this.npb, this.id);
                this.er_print.addLock();
                this.applyFilters();
            } else {
                try {
                    this.er_print.addLock();
                }
                catch (IllegalStateException ex) {}
            }
        }
        catch (Throwable ex) {
            log.log(Level.FINE, "Erprint restartAndLock() - caught an exception {0}", ex.getMessage());
        }
        if (this.er_print == null) {
            throw new IOException("Failed to start er_print");
        }
        return this.er_print;
    }

    private synchronized void stop_er_print() {
        if (this.er_print != null) {
            this.er_print.stop();
            this.er_print = null;
        }
    }

    public void close() {
        this.stopped = true;
        this.stop_er_print();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExperimentStatistics getExperimentStatistics(int timeout, boolean restart) throws IOException {
        Erprint erp = this.restartAndLock(restart);
        try {
            ExperimentStatistics experimentStatistics = erp.getExperimentStatistics();
            return experimentStatistics;
        }
        finally {
            erp.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadsStatistic getThreadsStatistic(int timeout, boolean restart) throws IOException {
        Erprint erp = this.restartAndLock(restart);
        try {
            ThreadsStatistic threadsStatistic = erp.getThreadsStatistics();
            return threadsStatistic;
        }
        finally {
            erp.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeaksStatistics getExperimentLeaks(boolean restart) throws IOException {
        Erprint erp = this.restartAndLock(restart);
        try {
            LeaksStatistics leaksStatistics = erp.getExperimentLeaks();
            return leaksStatistics;
        }
        finally {
            erp.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metrics getMetrics(boolean restart) throws IOException {
        Erprint erp = this.restartAndLock(restart);
        try {
            Metrics metrics = erp.getExperimentMetrics();
            return metrics;
        }
        finally {
            erp.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataraceImpl> getDataRaces(boolean restart) throws IOException {
        Erprint erp = this.restartAndLock(restart);
        try {
            List<DataraceImpl> list = erp.getDataRaces();
            return list;
        }
        finally {
            erp.releaseLock();
        }
    }

    public void setFilter(String filterString) {
        this.filterString = filterString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeadlockImpl> getDeadlocks(boolean restart) throws IOException {
        Erprint erp = this.restartAndLock(restart);
        try {
            List<DeadlockImpl> list = erp.getDeadlocks();
            return list;
        }
        finally {
            erp.releaseLock();
        }
    }

    public String[] getCallersCallees(int limit) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionStatistic getFunctionStatistic(String functionName, boolean restart) throws IOException {
        Erprint erp = this.restartAndLock(restart);
        try {
            FunctionStatistic functionStatistic = erp.getFunctionStatistic(functionName);
            return functionStatistic;
        }
        finally {
            erp.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionStatistic getFunctionStatistic(FunctionCallImpl functionCall, boolean restart) throws IOException {
        Erprint erp = this.restartAndLock(restart);
        try {
            FunctionStatistic functionStatistic = erp.getFunctionStatistic(functionCall);
            return functionStatistic;
        }
        finally {
            erp.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHotFunctions(Metrics metrics, int limit, int timeout, boolean restart) throws IOException {
        Erprint erp;
        Erprint erprint = erp = this.restartAndLock(restart);
        synchronized (erprint) {
            String[] stringArray;
            block7: {
                Metrics prev_metrics = null;
                try {
                    String[] result;
                    prev_metrics = erp.setMetrics(metrics);
                    stringArray = result = erp.getHotFunctions(limit);
                    if (prev_metrics == null) break block7;
                }
                catch (Throwable throwable) {
                    if (prev_metrics != null) {
                        erp.setMetrics(prev_metrics);
                    }
                    erp.releaseLock();
                    throw throwable;
                }
                erp.setMetrics(prev_metrics);
            }
            erp.releaseLock();
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHotFunctions(ErprintCommand command, Metrics metrics, int limit, boolean restart) throws IOException {
        Erprint erp;
        Erprint erprint = erp = this.restartAndLock(restart);
        synchronized (erprint) {
            String[] stringArray;
            Metrics prev_metrics = null;
            try {
                String[] result;
                prev_metrics = erp.setMetrics(metrics);
                stringArray = result = erp.getHotFunctions(command, limit);
            }
            catch (Throwable throwable) {
                try {
                    if (prev_metrics != null) {
                        erp.setMetrics(prev_metrics);
                    }
                }
                finally {
                    erp.releaseLock();
                }
                throw throwable;
            }
            try {
                if (prev_metrics != null) {
                    erp.setMetrics(prev_metrics);
                }
            }
            finally {
                erp.releaseLock();
            }
            return stringArray;
        }
    }
}

