/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.DocumentationScrollPane;
import org.netbeans.modules.web.beans.navigation.InjectableTreeNode;
import org.netbeans.modules.web.beans.navigation.JavaElement;
import org.netbeans.modules.web.beans.navigation.JavaHierarchyModel;
import org.netbeans.modules.web.beans.navigation.JavaTreeCellRenderer;
import org.netbeans.modules.web.beans.navigation.NoBorderToolBar;
import org.netbeans.modules.web.beans.navigation.Utils;
import org.netbeans.modules.web.beans.navigation.WebBeansNavigationOptions;
import org.netbeans.modules.web.beans.navigation.actions.ModelActionStrategy;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class InjectablesPanel
extends JPanel {
    private static final long serialVersionUID = -1643692494954311020L;
    public static final Icon FQN_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/fqn.gif", (boolean)false);
    public static final Icon EXPAND_ALL_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/expandall.gif", (boolean)false);
    private static final String NON_BINDING_MEMBER_ANNOTATION = "javax.enterprise.inject.NonBinding";
    private static TreeModel pleaseWaitTreeModel;
    private JLabel myBindingLbl;
    private JEditorPane myBindings;
    private JCheckBox myCaseSensitiveFilterCheckBox;
    private JButton myCloseButton;
    private JButton myExpandAllButton;
    private JLabel myFilterLabel;
    private JTextField myFilterTextField;
    private JLabel myFiltersLabel;
    private JToolBar myFiltersToolbar;
    private JLabel myInjectableBindingLbl;
    private JEditorPane myInjectableBindings;
    private JTree myJavaHierarchyTree;
    private JScrollPane myJavaHierarchyTreeScrollPane;
    private JSeparator mySeparator;
    private JToggleButton myShowFQNToggleButton;
    private JSplitPane mySplitPane;
    private JEditorPane myType;
    private JLabel myTypeLbl;
    private StringBuilder myFqnTypeName;
    private StringBuilder myShortTypeName;
    private String myFqnBindings;
    private String myShortBindings;
    private JavaHierarchyModel myJavaHierarchyModel;
    private DocumentationScrollPane myDocPane;
    private MetadataModel<WebBeansModel> myModel;
    private Component myLastFocusedComponent;

    public InjectablesPanel(final Object[] subject, MetadataModel<WebBeansModel> metaModel, WebBeansModel model, JavaHierarchyModel treeModel) {
        this.myJavaHierarchyModel = treeModel;
        this.initComponents();
        this.mySeparator.setVisible(false);
        this.myFilterLabel.setVisible(false);
        this.myFilterTextField.setVisible(false);
        this.myCaseSensitiveFilterCheckBox.setVisible(false);
        this.myModel = metaModel;
        this.myDocPane = new DocumentationScrollPane(true);
        this.mySplitPane.setRightComponent(this.myDocPane);
        this.mySplitPane.setDividerLocation(WebBeansNavigationOptions.getHierarchyDividerLocation());
        ToolTipManager.sharedInstance().registerComponent(this.myJavaHierarchyTree);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.myCaseSensitiveFilterCheckBox.setSelected(WebBeansNavigationOptions.isCaseSensitive());
        this.myShowFQNToggleButton.setSelected(WebBeansNavigationOptions.isShowFQN());
        if (model == null) {
            try {
                metaModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                    public Void run(WebBeansModel model) throws Exception {
                        InjectablesPanel.this.initCDIContext(subject, model);
                        return null;
                    }
                });
            }
            catch (MetadataModelException e) {
                Logger.getLogger(InjectablesPanel.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
            catch (IOException e) {
                Logger.getLogger(InjectablesPanel.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
        } else {
            this.initCDIContext(subject, model);
        }
        this.myJavaHierarchyTree.getSelectionModel().setSelectionMode(1);
        this.myJavaHierarchyTree.setRootVisible(false);
        this.myJavaHierarchyTree.setShowsRootHandles(true);
        this.myJavaHierarchyTree.setCellRenderer(new JavaTreeCellRenderer());
        this.myJavaHierarchyTree.setModel(this.myJavaHierarchyModel);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InjectablesPanel.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
        this.initListeners();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InjectablesPanel.this.reload();
                InjectablesPanel.this.myFilterTextField.requestFocusInWindow();
            }
        });
    }

    @Override
    public void removeNotify() {
        WebBeansNavigationOptions.setHierarchyDividerLocation(this.mySplitPane.getDividerLocation());
        this.myDocPane.setData(null);
        super.removeNotify();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        JRootPane rootPane;
        if ((e.getKeyCode() == 112 || e.getKeyCode() == 156) && (rootPane = SwingUtilities.getRootPane(this)) != null) {
            rootPane.putClientProperty("help", Boolean.TRUE);
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    protected JLabel getTypeLabel() {
        return this.myTypeLbl;
    }

    protected JLabel getInjectionQualifiersLabel() {
        return this.myBindingLbl;
    }

    protected void setInjectableType(TypeMirror typeMirror, CompilationController controller) {
        Element element;
        if (typeMirror.getKind().isPrimitive()) {
            this.myShortTypeName.append(typeMirror.getKind().toString().toLowerCase());
            this.myFqnTypeName.append((CharSequence)this.myShortTypeName);
            return;
        }
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            this.setInjectableArrayType(typeMirror, controller);
            this.myShortTypeName = this.myShortTypeName.append("[]");
            this.myFqnTypeName = this.myFqnTypeName.append("[]");
        }
        if ((element = controller.getTypes().asElement(typeMirror)) != null) {
            this.myFqnTypeName.append(element instanceof TypeElement ? ((TypeElement)element).getQualifiedName().toString() : element.getSimpleName().toString());
            this.myShortTypeName.append(element.getSimpleName().toString());
        }
    }

    protected Element getSelectedQualifiedElement(Element context, WebBeansModel model) {
        return context;
    }

    protected Element getSubjectElement(Element context, WebBeansModel model) {
        return context;
    }

    private void enterBusy() {
        Window window;
        this.myJavaHierarchyTree.setModel(pleaseWaitTreeModel);
        JRootPane rootPane = SwingUtilities.getRootPane(this);
        if (rootPane != null) {
            rootPane.setCursor(Cursor.getPredefinedCursor(3));
        }
        if ((window = SwingUtilities.getWindowAncestor(this)) != null) {
            this.myLastFocusedComponent = window.getFocusOwner();
        }
        this.myFilterTextField.setEnabled(false);
        this.myCaseSensitiveFilterCheckBox.setEnabled(false);
        this.myShowFQNToggleButton.setEnabled(false);
        this.myExpandAllButton.setEnabled(false);
    }

    private void leaveBusy() {
        this.myJavaHierarchyTree.setModel(this.myJavaHierarchyModel);
        JRootPane rootPane = SwingUtilities.getRootPane(this);
        if (rootPane != null) {
            rootPane.setCursor(Cursor.getDefaultCursor());
        }
        this.myFilterTextField.setEnabled(true);
        this.myCaseSensitiveFilterCheckBox.setEnabled(true);
        this.myShowFQNToggleButton.setEnabled(true);
        this.myExpandAllButton.setEnabled(true);
        if (this.myLastFocusedComponent != null) {
            if (this.myLastFocusedComponent.isDisplayable()) {
                this.myLastFocusedComponent.requestFocusInWindow();
            }
            this.myLastFocusedComponent = null;
        }
    }

    private void reload() {
        this.enterBusy();
        WebBeansNavigationOptions.setCaseSensitive(this.myCaseSensitiveFilterCheckBox.isSelected());
        WebBeansNavigationOptions.setShowFQN(this.myShowFQNToggleButton.isSelected());
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    InjectablesPanel.this.myJavaHierarchyModel.update();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InjectablesPanel.this.leaveBusy();
                            for (int row = 0; row < InjectablesPanel.this.myJavaHierarchyTree.getRowCount(); ++row) {
                                InjectablesPanel.this.myJavaHierarchyTree.expandRow(row);
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void expandAll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JRootPane rootPane = SwingUtilities.getRootPane(InjectablesPanel.this);
                if (rootPane != null) {
                    rootPane.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (int row = 0; row < InjectablesPanel.this.myJavaHierarchyTree.getRowCount(); ++row) {
                        InjectablesPanel.this.myJavaHierarchyTree.expandRow(row);
                    }
                    InjectablesPanel.this.selectMatchingRow();
                }
                finally {
                    JRootPane rootPane = SwingUtilities.getRootPane(InjectablesPanel.this);
                    if (rootPane != null) {
                        rootPane.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
    }

    private void selectMatchingRow() {
        this.myFilterTextField.setForeground(UIManager.getColor("TextField.foreground"));
        this.myJavaHierarchyTree.setSelectionRow(-1);
        for (int row = 0; row < this.myJavaHierarchyTree.getRowCount(); ++row) {
            String filterText;
            Object o = this.myJavaHierarchyTree.getPathForRow(row).getLastPathComponent();
            if (!(o instanceof JavaElement) || !Utils.patternMatch((JavaElement)o, filterText = this.myFilterTextField.getText(), filterText.toLowerCase())) continue;
            this.myJavaHierarchyTree.setSelectionRow(row);
            this.myJavaHierarchyTree.scrollRowToVisible(row);
            return;
        }
        this.myFilterTextField.setForeground(Color.RED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoElement(JavaElement javaToolsJavaElement) {
        try {
            javaToolsJavaElement.gotoElement();
        }
        finally {
            this.close();
        }
    }

    private void showBindings() {
        Object node;
        this.myInjectableBindings.setToolTipText(null);
        TreePath treePath = this.myJavaHierarchyTree.getSelectionPath();
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof InjectableTreeNode) {
            final ElementHandle elementHandle = ((InjectableTreeNode)node).getElementHandle();
            try {
                this.getModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                    public Void run(WebBeansModel model) throws Exception {
                        Element element = elementHandle.resolve((CompilationInfo)model.getCompilationController());
                        if (element == null) {
                            InjectablesPanel.this.myInjectableBindings.setText("");
                        } else {
                            element = InjectablesPanel.this.getSelectedQualifiedElement(element, model);
                            List<AnnotationMirror> bindings = model.getQualifiers(element);
                            StringBuilder builder = new StringBuilder();
                            for (AnnotationMirror annotationMirror : bindings) {
                                InjectablesPanel.this.appendBinding(annotationMirror, builder, InjectablesPanel.this.myShowFQNToggleButton.isSelected());
                            }
                            String bindingsString = "";
                            if (builder.length() > 0) {
                                bindingsString = builder.substring(0, builder.length() - 2);
                            }
                            InjectablesPanel.this.myInjectableBindings.setText(bindingsString);
                        }
                        return null;
                    }
                });
            }
            catch (MetadataModelException e) {
                Logger.getLogger(InjectablesPanel.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
            catch (IOException e) {
                Logger.getLogger(InjectablesPanel.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
            this.myInjectableBindings.setCaretPosition(0);
            this.myInjectableBindings.setToolTipText(((JavaElement)node).getTooltip());
        }
    }

    private void showJavaDoc() {
        Object node;
        TreePath treePath = this.myJavaHierarchyTree.getSelectionPath();
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
            this.myDocPane.setData(((JavaElement)node).getJavaDoc());
        }
    }

    private void close() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.setVisible(false);
        }
    }

    private MetadataModel<WebBeansModel> getModel() {
        return this.myModel;
    }

    private void initCDIContext(Object[] subject, WebBeansModel model) {
        Element element = null;
        element = subject[2] == ModelActionStrategy.InspectActionId.INJECTABLES ? WebBeansActionHelper.findVariable(model, subject) : ((ElementHandle)subject[0]).resolve((CompilationInfo)model.getCompilationController());
        Element context = this.getSubjectElement(element, model);
        if (context == null) {
            return;
        }
        TypeMirror typeMirror = context.asType();
        this.myShortTypeName = new StringBuilder();
        this.myFqnTypeName = new StringBuilder();
        this.setInjectableType(typeMirror, model.getCompilationController());
        List<AnnotationMirror> qualifiers = model.getQualifiers(context);
        StringBuilder fqnBuilder = new StringBuilder();
        StringBuilder builder = new StringBuilder();
        for (AnnotationMirror annotationMirror : qualifiers) {
            this.appendBinding(annotationMirror, fqnBuilder, true);
            this.appendBinding(annotationMirror, builder, false);
        }
        if (fqnBuilder.length() > 0) {
            this.myFqnBindings = fqnBuilder.substring(0, fqnBuilder.length() - 2);
            this.myShortBindings = builder.substring(0, builder.length() - 2);
        } else {
            this.myFqnBindings = "";
            this.myShortBindings = "";
        }
        if (this.myShowFQNToggleButton.isSelected()) {
            this.myBindings.setText(this.myFqnBindings);
        } else {
            this.myBindings.setText(this.myShortBindings);
        }
        this.reloadInjectionPoint();
    }

    private void setInjectableArrayType(TypeMirror typeMirror, CompilationController controller) {
        TypeMirror componentType = ((ArrayType)typeMirror).getComponentType();
        this.setInjectableType(componentType, controller);
    }

    private void appendBinding(AnnotationMirror mirror, StringBuilder builder, boolean isFqn) {
        DeclaredType type = mirror.getAnnotationType();
        Element annotation = type.asElement();
        builder.append("@");
        String annotationName = isFqn ? (annotation instanceof TypeElement ? ((TypeElement)annotation).getQualifiedName().toString() : annotation.getSimpleName().toString()) : annotation.getSimpleName().toString();
        builder.append(annotationName);
        this.appendBindingParamters(mirror, builder);
        builder.append(", ");
    }

    private void appendBindingParamters(AnnotationMirror mirror, StringBuilder builder) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        StringBuilder params = new StringBuilder();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            ExecutableElement key = entry.getKey();
            AnnotationValue value = entry.getValue();
            List<? extends AnnotationMirror> annotationMirrors = key.getAnnotationMirrors();
            boolean nonBinding = false;
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                Element element = annotationType.asElement();
                if (!(element instanceof TypeElement) || !((TypeElement)element).getQualifiedName().contentEquals(NON_BINDING_MEMBER_ANNOTATION)) continue;
                nonBinding = true;
                break;
            }
            if (nonBinding) continue;
            params.append(key.getSimpleName().toString());
            params.append("=");
            if (value.getValue() instanceof String) {
                params.append('\"');
                params.append(value.getValue().toString());
                params.append('\"');
            } else {
                params.append(value.getValue().toString());
            }
            params.append(", ");
        }
        if (params.length() > 0) {
            builder.append("(");
            builder.append(params.substring(0, params.length() - 2));
            builder.append(")");
        }
    }

    private void reloadInjectionPoint() {
        if (this.myShowFQNToggleButton.isSelected()) {
            this.myBindings.setText(this.myFqnBindings);
            this.myType.setText(this.myFqnTypeName.toString());
        } else {
            this.myBindings.setText(this.myShortBindings);
            this.myType.setText(this.myShortTypeName.toString());
        }
    }

    private void initListeners() {
        this.myFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                InjectablesPanel.this.selectMatchingRow();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InjectablesPanel.this.selectMatchingRow();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                InjectablesPanel.this.selectMatchingRow();
            }
        });
        this.registerKeyboardActions();
        this.myCaseSensitiveFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebBeansNavigationOptions.setCaseSensitive(InjectablesPanel.this.myCaseSensitiveFilterCheckBox.isSelected());
                if (InjectablesPanel.this.myFilterTextField.getText().trim().length() > 0) {
                    InjectablesPanel.this.selectMatchingRow();
                }
            }
        });
        this.myJavaHierarchyTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Object node;
                Point point = me.getPoint();
                TreePath treePath = InjectablesPanel.this.myJavaHierarchyTree.getPathForLocation(point.x, point.y);
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement && me.getClickCount() == 2) {
                    InjectablesPanel.this.gotoElement((JavaElement)node);
                }
            }
        });
        this.myJavaHierarchyTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                InjectablesPanel.this.showBindings();
                InjectablesPanel.this.showJavaDoc();
            }
        });
        this.myShowFQNToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebBeansNavigationOptions.setShowFQN(InjectablesPanel.this.myShowFQNToggleButton.isSelected());
                InjectablesPanel.this.myJavaHierarchyModel.fireTreeNodesChanged();
                InjectablesPanel.this.reloadInjectionPoint();
                InjectablesPanel.this.showBindings();
            }
        });
        this.myExpandAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InjectablesPanel.this.expandAll();
            }
        });
        this.myCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InjectablesPanel.this.close();
            }
        });
    }

    private void registerKeyboardActions() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(InjectablesPanel.this.myJavaHierarchyTree);
            }
        };
        this.myFilterTextField.registerKeyboardAction(listener, KeyStroke.getKeyStroke(36, 0, false), 0);
        this.myBindings.registerKeyboardAction(listener, KeyStroke.getKeyStroke(36, 0, false), 0);
        listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(InjectablesPanel.this.myJavaHierarchyTree);
            }
        };
        this.myFilterTextField.registerKeyboardAction(listener, KeyStroke.getKeyStroke(38, 0, false), 0);
        this.myBindings.registerKeyboardAction(listener, KeyStroke.getKeyStroke(38, 0, false), 0);
        listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(InjectablesPanel.this.myJavaHierarchyTree);
            }
        };
        this.myFilterTextField.registerKeyboardAction(listener, KeyStroke.getKeyStroke(40, 0, false), 0);
        this.myBindings.registerKeyboardAction(listener, KeyStroke.getKeyStroke(40, 0, false), 0);
        listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(InjectablesPanel.this.myJavaHierarchyTree);
            }
        };
        this.myFilterTextField.registerKeyboardAction(listener, KeyStroke.getKeyStroke(35, 0, false), 0);
        this.myBindings.registerKeyboardAction(listener, KeyStroke.getKeyStroke(35, 0, false), 0);
        this.myBindings.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.myFilterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = InjectablesPanel.this.myJavaHierarchyTree.getSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    InjectablesPanel.this.gotoElement((JavaElement)node);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.myFilterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component view = InjectablesPanel.this.myDocPane.getViewport().getView();
                if (view instanceof JEditorPane) {
                    JEditorPane editorPane = (JEditorPane)view;
                    ActionListener actionForKeyStroke = editorPane.getActionForKeyStroke(KeyStroke.getKeyStroke(33, 0, false));
                    actionForKeyStroke.actionPerformed(new ActionEvent(editorPane, 1001, ""));
                }
            }
        }, KeyStroke.getKeyStroke(33, 1, false), 0);
        this.myFilterTextField.registerKeyboardAction(new ActionListener(){
            private boolean firstTime = true;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component view = InjectablesPanel.this.myDocPane.getViewport().getView();
                if (view instanceof JEditorPane) {
                    JEditorPane editorPane = (JEditorPane)view;
                    ActionListener actionForKeyStroke = editorPane.getActionForKeyStroke(KeyStroke.getKeyStroke(34, 0, false));
                    actionEvent = new ActionEvent(editorPane, 1001, "");
                    actionForKeyStroke.actionPerformed(actionEvent);
                    if (this.firstTime) {
                        actionForKeyStroke.actionPerformed(actionEvent);
                        this.firstTime = false;
                    }
                }
            }
        }, KeyStroke.getKeyStroke(34, 1, false), 0);
        this.myJavaHierarchyTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = InjectablesPanel.this.myJavaHierarchyTree.getLeadSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    InjectablesPanel.this.gotoElement((JavaElement)node);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    private void initComponents() {
        this.mySplitPane = new JSplitPane();
        this.myJavaHierarchyTreeScrollPane = new JScrollPane();
        this.myJavaHierarchyTree = new JTree();
        this.myFilterLabel = new JLabel();
        this.myFilterTextField = new JTextField();
        this.myCaseSensitiveFilterCheckBox = new JCheckBox();
        this.myFiltersLabel = new JLabel();
        this.myCloseButton = new JButton();
        this.myFiltersToolbar = new NoBorderToolBar();
        this.myShowFQNToggleButton = new JToggleButton();
        this.myExpandAllButton = new JButton();
        this.mySeparator = new JSeparator();
        this.myBindings = new JEditorPane();
        this.myBindingLbl = new JLabel();
        this.myType = new JEditorPane();
        this.myTypeLbl = new JLabel();
        this.myInjectableBindings = new JEditorPane();
        this.myInjectableBindingLbl = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.mySplitPane.setDividerLocation(300);
        this.myJavaHierarchyTreeScrollPane.setBorder(null);
        this.myJavaHierarchyTreeScrollPane.setViewportView(this.myJavaHierarchyTree);
        this.myJavaHierarchyTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_InjectableHierarchy"));
        this.mySplitPane.setLeftComponent(this.myJavaHierarchyTreeScrollPane);
        this.myFilterLabel.setLabelFor(this.myFilterTextField);
        Mnemonics.setLocalizedText((JLabel)this.myFilterLabel, (String)NbBundle.getBundle(InjectablesPanel.class).getString("LABEL_filterLabel"));
        this.myFilterTextField.setToolTipText(NbBundle.getBundle(InjectablesPanel.class).getString("TOOLTIP_filterTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCaseSensitiveFilterCheckBox, (String)NbBundle.getBundle(InjectablesPanel.class).getString("LABEL_caseSensitiveFilterCheckBox"));
        this.myCaseSensitiveFilterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.myFiltersLabel, (String)NbBundle.getMessage(InjectablesPanel.class, (String)"LABEL_filtersLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCloseButton, (String)NbBundle.getMessage(InjectablesPanel.class, (String)"LABEL_Close"));
        this.myFiltersToolbar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.myFiltersToolbar.setFloatable(false);
        this.myFiltersToolbar.setBorderPainted(false);
        this.myFiltersToolbar.setOpaque(false);
        this.myShowFQNToggleButton.setIcon(FQN_ICON);
        this.myShowFQNToggleButton.setMnemonic('Q');
        this.myShowFQNToggleButton.setToolTipText(NbBundle.getBundle(InjectablesPanel.class).getString("TOOLTIP_showFQNToggleButton"));
        this.myShowFQNToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.myFiltersToolbar.add(this.myShowFQNToggleButton);
        this.myExpandAllButton.setIcon(EXPAND_ALL_ICON);
        this.myExpandAllButton.setMnemonic('E');
        this.myExpandAllButton.setToolTipText(NbBundle.getMessage(InjectablesPanel.class, (String)"TOOLTIP_expandAll"));
        this.myExpandAllButton.setMargin(new Insets(2, 2, 2, 2));
        this.myFiltersToolbar.add(this.myExpandAllButton);
        this.myBindings.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.myBindings.setContentType("text/x-java");
        this.myBindings.setEditable(false);
        this.myBindingLbl.setLabelFor(this.myBindings);
        Mnemonics.setLocalizedText((JLabel)this.myBindingLbl, (String)NbBundle.getMessage(InjectablesPanel.class, (String)"LBL_Bindings"));
        this.myType.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.myType.setContentType("text/x-java");
        this.myType.setEditable(false);
        this.myTypeLbl.setLabelFor(this.myType);
        Mnemonics.setLocalizedText((JLabel)this.myTypeLbl, (String)NbBundle.getMessage(InjectablesPanel.class, (String)"LBL_Type"));
        this.myInjectableBindings.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.myInjectableBindings.setContentType("text/x-java");
        this.myInjectableBindings.setEditable(false);
        this.myInjectableBindingLbl.setLabelFor(this.myInjectableBindings);
        Mnemonics.setLocalizedText((JLabel)this.myInjectableBindingLbl, (String)NbBundle.getMessage(InjectablesPanel.class, (String)"LBL_CurrentElementBindings"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.mySplitPane, -1, 641, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.myFilterLabel).addPreferredGap(0).add((Component)this.myFilterTextField, -1, 516, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.myCaseSensitiveFilterCheckBox)).add((Component)this.mySeparator, -1, 641, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.myBindingLbl).add((Component)this.myTypeLbl)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.myType, -1, 518, Short.MAX_VALUE).add((Component)this.myBindings, -1, 518, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.myFiltersLabel).addPreferredGap(0).add((Component)this.myFiltersToolbar, -1, 539, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.myCloseButton)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.myInjectableBindingLbl).addPreferredGap(0).add((Component)this.myInjectableBindings, -1, 588, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.myTypeLbl).add((Component)this.myType, -2, 20, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.myBindings, -2, 20, -2).add((Component)this.myBindingLbl)).addPreferredGap(0).add((Component)this.mySeparator, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.myFilterLabel).add((Component)this.myFilterTextField, -2, -1, -2).add((Component)this.myCaseSensitiveFilterCheckBox)).addPreferredGap(0).add((Component)this.mySplitPane, -1, 202, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.myInjectableBindingLbl).add((Component)this.myInjectableBindings, -2, 20, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.myFiltersLabel).add((Component)this.myCloseButton)).add((Component)this.myFiltersToolbar, -2, 25, -2)).addContainerGap()));
        this.myFilterLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_TextFilter"));
        this.myFilterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_TextFilter"));
        this.myFilterTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_TextFieldFilter"));
        this.myCaseSensitiveFilterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_CaseSensitive"));
        this.myCaseSensitiveFilterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"caseSensitiveFilterCheckBox_ACSD"));
        this.myFiltersLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_Filters"));
        this.myFiltersLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_Filters"));
        this.myCloseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_Close"));
        this.myCloseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_Close"));
        this.myBindingLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_Bindings"));
        this.myBindingLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_Bindnigs"));
        this.myTypeLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_Type"));
        this.myTypeLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_Type"));
        this.myInjectableBindingLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_InjectableBindings"));
        this.myInjectableBindingLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_InjectableBindnigs"));
    }

    static {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.add(new DefaultMutableTreeNode(NbBundle.getMessage(InjectablesPanel.class, (String)"LBL_WaitNode")));
        pleaseWaitTreeModel = new DefaultTreeModel(root);
    }
}

