/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.web.beans.api.model.AbstractModelImplementation;
import org.netbeans.modules.web.beans.impl.model.AssignabilityChecker;
import org.netbeans.modules.web.beans.impl.model.FieldInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.MemberBindingFilter;
import org.netbeans.modules.web.beans.impl.model.MemberCheckerFilter;
import org.netbeans.modules.web.beans.impl.model.ParameterInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelProviderImpl;

abstract class EventInjectionPointLogic
extends ParameterInjectionPointLogic {
    public static final String EVENT_INTERFACE = "javax.enterprise.event.Event";

    EventInjectionPointLogic() {
    }

    @Override
    public List<ExecutableElement> getObservers(VariableElement element, DeclaredType parentType, AbstractModelImplementation modelImplementation) {
        WebBeansModelImplementation impl = WebBeansModelProviderImpl.getImplementation(modelImplementation);
        if (impl == null) {
            return Collections.emptyList();
        }
        DeclaredType parent = parentType;
        try {
            parent = this.getParent(element, parentType, impl);
        }
        catch (FieldInjectionPointLogic.DefinitionError e) {
            return null;
        }
        TypeMirror type = this.getParameterType(element, parent, impl.getHelper().getCompilationController(), EVENT_INTERFACE);
        LinkedList<AnnotationMirror> qualifierAnnotations = new LinkedList<AnnotationMirror>();
        try {
            this.hasAnyQualifier(element, impl, true, true, qualifierAnnotations);
        }
        catch (FieldInjectionPointLogic.InjectionPointDefinitionError e) {
            return null;
        }
        boolean hasAny = qualifierAnnotations.size() == 0;
        List<ObserverTriple> methodObservesParameters = this.findObservesParameters(impl.getHelper());
        HashMap<Element, TypeMirror> parameterTypesMap = new HashMap<Element, TypeMirror>();
        for (ObserverTriple triple : methodObservesParameters) {
            ExecutableElement method = (ExecutableElement)triple.getFirst();
            VariableElement parameter = (VariableElement)triple.getSecond();
            int index = (Integer)triple.getThird();
            TypeElement typeElement = impl.getHelper().getCompilationController().getElementUtilities().enclosingTypeElement((Element)method);
            TypeMirror typeMirror = typeElement.asType();
            if (!(typeMirror instanceof DeclaredType)) continue;
            ExecutableType methodType = (ExecutableType)impl.getHelper().getCompilationController().getTypes().asMemberOf((DeclaredType)typeMirror, method);
            List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
            TypeMirror parameterType = parameterTypes.get(index);
            parameterTypesMap.put(parameter, parameterType);
        }
        if (!hasAny) {
            Set<Element> elements = parameterTypesMap.keySet();
            this.filterByQualifiers(qualifierAnnotations, elements, impl.getHelper().getCompilationController());
            this.filterBindingsByMembers(qualifierAnnotations, elements, impl, Element.class);
        }
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>(parameterTypesMap.size());
        this.filterParametersByType(parameterTypesMap, type, impl);
        for (Element parameter : parameterTypesMap.keySet()) {
            Element method = parameter.getEnclosingElement();
            if (method.getKind() != ElementKind.METHOD) continue;
            result.add((ExecutableElement)method);
        }
        return result;
    }

    @Override
    public VariableElement getObserverParameter(ExecutableElement element, AbstractModelImplementation modelImplementation) {
        WebBeansModelImplementation impl = WebBeansModelProviderImpl.getImplementation(modelImplementation);
        if (impl == null) {
            return null;
        }
        Triple<VariableElement, Integer, Void> result = this.doGetObserverParameter(element, impl);
        if (result == null) {
            return null;
        }
        return result.getFirst();
    }

    @Override
    public List<VariableElement> getEventInjectionPoints(ExecutableElement element, DeclaredType parentType, AbstractModelImplementation modelImplementation) {
        WebBeansModelImplementation impl = WebBeansModelProviderImpl.getImplementation(modelImplementation);
        if (impl == null) {
            return null;
        }
        DeclaredType parent = parentType;
        try {
            parent = this.getParent(element, parentType, impl);
        }
        catch (FieldInjectionPointLogic.DefinitionError e) {
            return null;
        }
        TypeMirror type = impl.getHelper().getCompilationController().getTypes().asMemberOf(parent, element);
        Triple<VariableElement, Integer, Void> parameterInfo = this.doGetObserverParameter(element, impl);
        VariableElement parameter = parameterInfo.getFirst();
        int index = parameterInfo.getSecond();
        if (parameter == null) {
            return Collections.emptyList();
        }
        List<VariableElement> eventInjectionPoints = this.getEventInjectionPoints(impl);
        this.filterByQualifiers(eventInjectionPoints, parameter, impl);
        List<? extends TypeMirror> parameterTypes = ((ExecutableType)type).getParameterTypes();
        TypeMirror parameterType = parameterTypes.get(index);
        this.filterEventInjectionsByType(eventInjectionPoints, parameterType, impl);
        return eventInjectionPoints;
    }

    private List<VariableElement> getEventInjectionPoints(final WebBeansModelImplementation impl) {
        final LinkedList<VariableElement> eventInjection = new LinkedList<VariableElement>();
        try {
            impl.getHelper().getAnnotationScanner().findAnnotations("javax.inject.Inject", EnumSet.of(ElementKind.FIELD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    Name name;
                    Element typeElement = impl.getHelper().getCompilationController().getTypes().asElement(element.asType());
                    if (typeElement instanceof TypeElement && element instanceof VariableElement && EventInjectionPointLogic.EVENT_INTERFACE.contentEquals(name = ((TypeElement)typeElement).getQualifiedName())) {
                        eventInjection.add((VariableElement)element);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            LOGGER.warning("Finding annotation @Inject was interrupted");
        }
        return eventInjection;
    }

    private void filterByQualifiers(List<? extends AnnotationMirror> qualifierAnnotations, Set<Element> elements, CompilationController compilationController) {
        Set<String> requiredQualifiers = this.getAnnotationFqns(qualifierAnnotations);
        Iterator<Element> iterator = elements.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            List<? extends AnnotationMirror> annotationMirrors = compilationController.getElements().getAllAnnotationMirrors(element);
            Set<String> availableAnnotations = this.getAnnotationFqns(annotationMirrors);
            if (availableAnnotations.containsAll(requiredQualifiers)) continue;
            iterator.remove();
        }
    }

    private void filterByQualifiers(List<VariableElement> injectionPoints, VariableElement parameter, WebBeansModelImplementation impl) {
        List<? extends AnnotationMirror> annotationMirrors = impl.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(parameter);
        Set<String> parameterAnnotations = this.getAnnotationFqns(annotationMirrors);
        Iterator<VariableElement> iterator = injectionPoints.iterator();
        while (iterator.hasNext()) {
            VariableElement eventInjection = iterator.next();
            LinkedList<AnnotationMirror> eventQualifiers = new LinkedList<AnnotationMirror>();
            try {
                this.hasAnyQualifier(eventInjection, impl, true, true, eventQualifiers);
            }
            catch (FieldInjectionPointLogic.InjectionPointDefinitionError e) {
                iterator.remove();
                continue;
            }
            boolean hasAny = eventQualifiers.size() == 0;
            if (hasAny) continue;
            Set<String> requiredQuaifiers = this.getAnnotationFqns(eventQualifiers);
            if (!parameterAnnotations.containsAll(requiredQuaifiers)) {
                iterator.remove();
                continue;
            }
            if (this.checkQualifierMembers(eventQualifiers, annotationMirrors, impl)) continue;
            iterator.remove();
        }
    }

    private boolean checkQualifierMembers(List<AnnotationMirror> eventQualifiers, List<? extends AnnotationMirror> observerAnnotations, WebBeansModelImplementation impl) {
        for (AnnotationMirror annotation : eventQualifiers) {
            Set<ExecutableElement> qualifierMembers;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotation.getElementValues();
            if (this.checkMember(elementValues, qualifierMembers = MemberBindingFilter.collectBindingMembers(annotation, impl), observerAnnotations, impl)) continue;
            return false;
        }
        return true;
    }

    private boolean checkMember(Map<? extends ExecutableElement, ? extends AnnotationValue> memberValues, Set<ExecutableElement> qualifierMembers, List<? extends AnnotationMirror> observerAnnotations, WebBeansModelImplementation impl) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : memberValues.entrySet()) {
            ExecutableElement execElement = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!qualifierMembers.contains(execElement)) continue;
            Element annotationElement = execElement.getEnclosingElement();
            if (!(annotationElement instanceof TypeElement)) {
                return false;
            }
            String annotationName = ((TypeElement)annotationElement).getQualifiedName().toString();
            AnnotationMirror annotationMirror = (AnnotationMirror)impl.getHelper().getAnnotationsByType(observerAnnotations).get(annotationName);
            if (annotationMirror == null) {
                return false;
            }
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            AnnotationValue valueForType = elementValues.get(execElement);
            if (MemberCheckerFilter.equals(value, valueForType)) continue;
            return false;
        }
        return true;
    }

    private Triple<VariableElement, Integer, Void> doGetObserverParameter(ExecutableElement element, WebBeansModelImplementation impl) {
        List<? extends VariableElement> parameters = element.getParameters();
        int index = 0;
        for (VariableElement variableElement : parameters) {
            List<? extends AnnotationMirror> allAnnotationMirrors = impl.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(variableElement);
            for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                TypeElement annotation = (TypeElement)annotationType.asElement();
                if (!"javax.enterprise.event.Observes".contentEquals(annotation.getQualifiedName())) continue;
                return new Triple<VariableElement, Integer, Object>(variableElement, index, null);
            }
            ++index;
        }
        return null;
    }

    private Set<String> getAnnotationFqns(List<? extends AnnotationMirror> annotations) {
        HashSet<String> annotationFqns = new HashSet<String>();
        for (AnnotationMirror annotationMirror : annotations) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            Element annotationElement = annotationType.asElement();
            TypeElement annotation = (TypeElement)annotationElement;
            annotationFqns.add(annotation.getQualifiedName().toString());
        }
        return annotationFqns;
    }

    private void filterParametersByType(Map<Element, TypeMirror> parameterTypesMap, TypeMirror type, WebBeansModelImplementation impl) {
        AssignabilityChecker checker = new AssignabilityChecker(true);
        Iterator<Map.Entry<Element, TypeMirror>> iterator = parameterTypesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Element, TypeMirror> entry = iterator.next();
            TypeMirror typeMirror = entry.getValue();
            boolean assignable = this.isAssignable(type, typeMirror, checker, impl);
            if (assignable) continue;
            iterator.remove();
        }
    }

    private void filterEventInjectionsByType(List<VariableElement> eventInjectionPoints, TypeMirror parameterType, WebBeansModelImplementation impl) {
        AssignabilityChecker checker = new AssignabilityChecker(true);
        Iterator<VariableElement> iterator = eventInjectionPoints.iterator();
        while (iterator.hasNext()) {
            VariableElement injection = iterator.next();
            TypeMirror type = this.getParameterType(injection, null, impl.getHelper().getCompilationController(), EVENT_INTERFACE);
            boolean assignable = this.isAssignable(type, parameterType, checker, impl);
            if (assignable) continue;
            iterator.remove();
        }
    }

    private boolean isAssignable(TypeMirror subject, TypeMirror toType, AssignabilityChecker checker, WebBeansModelImplementation impl) {
        boolean isGeneric;
        boolean assignable = false;
        Element typeElement = impl.getHelper().getCompilationController().getTypes().asElement(toType);
        boolean bl = isGeneric = typeElement instanceof TypeElement && ((TypeElement)typeElement).getTypeParameters().size() != 0;
        if (!isGeneric && impl.getHelper().getCompilationController().getTypes().isAssignable(subject, toType)) {
            return true;
        }
        if (subject instanceof ReferenceType && toType instanceof ReferenceType) {
            checker.init((ReferenceType)toType, (ReferenceType)subject, impl);
            assignable = checker.check();
        }
        return assignable;
    }

    private List<ObserverTriple> findObservesParameters(AnnotationModelHelper helper) {
        LinkedList<ObserverTriple> result = new LinkedList<ObserverTriple>();
        CompilationController compilationController = helper.getCompilationController();
        TypeElement observesType = compilationController.getElements().getTypeElement("javax.enterprise.event.Observes");
        ElementHandle observesHandle = ElementHandle.create((Element)observesType);
        Set elementHandles = compilationController.getClasspathInfo().getClassIndex().getElements(observesHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        for (ElementHandle elementHandle : elementHandles) {
            TypeElement resolvedType = (TypeElement)elementHandle.resolve((CompilationInfo)compilationController);
            List<? extends Element> enclosedElements = resolvedType.getEnclosedElements();
            List<ExecutableElement> methods = ElementFilter.methodsIn(enclosedElements);
            for (ExecutableElement method : methods) {
                List<? extends VariableElement> parameters = method.getParameters();
                int index = 0;
                for (VariableElement variableElement : parameters) {
                    List<? extends AnnotationMirror> annotationMirrors = compilationController.getElements().getAllAnnotationMirrors(variableElement);
                    if (helper.hasAnnotation(annotationMirrors, "javax.enterprise.event.Observes")) {
                        result.add(new ObserverTriple(method, variableElement, index));
                    }
                    ++index;
                }
            }
        }
        return result;
    }

    private static class Triple<T, R, S> {
        private T myFirst;
        private R mySecond;
        private S myThird;

        Triple(T t, R r, S s) {
            this.myFirst = t;
            this.mySecond = r;
            this.myThird = s;
        }

        T getFirst() {
            return this.myFirst;
        }

        R getSecond() {
            return this.mySecond;
        }

        S getThird() {
            return this.myThird;
        }
    }

    private class ObserverTriple
    extends Triple<ExecutableElement, VariableElement, Integer> {
        ObserverTriple(ExecutableElement method, VariableElement parameter, Integer index) {
            super(method, parameter, index);
        }
    }
}

