/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.web.beans.api.model.BeansModel;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.PackagingFilter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.impl.model.results.ErrorImpl;
import org.netbeans.modules.web.beans.impl.model.results.InjectableResultImpl;
import org.netbeans.modules.web.beans.impl.model.results.ResolutionErrorImpl;
import org.netbeans.modules.web.beans.impl.model.results.ResultImpl;
import org.openide.util.NbBundle;

class EnableBeansFilter {
    private Set<Element> myAlternatives;
    private Set<Element> myEnabledAlternatives;
    private ResultImpl myResult;
    private final AnnotationModelHelper myHelper;
    private final BeansModel myBeansModel;
    private WebBeansModelImplementation myModel;

    EnableBeansFilter(ResultImpl result, WebBeansModelImplementation model) {
        this.myResult = result;
        this.myHelper = model.getHelper();
        this.myBeansModel = model.getBeansModel();
        this.myModel = model;
    }

    Result filter() {
        boolean hasSingleAlternative;
        this.myAlternatives = new HashSet<Element>();
        this.myEnabledAlternatives = new HashSet<Element>();
        PackagingFilter filter = new PackagingFilter(this.myModel);
        Set<TypeElement> typeElements = this.getResult().getTypeElements();
        filter.filter(typeElements);
        for (TypeElement typeElement : typeElements) {
            if (!this.getResult().isAlternative(typeElement)) continue;
            this.myAlternatives.add(typeElement);
            this.addEnabledAlternative(typeElement, typeElement);
        }
        Set<Element> productions = this.packagedFilterProductions();
        for (Element element : productions) {
            TypeElement enclosingTypeElement = this.myHelper.getCompilationController().getElementUtilities().enclosingTypeElement(element);
            if (!this.getResult().isAlternative(element)) continue;
            this.myAlternatives.add(element);
            this.addEnabledAlternative(enclosingTypeElement, element);
        }
        HashSet<Element> enabledTypeElements = new HashSet<Element>(typeElements);
        HashSet<Element> enabledProductions = new HashSet<Element>(productions);
        this.myAlternatives.removeAll(this.myEnabledAlternatives);
        enabledProductions.removeAll(this.myAlternatives);
        enabledTypeElements.removeAll(this.myAlternatives);
        int typesSize = enabledTypeElements.size();
        int productionsSize = enabledProductions.size();
        Set<Element> enabledTypes = this.findEnabledTypes(enabledTypeElements);
        this.findEnabledProductions(enabledProductions);
        int commonSize = enabledTypes.size() + enabledProductions.size();
        if (commonSize == 1) {
            Element injectable = enabledTypes.size() == 0 ? (Element)enabledProductions.iterator().next() : enabledTypes.iterator().next();
            enabledTypes.addAll(enabledProductions);
            return new InjectableResultImpl(this.getResult(), injectable, enabledTypes);
        }
        if (commonSize == 0) {
            if (typeElements.size() == 0 && productions.size() == 0) {
                return new ErrorImpl(this.getResult().getVariable(), this.getResult().getVariableType(), NbBundle.getMessage(EnableBeansFilter.class, (String)"ERR_NoFound"));
            }
            if (typesSize == 0 && productionsSize == 0) {
                return new ResolutionErrorImpl(this.getResult(), NbBundle.getMessage(EnableBeansFilter.class, (String)"ERR_AlternativesOnly"));
            }
            return new ResolutionErrorImpl(this.getResult(), NbBundle.getMessage(EnableBeansFilter.class, (String)"ERR_NoEnabledBeans"));
        }
        HashSet<Element> allElements = new HashSet<Element>(enabledTypes);
        allElements.addAll(enabledProductions);
        allElements.retainAll(this.myEnabledAlternatives);
        boolean bl = hasSingleAlternative = allElements.size() == 1;
        if (hasSingleAlternative) {
            enabledTypes.addAll(enabledProductions);
            return new InjectableResultImpl(this.getResult(), (Element)allElements.iterator().next(), enabledTypes);
        }
        enabledTypes.addAll(enabledProductions);
        String message = NbBundle.getMessage(EnableBeansFilter.class, (String)"ERR_UnresolvedAmbiguousDependency");
        return new ResolutionErrorImpl(this.getResult(), message, enabledTypes);
    }

    private Set<Element> packagedFilterProductions() {
        return this.getResult().getProductions();
    }

    private void findEnabledProductions(Set<Element> productions) {
        Iterator<Element> iterator = productions.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            TypeElement enclosingTypeElement = this.getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(element);
            if (!this.getResult().isAlternative(enclosingTypeElement)) continue;
            String name = enclosingTypeElement.getQualifiedName().toString();
            if (this.getResult().hasAlternative(enclosingTypeElement) && !this.getModel().getAlternativeClasses().contains(name)) {
                iterator.remove();
            }
            if (this.alternativeStereotypesEnabled(enclosingTypeElement)) continue;
            iterator.remove();
        }
    }

    private Set<Element> findEnabledTypes(Set<Element> elements) {
        LinkedList<Element> types = new LinkedList<Element>(elements);
        HashSet<Element> result = new HashSet<Element>(elements);
        while (types.size() != 0) {
            TypeElement typeElement = (TypeElement)types.remove();
            if (typeElement.getKind() != ElementKind.CLASS) {
                result.remove(typeElement);
                continue;
            }
            this.checkProxyability(typeElement, types, result);
            this.checkSpecializes(typeElement, types, result, elements);
        }
        return result;
    }

    private void checkProxyability(TypeElement typeElement, LinkedList<Element> types, Set<Element> result) {
        if (this.hasModifier(typeElement, Modifier.FINAL)) {
            types.remove(typeElement);
            result.remove(typeElement);
            return;
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        for (ExecutableElement executableElement : methods) {
            if (!this.hasModifier(executableElement, Modifier.FINAL)) continue;
            types.remove(typeElement);
            result.remove(typeElement);
            return;
        }
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
        boolean appropriateCtor = false;
        for (ExecutableElement constructor : constructors) {
            if (this.hasModifier(constructor, Modifier.PRIVATE) || constructor.getParameters().size() != 0) continue;
            appropriateCtor = true;
            break;
        }
        if (!appropriateCtor) {
            types.remove(typeElement);
            result.remove(typeElement);
        }
    }

    private boolean hasModifier(Element element, Modifier mod) {
        Set<Modifier> modifiers = element.getModifiers();
        for (Modifier modifier : modifiers) {
            if (!modifier.equals((Object)mod)) continue;
            return true;
        }
        return false;
    }

    private void checkSpecializes(TypeElement typeElement, LinkedList<Element> beans, Set<Element> resultSet, Set<Element> originalElements) {
        TypeMirror superClass;
        TypeElement current = typeElement;
        while (current != null && (superClass = current.getSuperclass()) instanceof DeclaredType && AnnotationObjectProvider.hasSpecializes(current, this.getHelper())) {
            TypeElement superElement = (TypeElement)((DeclaredType)superClass).asElement();
            if (originalElements.contains(superElement)) {
                resultSet.remove(superElement);
            }
            beans.remove(superElement);
            if (!this.getResult().getTypeElements().contains(superElement)) break;
            current = superElement;
        }
    }

    private void addEnabledAlternative(TypeElement typeElement, Element element) {
        String name = typeElement.getQualifiedName().toString();
        if (this.getResult().hasAlternative(element) && !this.getModel().getAlternativeClasses().contains(name)) {
            return;
        }
        if (this.alternativeStereotypesEnabled(element)) {
            this.myEnabledAlternatives.add(element);
        }
    }

    private boolean alternativeStereotypesEnabled(Element element) {
        List<AnnotationMirror> stereotypes = this.getResult().getStereotypes(element);
        for (AnnotationMirror annotationMirror : stereotypes) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            TypeElement annotationTypeElement = (TypeElement)annotationType.asElement();
            if (!this.getResult().isAlternative(annotationTypeElement)) continue;
            if (this.getResult().hasAlternative(annotationTypeElement)) {
                String name = annotationTypeElement.getQualifiedName().toString();
                if (this.getModel().getAlternativeStereotypes().contains(name)) continue;
                return false;
            }
            if (this.alternativeStereotypesEnabled(annotationTypeElement)) continue;
            return false;
        }
        return true;
    }

    private ResultImpl getResult() {
        return this.myResult;
    }

    private BeansModel getModel() {
        return this.myBeansModel;
    }

    private AnnotationModelHelper getHelper() {
        return this.myHelper;
    }
}

