/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.api.model;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.web.beans.api.model.AbstractModelImplementation;
import org.netbeans.modules.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.model.spi.WebBeansModelProvider;

public final class WebBeansModel {
    private AbstractModelImplementation myImpl;

    WebBeansModel(AbstractModelImplementation impl) {
        this.myImpl = impl;
    }

    public Result getInjectable(VariableElement element, DeclaredType parentType) {
        if (this.getProvider() == null) {
            return null;
        }
        return this.getProvider().getInjectable(element, parentType, this.getModelImplementation());
    }

    public Result lookupInjectables(VariableElement element, DeclaredType parentType) {
        if (this.getProvider() == null) {
            return null;
        }
        return this.getProvider().lookupInjectables(element, parentType, this.getModelImplementation());
    }

    public boolean isInjectionPoint(VariableElement element) throws InjectionPointDefinitionError {
        if (this.getProvider() == null) {
            return false;
        }
        return this.getProvider().isInjectionPoint(element, this.getModelImplementation());
    }

    public boolean isEventInjectionPoint(VariableElement element) {
        String typeElementFqn;
        TypeMirror elementType = element.asType();
        Element typeElement = this.getCompilationController().getTypes().asElement(elementType);
        if (typeElement instanceof TypeElement && "javax.enterprise.event.Event".equals(typeElementFqn = ((TypeElement)typeElement).getQualifiedName().toString())) {
            try {
                return this.isInjectionPoint(element);
            }
            catch (InjectionPointDefinitionError e) {
                return false;
            }
        }
        return false;
    }

    public boolean isDynamicInjectionPoint(VariableElement element) {
        if (this.getProvider() == null) {
            return false;
        }
        return this.getProvider().isDynamicInjectionPoint(element, this.getModelImplementation());
    }

    public List<Element> getNamedElements() {
        if (this.getProvider() == null) {
            return Collections.emptyList();
        }
        return this.getProvider().getNamedElements(this.getModelImplementation());
    }

    public String getName(Element element) {
        if (this.getProvider() == null) {
            return null;
        }
        return this.getProvider().getName(element, this.getModelImplementation());
    }

    public TypeMirror resolveType(String fqn) {
        if (this.getProvider() == null) {
            return null;
        }
        return this.getProvider().resolveType(fqn, this.getModelImplementation().getHelper());
    }

    public CompilationController getCompilationController() {
        return this.getModelImplementation().getHelper().getCompilationController();
    }

    public List<AnnotationMirror> getQualifiers(Element element) {
        return this.getProvider().getQualifiers(element, this.getModelImplementation());
    }

    public List<ExecutableElement> getObservers(VariableElement element, DeclaredType parentType) {
        return this.getProvider().getObservers(element, parentType, this.getModelImplementation());
    }

    public List<VariableElement> getEventInjectionPoints(ExecutableElement element, DeclaredType parentType) {
        return this.getProvider().getEventInjectionPoints(element, parentType, this.getModelImplementation());
    }

    public VariableElement getObserverParameter(ExecutableElement element) {
        return this.getProvider().getObserverParameter(element, this.getModelImplementation());
    }

    public AbstractModelImplementation getModelImplementation() {
        return this.myImpl;
    }

    private WebBeansModelProvider getProvider() {
        return this.getModelImplementation().getProvider();
    }
}

