/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.tasks.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RepositoryClientManager<T, C extends Serializable>
implements IRepositoryListener {
    private final Map<String, T> clientByUrl = new HashMap<String, T>();
    private final Map<String, C> clientDataByUrl = new HashMap<String, C>();
    private final File cacheFile;
    private TaskRepositoryLocationFactory taskRepositoryLocationFactory;

    public RepositoryClientManager(File cacheFile) {
        Assert.isNotNull((Object)cacheFile);
        this.cacheFile = cacheFile;
        this.readCache();
    }

    public synchronized T getClient(TaskRepository taskRepository) {
        Assert.isNotNull((Object)((Object)taskRepository));
        T client = this.clientByUrl.get(taskRepository.getRepositoryUrl());
        if (client == null) {
            Serializable data = (Serializable)this.clientDataByUrl.get(taskRepository.getRepositoryUrl());
            if (data == null) {
                data = this.createRepositoryConfiguration();
                this.clientDataByUrl.put(taskRepository.getRepositoryUrl(), data);
            }
            client = this.createClient(taskRepository, data);
            this.clientByUrl.put(taskRepository.getRepositoryUrl(), client);
        }
        return client;
    }

    protected abstract C createRepositoryConfiguration();

    protected abstract T createClient(TaskRepository var1, C var2);

    public void repositoriesRead() {
    }

    @Override
    public synchronized void repositoryAdded(TaskRepository repository) {
        this.removeClient(repository);
        this.clientDataByUrl.remove(repository.getRepositoryUrl());
    }

    private void removeClient(TaskRepository repository) {
        this.clientByUrl.remove(repository.getRepositoryUrl());
    }

    @Override
    public synchronized void repositoryRemoved(TaskRepository repository) {
        this.removeClient(repository);
        this.clientDataByUrl.remove(repository.getRepositoryUrl());
    }

    @Override
    public synchronized void repositorySettingsChanged(TaskRepository repository) {
        this.removeClient(repository);
    }

    public void readCache() {
        block17: {
            if (this.cacheFile == null || !this.cacheFile.exists()) {
                return;
            }
            ObjectInputStream in = null;
            try {
                try {
                    in = new ObjectInputStream(new FileInputStream(this.cacheFile));
                    int size = in.readInt();
                    int i = 0;
                    while (i < size) {
                        String url = (String)in.readObject();
                        Serializable data = (Serializable)in.readObject();
                        if (url != null && data != null) {
                            this.clientDataByUrl.put(url, data);
                        }
                        ++i;
                    }
                }
                catch (Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "The respository configuration cache could not be read", e));
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void writeCache() {
        block16: {
            if (this.cacheFile == null) {
                return;
            }
            ObjectOutputStream out = null;
            try {
                try {
                    out = new ObjectOutputStream(new FileOutputStream(this.cacheFile));
                    out.writeInt(this.clientDataByUrl.size());
                    for (String url : this.clientDataByUrl.keySet()) {
                        out.writeObject(url);
                        out.writeObject(this.clientDataByUrl.get(url));
                    }
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "The respository configuration cache could not be written", (Throwable)e));
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory) {
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
    }

    @Override
    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
    }
}

