/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.projectimport.ImportExecutable;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationPanel;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.bridge.DiscoveryProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DiscoveryExtension
implements IteratorExtension,
DiscoveryExtensionInterface {
    public void discoverArtifacts(Map<String, Object> map) {
        DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(map);
        DiscoveryExtensionInterface.Applicable applicable = this.isApplicable(discoveryDescriptor);
        if (applicable != null) {
            if (applicable.isApplicable()) {
                discoveryDescriptor.setCompilerName(applicable.getCompilerName());
                discoveryDescriptor.setDependencies(applicable.getDependencies());
                discoveryDescriptor.setSearchPaths(applicable.getSearchPaths());
                discoveryDescriptor.setRootFolder(applicable.getSourceRoot());
                discoveryDescriptor.setErrors(applicable.getErrors());
            } else {
                discoveryDescriptor.setErrors(applicable.getErrors());
            }
        }
    }

    public Set<FileObject> createProject(WizardDescriptor wizardDescriptor) throws IOException {
        return new ImportProject(wizardDescriptor).create();
    }

    @Override
    public void apply(Map<String, Object> map, Project project) throws IOException {
        DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(map);
        discoveryDescriptor.setProject(project);
        DiscoveryProjectGenerator discoveryProjectGenerator = new DiscoveryProjectGenerator(discoveryDescriptor);
        discoveryProjectGenerator.makeProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryExtensionInterface.Applicable isApplicable(DiscoveryDescriptor discoveryDescriptor) {
        SelectConfigurationPanel.MyProgress myProgress = new SelectConfigurationPanel.MyProgress();
        myProgress.start(0);
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            DiscoveryExtensionInterface.Applicable applicable = this.isApplicableDwarfExecutable(discoveryDescriptor);
            if (applicable.isApplicable()) {
                DiscoveryExtensionInterface.Applicable applicable2 = applicable;
                return applicable2;
            }
            if (applicable.getErrors() != null) {
                arrayList.addAll(applicable.getErrors());
            }
            if ((applicable = this.isApplicableMakeLog(discoveryDescriptor)).isApplicable()) {
                DiscoveryExtensionInterface.Applicable applicable3 = applicable;
                return applicable3;
            }
            if (applicable.getErrors() != null) {
                arrayList.addAll(applicable.getErrors());
            }
            if ((applicable = this.isApplicableDwarfFolder(discoveryDescriptor)).isApplicable()) {
                DiscoveryExtensionInterface.Applicable applicable4 = applicable;
                return applicable4;
            }
            if (applicable.getErrors() != null) {
                arrayList.addAll(applicable.getErrors());
            }
            if (!arrayList.isEmpty()) {
                DiscoveryExtensionInterface.Applicable applicable5 = ApplicableImpl.getNotApplicable(arrayList);
                return applicable5;
            }
            DiscoveryExtensionInterface.Applicable applicable6 = ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NoExecutable_NoBaseFolder")));
            return applicable6;
        }
        finally {
            myProgress.done();
        }
    }

    private DiscoveryExtensionInterface.Applicable isApplicableDwarfExecutable(DiscoveryDescriptor discoveryDescriptor) {
        String string = discoveryDescriptor.getBuildResult();
        if (string == null) {
            return ApplicableImpl.getNotApplicable(null);
        }
        File file = new File(string);
        if (!file.exists()) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundExecutable", (Object)string)));
        }
        ProjectProxyImpl projectProxyImpl = new ProjectProxyImpl(discoveryDescriptor);
        DiscoveryProvider discoveryProvider = DiscoveryExtension.findProvider("dwarf-executable");
        if (discoveryProvider != null && discoveryProvider.isApplicable(projectProxyImpl)) {
            discoveryProvider.getProperty("executable").setValue(string);
            discoveryProvider.getProperty("libraries").setValue(new String[0]);
            DiscoveryExtensionInterface.Applicable applicable = discoveryProvider.canAnalyze(projectProxyImpl);
            if (applicable.isApplicable()) {
                discoveryDescriptor.setProvider(discoveryProvider);
                return applicable;
            }
            if (applicable.getErrors().size() > 0) {
                return ApplicableImpl.getNotApplicable(applicable.getErrors());
            }
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"CannotAnalyzeExecutable", (Object)string)));
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundDiscoveryProvider")));
    }

    private DiscoveryExtensionInterface.Applicable isApplicableDwarfFolder(DiscoveryDescriptor discoveryDescriptor) {
        String string = discoveryDescriptor.getRootFolder();
        if (string == null) {
            return ApplicableImpl.getNotApplicable(null);
        }
        ProjectProxyImpl projectProxyImpl = new ProjectProxyImpl(discoveryDescriptor);
        DiscoveryProvider discoveryProvider = DiscoveryExtension.findProvider("dwarf-folder");
        if (discoveryProvider != null && discoveryProvider.isApplicable(projectProxyImpl)) {
            discoveryProvider.getProperty("folder").setValue(string);
            DiscoveryExtensionInterface.Applicable applicable = discoveryProvider.canAnalyze(projectProxyImpl);
            if (applicable.isApplicable()) {
                discoveryDescriptor.setProvider(discoveryProvider);
                return applicable;
            }
            if (applicable.getErrors().size() > 0) {
                return ApplicableImpl.getNotApplicable(applicable.getErrors());
            }
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"CannotAnalyzeFolder", (Object)string)));
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundDiscoveryProvider")));
    }

    private DiscoveryExtensionInterface.Applicable isApplicableMakeLog(DiscoveryDescriptor discoveryDescriptor) {
        String string = discoveryDescriptor.getRootFolder();
        if (string == null) {
            return ApplicableImpl.getNotApplicable(null);
        }
        String string2 = discoveryDescriptor.getBuildLog();
        ProjectProxyImpl projectProxyImpl = new ProjectProxyImpl(discoveryDescriptor);
        DiscoveryProvider discoveryProvider = DiscoveryExtension.findProvider("make-log");
        if (discoveryProvider != null && discoveryProvider.isApplicable(projectProxyImpl)) {
            discoveryProvider.getProperty("make-log-file").setValue(string2);
            DiscoveryExtensionInterface.Applicable applicable = discoveryProvider.canAnalyze(projectProxyImpl);
            if (applicable.isApplicable()) {
                discoveryDescriptor.setProvider(discoveryProvider);
                return applicable;
            }
            if (applicable.getErrors().size() > 0) {
                return ApplicableImpl.getNotApplicable(applicable.getErrors());
            }
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"CannotAnalyzeFolder", (Object)string)));
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundDiscoveryProvider")));
    }

    public DiscoveryExtensionInterface.Applicable isApplicable(Map<String, Object> map, Project project) {
        DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(map);
        return this.isApplicable(discoveryDescriptor);
    }

    public boolean canApply(DiscoveryDescriptor discoveryDescriptor) {
        if (!this.isApplicable(discoveryDescriptor).isApplicable()) {
            return false;
        }
        String string = discoveryDescriptor.getLevel();
        if (string == null || string.length() == 0) {
            return false;
        }
        DiscoveryProvider discoveryProvider = discoveryDescriptor.getProvider();
        if (discoveryProvider == null) {
            return false;
        }
        if ("dwarf-executable".equals(discoveryProvider.getID())) {
            String string2 = discoveryDescriptor.getBuildResult();
            String string3 = discoveryDescriptor.getAditionalLibraries();
            discoveryProvider.getProperty("executable").setValue(string2);
            if (string3 != null && string3.length() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                discoveryProvider.getProperty("libraries").setValue(arrayList.toArray(new String[arrayList.size()]));
            } else {
                discoveryProvider.getProperty("libraries").setValue(new String[0]);
            }
        } else if ("dwarf-folder".equals(discoveryProvider.getID())) {
            String string4 = discoveryDescriptor.getRootFolder();
            discoveryProvider.getProperty("folder").setValue(string4);
        } else if (!"make-log".equals(discoveryProvider.getID())) {
            return false;
        }
        SelectConfigurationPanel.buildModel(discoveryDescriptor);
        return !discoveryDescriptor.isInvokeProvider() && discoveryDescriptor.getConfigurations() != null && discoveryDescriptor.getConfigurations().size() > 0 && discoveryDescriptor.getIncludedFiles() != null;
    }

    @Override
    public boolean canApply(Map<String, Object> map, Project project) {
        DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(map);
        discoveryDescriptor.setProject(project);
        return this.canApply(discoveryDescriptor);
    }

    static DiscoveryProvider findProvider(String string) {
        for (DiscoveryProvider discoveryProvider : Lookup.getDefault().lookupAll(DiscoveryProvider.class)) {
            if (!string.equals(discoveryProvider.getID())) continue;
            discoveryProvider.clean();
            return discoveryProvider;
        }
        return null;
    }

    public void discoverProject(Map<String, Object> map, Project project, IteratorExtension.ProjectKind projectKind) {
        ImportExecutable importExecutable = new ImportExecutable(map, project, projectKind);
        if (project != null) {
            importExecutable.process(this);
        }
    }

    private static class ProjectProxyImpl
    implements ProjectProxy {
        private DiscoveryDescriptor descriptor;

        private ProjectProxyImpl(DiscoveryDescriptor discoveryDescriptor) {
            this.descriptor = discoveryDescriptor;
        }

        @Override
        public boolean createSubProjects() {
            return false;
        }

        @Override
        public Project getProject() {
            return null;
        }

        @Override
        public String getMakefile() {
            return null;
        }

        @Override
        public String getSourceRoot() {
            return this.descriptor.getRootFolder();
        }

        @Override
        public String getExecutable() {
            return this.descriptor.getBuildResult();
        }

        @Override
        public String getWorkingFolder() {
            return null;
        }
    }
}

