/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.util.Map;
import org.openide.util.Lookup;

public abstract class KnownProject {
    public static final String PROJECT = "project";
    public static final String ROOT = "root";
    public static final String NB_ROOT = "netbeans-project";
    private static KnownProject DEFAULT = new Default();

    public abstract boolean canCreate(Map<String, String> var1);

    public abstract boolean create(Map<String, String> var1);

    protected KnownProject() {
    }

    public static synchronized KnownProject getDefault() {
        return DEFAULT;
    }

    private static final class Default
    extends KnownProject {
        private final Lookup.Result<KnownProject> res = Lookup.getDefault().lookupResult(KnownProject.class);

        Default() {
        }

        @Override
        public boolean canCreate(Map<String, String> parameters) {
            KnownProject creator = this.find(parameters);
            return creator != null;
        }

        @Override
        public boolean create(Map<String, String> parameters) {
            KnownProject creator = this.find(parameters);
            if (creator != null) {
                return creator.create(parameters);
            }
            return false;
        }

        private KnownProject find(Map<String, String> parameters) {
            for (KnownProject creator : this.res.allInstances()) {
                if (!creator.canCreate(parameters)) continue;
                return creator;
            }
            return null;
        }
    }
}

