/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui.preview;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.netbeans.modules.css.editor.model.CssModel;
import org.netbeans.modules.css.editor.model.CssRule;
import org.netbeans.modules.css.editor.model.CssRuleContent;
import org.netbeans.modules.css.visual.api.CssRuleContext;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewTopComponent;
import org.openide.util.NbBundle;

public class CssPreviewGenerator {
    private static final String HTML_PREFIX = "<html>\n\t<head>\n\t\t<style type=\"text/css\">\n";
    private static final String HTML_MIDDLE = "\t\t</style>\n\t</head>\n\t<body>\n\t\t";
    private static final String HTML_POSTFIX = "\t</body>\n</html>\n";
    private static final String SAMPLE_TEXT = NbBundle.getMessage(CssPreviewTopComponent.class, (String)"Sample_Text");

    static String getEmptyDocumentContent() {
        return HTML_PREFIX + HTML_MIDDLE + HTML_POSTFIX;
    }

    public static CharSequence getPreviewCode(CssRuleContext content) {
        StringBuilder preview = new StringBuilder();
        preview.append(HTML_PREFIX);
        StringBuilder sb = new StringBuilder();
        ArrayList<CssModel> models = new ArrayList<CssModel>();
        models.add(content.model());
        models.addAll(content.model().getImportedFileModels());
        for (CssModel model : models) {
            for (CssRule rule : model.rules()) {
                String ruleName = rule.name();
                while (ruleName.indexOf(91) > 0) {
                    int startBracket = ruleName.indexOf(91);
                    int endBracket = ruleName.indexOf(93, startBracket);
                    ruleName = ruleName.substring(0, startBracket) + ruleName.substring(endBracket + 1);
                }
                sb.append(ruleName.replaceAll(":", "X"));
                sb.append(" {\n");
                sb.append(CssRuleContent.create(rule).getFormattedString().replace('\"', '\''));
                sb.append("\n }\n");
            }
        }
        preview.append((CharSequence)sb);
        preview.append(HTML_MIDDLE);
        CssRule selected = content.selectedRuleContent().rule();
        String ruleName = selected.name();
        ruleName = ruleName.replace('\n', ' ');
        int commaIndex = ruleName.indexOf(44);
        if (commaIndex > 0) {
            ruleName = ruleName.substring(0, commaIndex);
        }
        while (ruleName.indexOf(91) > 0) {
            int startBracket = ruleName.indexOf(91);
            int endBracket = ruleName.indexOf(93, startBracket);
            ruleName = ruleName.substring(0, startBracket) + ruleName.substring(endBracket + 1);
        }
        StringTokenizer st = new StringTokenizer(ruleName, " >");
        ArrayList<String> selectors = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String selector = st.nextToken();
            selectors.add("*".equals(selector.trim()) ? "div" : selector);
        }
        if (selectors.size() == 0) {
            selectors.add("div");
        } else if (selectors.size() == 1) {
            String single = (String)selectors.get(0);
            if ("table".equalsIgnoreCase(single)) {
                selectors.add("tr");
                selectors.add("td");
                selectors.add("div");
            } else if ("tr".equalsIgnoreCase(single)) {
                selectors.add(0, "table");
                selectors.add("td");
                selectors.add("div");
            } else if ("td".equalsIgnoreCase(single)) {
                selectors.add(0, "table");
                selectors.add(1, "tr");
                selectors.add("div");
            }
        }
        int previewFocus = preview.length();
        for (String selectorItem : selectors) {
            StringBuilder opening = new StringBuilder();
            StringBuilder closing = new StringBuilder();
            int firstColonIndex = selectorItem.indexOf(58);
            if (firstColonIndex >= 0) {
                String realName;
                String selector = selectorItem.substring(0, firstColonIndex);
                String enclosingSelector = firstColonIndex == 0 ? "div" : selector;
                ArrayList<String> pseudoclass = new ArrayList<String>(2);
                int colonIndex = selectorItem.indexOf(58, firstColonIndex + 1);
                while (colonIndex > 0) {
                    realName = selectorItem.substring(firstColonIndex + 1, colonIndex);
                    pseudoclass.add(realName.replaceAll(":", "X"));
                    colonIndex = selectorItem.indexOf(58, colonIndex + 1);
                }
                realName = selectorItem.substring(firstColonIndex + 1, selectorItem.length());
                pseudoclass.add(realName.replaceAll(":", "X"));
                opening.append("<");
                opening.append(enclosingSelector);
                opening.append(">");
                for (String pseudoclassName : pseudoclass) {
                    opening.append("<");
                    opening.append(selector);
                    opening.append('X');
                    opening.append(pseudoclassName);
                    opening.append(">");
                }
                ListIterator iter = pseudoclass.listIterator(pseudoclass.size());
                while (iter.hasPrevious()) {
                    String pseudoclassName;
                    pseudoclassName = (String)iter.previous();
                    closing.append("</");
                    closing.append(selector);
                    closing.append('X');
                    closing.append(pseudoclassName);
                    closing.append(">");
                }
                closing.append("</");
                closing.append(enclosingSelector);
                closing.append(">");
            } else if (CssPreviewGenerator.isPureSelector(selectorItem)) {
                opening.append("<");
                opening.append(selectorItem);
                opening.append(">");
                closing.append("</");
                closing.append(selectorItem);
                closing.append(">");
            } else {
                SelectorInfo info = CssPreviewGenerator.parseSelector(selectorItem);
                opening.append("<");
                opening.append(info.elementName);
                if (info.className != null) {
                    opening.append(" class=\"");
                    opening.append(info.className);
                    opening.append("\"");
                }
                if (info.id != null) {
                    opening.append(" id=\"");
                    opening.append(info.id);
                    opening.append("\"");
                }
                opening.append(">");
                closing.append("</");
                closing.append(info.elementName);
                closing.append(">\n");
            }
            preview.insert(previewFocus, opening);
            preview.insert(previewFocus += opening.length(), closing);
        }
        preview.insert(previewFocus, SAMPLE_TEXT);
        preview.append(HTML_POSTFIX);
        return preview;
    }

    private static boolean isPureSelector(String selectorName) {
        for (int i = 0; i < selectorName.length(); ++i) {
            char ch = selectorName.charAt(i);
            if ((Character.isLetter(ch) || Character.isDigit(ch) || ch == '*') && ch != '.') continue;
            return false;
        }
        return true;
    }

    private static SelectorInfo parseSelector(String selector) {
        SelectorInfo result = new SelectorInfo();
        int dotIndex = selector.indexOf(46);
        int hashIndex = selector.indexOf(35, dotIndex);
        if (dotIndex > 0) {
            result.elementName = selector.substring(0, dotIndex);
            if (hashIndex > 0) {
                result.className = selector.substring(dotIndex + 1, hashIndex);
                result.id = selector.substring(hashIndex + 1);
            } else {
                result.className = selector.substring(dotIndex + 1);
            }
        } else if (dotIndex == 0) {
            result.elementName = "div";
            if (hashIndex > 0) {
                result.className = selector.substring(1, hashIndex);
                result.id = selector.substring(hashIndex + 1);
            } else {
                result.className = selector.substring(1);
            }
        } else if (hashIndex > 0) {
            result.elementName = selector.substring(0, hashIndex);
            result.id = selector.substring(hashIndex + 1);
        } else if (hashIndex == 0) {
            result.elementName = "div";
            result.id = selector.substring(1);
        } else {
            result.elementName = "*".equals(selector.trim()) ? "div" : selector;
        }
        return result;
    }

    private static class SelectorInfo {
        String elementName;
        String className;
        String id;

        private SelectorInfo() {
        }
    }
}

