/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.spi;

import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hudson.spi.Bundle;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public interface ProjectHudsonJobCreatorFactory {
    public ProjectHudsonJobCreator forProject(Project var1);

    public static class Helper {
        private Helper() {
        }

        public static HudsonSCM.Configuration prepareSCM(File basedir) {
            for (HudsonSCM scm : Lookup.getDefault().lookupAll(HudsonSCM.class)) {
                HudsonSCM.Configuration cfg = scm.forFolder(basedir);
                if (cfg == null) continue;
                return cfg;
            }
            return null;
        }

        public static ConfigurationStatus noSCMError() {
            return ConfigurationStatus.withError(Bundle.ProjectHudsonJobCreatorFactory_no_vcs());
        }

        public static void addLogRotator(Document configXml) {
            Element lr = (Element)configXml.getDocumentElement().appendChild(configXml.createElement("logRotator"));
            lr.appendChild(configXml.createElement("daysToKeep")).appendChild(configXml.createTextNode("-1"));
            lr.appendChild(configXml.createElement("numToKeep")).appendChild(configXml.createTextNode("1"));
        }
    }

    public static final class ConfigurationStatus {
        private String errorMessage;
        private String warningMessage;
        private JButton extraButton;

        private ConfigurationStatus() {
        }

        public static ConfigurationStatus valid() {
            return new ConfigurationStatus();
        }

        public static ConfigurationStatus withError(String error) {
            ConfigurationStatus s = new ConfigurationStatus();
            s.errorMessage = error;
            return s;
        }

        public static ConfigurationStatus withWarning(String warning) {
            ConfigurationStatus s = new ConfigurationStatus();
            s.warningMessage = warning;
            return s;
        }

        public ConfigurationStatus withExtraButton(JButton extraButton) {
            if (this.extraButton != null) {
                throw new IllegalArgumentException();
            }
            ConfigurationStatus s = new ConfigurationStatus();
            s.errorMessage = this.errorMessage;
            s.warningMessage = this.warningMessage;
            s.extraButton = extraButton;
            return s;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getWarningMessage() {
            return this.warningMessage;
        }

        public JButton getExtraButton() {
            return this.extraButton;
        }
    }

    public static interface ProjectHudsonJobCreator {
        public String jobName();

        public JComponent customizer();

        public ConfigurationStatus status();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public Document configure() throws IOException;
    }
}

