/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.core.startup.TopLogging;
import org.netbeans.modules.autoupdate.services.DependencyAggregator;
import org.netbeans.modules.autoupdate.services.DependencyChecker;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.InstallManager;
import org.netbeans.modules.autoupdate.services.InstallSupportImpl;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleProvider;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.netbeans.spi.autoupdate.KeyStoreProvider;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.updater.ModuleDeactivator;
import org.netbeans.updater.UpdateTracking;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Utilities {
    public static final String UPDATE_DIR = "update";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
    public static final String NBM_EXTENTSION = ".nbm";
    public static final String JAR_EXTENSION = ".jar";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    public static final String ATTR_VISIBLE = "AutoUpdate-Show-In-Client";
    public static final String ATTR_ESSENTIAL = "AutoUpdate-Essential-Module";
    private static final String[] FIRST_CLASS_MODULES = new String[]{"org.netbeans.modules.autoupdate.services", "org.netbeans.modules.autoupdate.ui"};
    private static final String PLUGIN_MANAGER_FIRST_CLASS_MODULES = "plugin.manager.first.class.modules";
    private static final String USER_KS_KEY = "userKS";
    private static final String USER_KS_FILE_NAME = "user.ks";
    private static final String KS_USER_PASSWORD = "open4user";
    private static Lookup.Result<KeyStoreProvider> result;
    private static final Logger err;
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SPEC_VERSION = "specification_version";
    private static final String ATTR_SIZE = "size";
    private static final String ATTR_NBM_NAME = "nbm_name";
    private static String productVersion;

    private Utilities() {
    }

    public static Collection<KeyStore> getKeyStore() {
        Collection c;
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(KeyStoreProvider.class));
            result.addLookupListener((LookupListener)new KeyStoreProviderListener());
        }
        if ((c = result.allInstances()) == null || c.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KeyStore> kss = new ArrayList<KeyStore>();
        for (KeyStoreProvider provider : c) {
            KeyStore ks = provider.getKeyStore();
            if (ks == null) continue;
            kss.add(ks);
        }
        return kss;
    }

    private static File getInstallLater(File root) {
        File file = new File(root.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + "install_later.xml");
        return file;
    }

    public static void deleteAllDoLater() {
        List<File> clusters = UpdateTracking.clusters(true);
        assert (clusters != null) : "Clusters cannot be empty.";
        for (File cluster : clusters) {
            for (File doLater : Utilities.findDoLater(cluster)) {
                doLater.delete();
            }
        }
    }

    private static Collection<File> findDoLater(File cluster) {
        if (!cluster.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> res = new HashSet<File>();
        if (Utilities.getInstallLater(cluster).exists()) {
            res.add(Utilities.getInstallLater(cluster));
        }
        if (ModuleDeactivator.getDeactivateLater(cluster).exists()) {
            res.add(ModuleDeactivator.getDeactivateLater(cluster));
        }
        return res;
    }

    public static void writeInstallLater(Map<UpdateElementImpl, File> updates) {
        List<File> clusters = UpdateTracking.clusters(true);
        assert (clusters != null) : "Clusters cannot be empty.";
        for (File cluster : clusters) {
            Utilities.writeInstallLaterToCluster(cluster, updates);
        }
    }

    private static void writeInstallLaterToCluster(File cluster, Map<UpdateElementImpl, File> updates) {
        Document document = XMLUtil.createDocument((String)"installed_modules", null, null, null);
        Element root = document.getDocumentElement();
        if (updates.isEmpty()) {
            return;
        }
        boolean isEmpty = true;
        for (UpdateElementImpl elementImpl : updates.keySet()) {
            File c = updates.get(elementImpl);
            if (!cluster.equals(c)) continue;
            Element module = document.createElement("module");
            module.setAttribute("codename", elementImpl.getCodeName());
            module.setAttribute(ATTR_NAME, elementImpl.getDisplayName());
            module.setAttribute(ATTR_SPEC_VERSION, elementImpl.getSpecificationVersion().toString());
            module.setAttribute(ATTR_SIZE, Long.toString(elementImpl.getDownloadSize()));
            module.setAttribute(ATTR_NBM_NAME, InstallSupportImpl.getDestination(cluster, elementImpl.getCodeName(), elementImpl.getInstallInfo().getDistribution()).getName());
            root.appendChild(module);
            isEmpty = false;
        }
        if (isEmpty) {
            return;
        }
        Utilities.writeXMLDocumentToFile(document, Utilities.getInstallLater(cluster));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeXMLDocumentToFile(Document doc, File dest) {
        doc.getDocumentElement().normalize();
        dest.getParentFile().mkdirs();
        InputStream is = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream fos = null;
        try {
            try {
                XMLUtil.write((Document)doc, (OutputStream)bos, (String)"UTF-8");
                if (bos != null) {
                    bos.close();
                }
                fos = new FileOutputStream(dest);
                is = new ByteArrayInputStream(bos.toByteArray());
                FileUtil.copy((InputStream)is, (OutputStream)fos);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            Exceptions.printStackTrace((Throwable)fnfe);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
            }
        }
    }

    public static void writeDeactivateLater(Collection<File> files) {
        File userdir = InstallManager.getUserDir();
        assert (userdir != null && userdir.exists()) : "Userdir " + userdir + " found and exists.";
        Utilities.writeMarkedFilesToFile(files, ModuleDeactivator.getDeactivateLater(userdir));
    }

    public static void writeFileMarkedForDelete(Collection<File> files) {
        Utilities.writeMarkedFilesToFile(files, ModuleDeactivator.getControlFileForMarkedForDelete(InstallManager.getUserDir()));
    }

    public static void writeFileMarkedForDisable(Collection<File> files) {
        Utilities.writeMarkedFilesToFile(files, ModuleDeactivator.getControlFileForMarkedForDisable(InstallManager.getUserDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMarkedFilesToFile(Collection<File> files, File dest) {
        StringBuilder content = new StringBuilder();
        if (dest.exists()) {
            content.append(ModuleDeactivator.readStringFromFile(dest));
        }
        for (File f : files) {
            content.append(f.getAbsolutePath());
            content.append(UpdateTracking.PATH_SEPARATOR);
        }
        if (content == null || content.length() == 0) {
            return;
        }
        dest.getParentFile().mkdirs();
        assert (dest.getParentFile().exists() && dest.getParentFile().isDirectory()) : "Parent of " + dest + " exists and is directory.";
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(dest);
                is = new ByteArrayInputStream(content.toString().getBytes());
                FileUtil.copy((InputStream)is, (OutputStream)fos);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    ((OutputStream)fos).close();
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            Exceptions.printStackTrace((Throwable)fnfe);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public static void writeAdditionalInformation(Map<UpdateElementImpl, File> updates) {
        List<File> clusters = UpdateTracking.clusters(true);
        assert (clusters != null) : "Clusters cannot be empty.";
        for (File cluster : clusters) {
            Utilities.writeAdditionalInformationToCluster(cluster, updates);
        }
    }

    public static File locateUpdateTracking(ModuleInfo m) {
        String fileNameToFind = "update_tracking/" + m.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(fileNameToFind, m.getCodeNameBase(), false);
    }

    public static String readSourceFromUpdateTracking(ModuleInfo m) {
        Node n;
        String res = null;
        File ut = Utilities.locateUpdateTracking(m);
        if (ut != null && (n = Utilities.getModuleConfiguration(ut)) != null) {
            Node attrOrigin = n.getAttributes().getNamedItem("origin");
            assert (attrOrigin != null) : "ELEMENT_VERSION must contain ATTR_ORIGIN attribute.";
            if (!"updater".equals(attrOrigin.getNodeValue()) && !"installer".equals(attrOrigin.getNodeValue())) {
                res = attrOrigin.getNodeValue();
            }
        }
        return res;
    }

    public static Date readInstallTimeFromUpdateTracking(ModuleInfo m) {
        Node n;
        Date res = null;
        String time = null;
        File ut = Utilities.locateUpdateTracking(m);
        if (ut != null && (n = Utilities.getModuleConfiguration(ut)) != null) {
            Node attrInstallTime = n.getAttributes().getNamedItem("install_time");
            assert (attrInstallTime != null) : "ELEMENT_VERSION must contain ATTR_INSTALL attribute.";
            time = attrInstallTime.getNodeValue();
        }
        if (time != null) {
            try {
                long lTime = Long.parseLong(time);
                res = new Date(lTime);
            }
            catch (NumberFormatException nfe) {
                Utilities.getLogger().log(Level.INFO, nfe.getMessage(), nfe);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeUpdateOfUpdaterJar(JarEntry updaterJarEntry, JarFile updaterJar, File targetCluster) {
        String entryPath = updaterJarEntry.getName();
        String entryName = entryPath.contains("/") ? entryPath.substring(entryPath.lastIndexOf("/") + 1) : entryPath;
        File dest = new File(targetCluster, UPDATE_DIR + UpdateTracking.FILE_SEPARATOR + "new_updater" + UpdateTracking.FILE_SEPARATOR + entryName);
        dest.getParentFile().mkdirs();
        assert (dest.getParentFile().exists() && dest.getParentFile().isDirectory()) : "Parent of " + dest + " exists and is directory.";
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(dest);
                is = updaterJar.getInputStream(updaterJarEntry);
                FileUtil.copy((InputStream)is, (OutputStream)fos);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    ((OutputStream)fos).close();
                }
                updaterJar.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            Utilities.getLogger().log(Level.SEVERE, fnfe.getLocalizedMessage(), fnfe);
        }
        catch (IOException ioe) {
            Utilities.getLogger().log(Level.SEVERE, ioe.getLocalizedMessage(), ioe);
        }
    }

    static void cleanUpdateOfUpdaterJar() {
        List<File> clusters = UpdateTracking.clusters(true);
        assert (clusters != null) : "Clusters cannot be empty.";
        for (File cluster : clusters) {
            File updaterDir = new File(cluster, UPDATE_DIR + UpdateTracking.FILE_SEPARATOR + "new_updater");
            if (!updaterDir.exists() || !updaterDir.isDirectory()) continue;
            for (File f : updaterDir.listFiles()) {
                f.delete();
            }
            updaterDir.delete();
        }
    }

    static Module toModule(UpdateUnit uUnit) {
        return Utilities.getModuleInstance(uUnit.getCodeName(), null);
    }

    public static Module toModule(String codeNameBase, SpecificationVersion specificationVersion) {
        return Utilities.getModuleInstance(codeNameBase, specificationVersion);
    }

    public static Module toModule(ModuleInfo info) {
        Module m = Utilities.getModuleInstance(info.getCodeNameBase(), info.getSpecificationVersion());
        if (m == null && info instanceof Module) {
            m = (Module)info;
        }
        return m;
    }

    public static boolean isFixed(ModuleInfo info) {
        Module m = Utilities.toModule(info);
        assert (!info.isEnabled() || m != null) : "Module found for enabled " + info;
        return m == null ? false : m.isFixed();
    }

    public static boolean isValid(ModuleInfo info) {
        Module m = Utilities.toModule(info);
        assert (!info.isEnabled() || m != null) : "Module found for enabled " + info;
        return m == null ? false : m.isValid();
    }

    static UpdateUnit toUpdateUnit(Module m) {
        return UpdateManagerImpl.getInstance().getUpdateUnit(m.getCodeNameBase());
    }

    static UpdateUnit toUpdateUnit(String codeNameBase) {
        return UpdateManagerImpl.getInstance().getUpdateUnit(codeNameBase);
    }

    public static Set<UpdateElement> findRequiredUpdateElements(UpdateElement element, Collection<ModuleInfo> infos, Set<Dependency> brokenDependencies, boolean topAggressive) {
        HashSet<UpdateElement> retval = new HashSet<UpdateElement>();
        switch (element.getUpdateUnit().getType()) {
            case KIT_MODULE: 
            case MODULE: {
                Set<UpdateElement> more;
                int max_counter;
                ModuleUpdateElementImpl el = (ModuleUpdateElementImpl)Trampoline.API.impl(element);
                Set<Dependency> deps = new HashSet<Dependency>(el.getModuleInfo().getDependencies());
                HashSet<ModuleInfo> availableInfos = new HashSet<ModuleInfo>(infos);
                int counter = max_counter = el.getType().equals((Object)UpdateManager.TYPE.KIT_MODULE) ? 2 : 1;
                boolean aggressive = topAggressive && counter > 0;
                HashSet<Dependency> all = new HashSet<Dependency>();
                while (true) {
                    Set<Dependency> newones = Utilities.processDependencies(deps, retval, availableInfos, brokenDependencies, element, aggressive);
                    newones.removeAll(all);
                    if (newones.isEmpty()) break;
                    all.addAll(newones);
                    deps = newones;
                }
                HashSet<Dependency> moreBroken = new HashSet<Dependency>();
                HashSet<Object> tmp = new HashSet<ModuleInfo>(availableInfos);
                counter = max_counter;
                boolean bl = aggressive = topAggressive && counter > 0;
                while (retval.addAll(more = Utilities.handleBackwardCompatability(tmp, moreBroken, aggressive))) {
                    if (!moreBroken.isEmpty()) {
                        brokenDependencies.addAll(moreBroken);
                        break;
                    }
                    tmp = new HashSet();
                    for (UpdateElement e : more) {
                        tmp.add(((ModuleUpdateElementImpl)Trampoline.API.impl(e)).getModuleInfo());
                    }
                    aggressive = aggressive && counter-- > 0;
                }
                if (moreBroken.isEmpty()) break;
                brokenDependencies.addAll(moreBroken);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl feature = (FeatureUpdateElementImpl)Trampoline.API.impl(element);
                boolean aggressive = topAggressive;
                for (ModuleUpdateElementImpl module : feature.getContainedModuleElements()) {
                    retval.addAll(Utilities.findRequiredUpdateElements(module.getUpdateElement(), infos, brokenDependencies, aggressive));
                }
                break;
            }
            case CUSTOM_HANDLED_COMPONENT: {
                Utilities.getLogger().log(Level.INFO, "CUSTOM_HANDLED_COMPONENT doesn't care about required elements.");
                break;
            }
            default: {
                assert (false) : "Not implement for type " + element.getUpdateUnit() + " of UpdateElement " + element;
                break;
            }
        }
        return retval;
    }

    public static Set<UpdateElement> handleBackwardCompatability(Set<ModuleInfo> forInstall, Set<Dependency> brokenDependencies, boolean aggressive) {
        HashSet<UpdateElement> moreRequested = new HashSet<UpdateElement>();
        for (ModuleInfo mi : forInstall) {
            UpdateElement i;
            UpdateUnit u = UpdateManagerImpl.getInstance().getUpdateUnit(mi.getCodeNameBase());
            if (u == null || (i = u.getInstalled()) == null) continue;
            HashSet dependencies = new HashSet();
            dependencies.addAll(Dependency.create((int)1, (String)mi.getCodeName()));
            TreeSet<String> newTokens = new TreeSet<String>(Arrays.asList(mi.getProvides()));
            TreeSet<String> oldTokens = new TreeSet<String>(Arrays.asList(((ModuleUpdateElementImpl)Trampoline.API.impl(i)).getModuleInfo().getProvides()));
            oldTokens.removeAll(newTokens);
            for (String tok : oldTokens) {
                if (tok.startsWith("org.openide.modules.os")) continue;
                dependencies.addAll(Dependency.create((int)5, (String)tok));
                dependencies.addAll(Dependency.create((int)6, (String)tok));
            }
            for (Dependency d : dependencies) {
                DependencyAggregator deco = DependencyAggregator.getAggregator(d);
                int type = d.getType();
                String name = d.getName();
                for (ModuleInfo depMI : deco.getDependening()) {
                    Module depM = Utilities.getModuleInstance(depMI.getCodeName(), depMI.getSpecificationVersion());
                    if (depM == null || !depM.getProblems().isEmpty()) continue;
                    for (Dependency toTry : depM.getDependencies()) {
                        Set<Dependency> newones;
                        UpdateUnit tryUU;
                        if (type != toTry.getType() || !name.equals(toTry.getName()) || DependencyChecker.checkDependencyModule(toTry, mi) || (tryUU = UpdateManagerImpl.getInstance().getUpdateUnit(depM.getCodeNameBase())).getAvailableUpdates().isEmpty()) continue;
                        UpdateElement tryUE = tryUU.getAvailableUpdates().get(0);
                        ModuleInfo tryUpdated = ((ModuleUpdateElementImpl)Trampoline.API.impl(tryUE)).getModuleInfo();
                        Set<Dependency> deps = new HashSet<Dependency>(tryUpdated.getDependencies());
                        HashSet<ModuleInfo> availableInfos = new HashSet<ModuleInfo>(forInstall);
                        while (!(newones = Utilities.processDependencies(deps, moreRequested, availableInfos, brokenDependencies, tryUE, aggressive)).isEmpty()) {
                            deps = newones;
                        }
                        moreRequested.add(tryUE);
                    }
                }
            }
        }
        return moreRequested;
    }

    private static Set<Dependency> processDependencies(Set<Dependency> original, Set<UpdateElement> retval, Set<ModuleInfo> availableInfos, Set<Dependency> brokenDependencies, UpdateElement el, boolean agressive) {
        HashSet<Dependency> res = new HashSet<Dependency>();
        for (Dependency dep : original) {
            UpdateElement req = Utilities.handleDependency(el, dep, availableInfos, brokenDependencies, agressive);
            if (req == null) continue;
            ModuleUpdateElementImpl reqM = (ModuleUpdateElementImpl)Trampoline.API.impl(req);
            availableInfos.add(reqM.getModuleInfo());
            retval.add(req);
            res.addAll(reqM.getModuleInfo().getDependencies());
        }
        res.removeAll(original);
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public static UpdateElement handleDependency(UpdateElement el, Dependency dep, Collection<ModuleInfo> availableInfos, Set<Dependency> brokenDependencies, boolean beAggressive) {
        requested = null;
        switch (dep.getType()) {
            case 3: {
                if (DependencyChecker.matchDependencyJava(dep)) break;
                brokenDependencies.add(dep);
                break;
            }
            case 2: {
                if (DependencyChecker.matchPackageDependency(dep)) break;
                brokenDependencies.add(dep);
                break;
            }
            case 1: {
                u = DependencyAggregator.getRequested(dep);
                matched = false;
                if (u == null) ** GOTO lbl34
                aggressive = beAggressive;
                if (aggressive && (Utilities.isFirstClassModule(el.getUpdateUnit()) || u.getType() == UpdateManager.TYPE.KIT_MODULE)) {
                    aggressive = false;
                }
                if (u.getInstalled() != null) {
                    reqElImpl = Trampoline.API.impl(u.getInstalled());
                    matched = DependencyChecker.checkDependencyModule(dep, ((ModuleUpdateElementImpl)reqElImpl).getModuleInfo());
                }
                if (!matched) {
                    for (ModuleInfo m : availableInfos) {
                        if (!DependencyChecker.checkDependencyModule(dep, m)) continue;
                        matched = true;
                        break;
                    }
                }
                if (!aggressive && matched) ** GOTO lbl38
                v0 = reqEl = u.getAvailableUpdates().isEmpty() != false ? null : u.getAvailableUpdates().get(0);
                if (reqEl != null && DependencyChecker.checkDependencyModule(dep, info = (reqModuleImpl = (ModuleUpdateElementImpl)(reqElImpl = Trampoline.API.impl(reqEl))).getModuleInfo()) && !availableInfos.contains(info)) {
                    requested = reqEl;
                    matched = true;
                }
                ** GOTO lbl38
lbl34:
                // 2 sources

                for (ModuleInfo m : availableInfos) {
                    if (!DependencyChecker.checkDependencyModule(dep, m)) continue;
                    matched = true;
                    break;
                }
lbl38:
                // 4 sources

                if (matched) break;
                brokenDependencies.add(dep);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if ("org.openide.modules.ModuleFormat1".equals(dep.getName()) || "org.openide.modules.ModuleFormat2".equals(dep.getName())) break;
                p = DependencyAggregator.getRequested(dep);
                passed = false;
                if (p != null) ** GOTO lbl52
                for (ModuleInfo m : availableInfos) {
                    if (!Arrays.asList(m.getProvides()).contains(dep.getName())) continue;
                    passed = true;
                    ** GOTO lbl55
                }
                ** GOTO lbl55
lbl52:
                // 1 sources

                passed = true;
                if (!p.getAvailableUpdates().isEmpty()) {
                    requested = p.getAvailableUpdates().get(0);
                }
lbl55:
                // 5 sources

                if (passed || 7 == dep.getType()) break;
                brokenDependencies.add(dep);
            }
        }
        return requested;
    }

    static Set<String> getBrokenDependencies(UpdateElement element, List<ModuleInfo> infos) {
        assert (element != null) : "UpdateElement cannot be null";
        HashSet<Dependency> brokenDependencies = new HashSet<Dependency>();
        Utilities.findRequiredUpdateElements(element, infos, brokenDependencies, false);
        for (ModuleInfo mi : infos) {
            UpdateElement ue;
            ModuleInfo newerMI;
            UpdateElement i;
            UpdateUnit u = UpdateManagerImpl.getInstance().getUpdateUnit(mi.getCodeNameBase());
            if (u == null || (i = u.getInstalled()) == null || !u.getAvailableUpdates().isEmpty() && infos.contains(newerMI = ((ModuleUpdateElementImpl)Trampoline.API.impl(ue = u.getAvailableUpdates().get(0))).getModuleInfo())) continue;
            for (Dependency d : Dependency.create((int)1, (String)mi.getCodeName())) {
                DependencyAggregator deco = DependencyAggregator.getAggregator(d);
                for (ModuleInfo depMI : deco.getDependening()) {
                    Module depM = Utilities.getModuleInstance(depMI.getCodeName(), depMI.getSpecificationVersion());
                    if (depM == null || !depM.getProblems().isEmpty()) continue;
                    for (Dependency toTry : depM.getDependencies()) {
                        if (!deco.equals(DependencyAggregator.getAggregator(toTry)) || DependencyChecker.checkDependencyModule(toTry, mi)) continue;
                        brokenDependencies.add(toTry);
                    }
                }
            }
            TreeSet<String> newTokens = new TreeSet<String>(Arrays.asList(mi.getProvides()));
            TreeSet<String> oldTokens = new TreeSet<String>(Arrays.asList(((ModuleUpdateElementImpl)Trampoline.API.impl(i)).getModuleInfo().getProvides()));
            oldTokens.removeAll(newTokens);
            for (String tok : oldTokens) {
                HashSet deps = new HashSet(Dependency.create((int)5, (String)tok));
                deps.addAll(Dependency.create((int)6, (String)tok));
                for (Dependency d : deps) {
                    DependencyAggregator deco = DependencyAggregator.getAggregator(d);
                    for (ModuleInfo depMI : deco.getDependening()) {
                        Module depM = Utilities.getModuleInstance(depMI.getCodeName(), depMI.getSpecificationVersion());
                        if (depM == null || !depM.getProblems().isEmpty()) continue;
                        for (Dependency toTry : depM.getDependencies()) {
                            if (!deco.equals(DependencyAggregator.getAggregator(toTry))) continue;
                            brokenDependencies.add(toTry);
                        }
                    }
                }
            }
        }
        HashSet<String> retval = new HashSet<String>(brokenDependencies.size());
        for (Dependency dep : brokenDependencies) {
            retval.add(dep.toString());
        }
        return retval;
    }

    static Set<String> getBrokenDependenciesInInstalledModules(UpdateElement element) {
        assert (element != null) : "UpdateElement cannot be null";
        HashSet<Dependency> deps = new HashSet<Dependency>();
        for (ModuleInfo m : Utilities.getModuleInfos(Collections.singleton(element))) {
            deps.addAll(DependencyChecker.findBrokenDependenciesTransitive(m, InstalledModuleProvider.getInstalledModules().values(), new HashSet<ModuleInfo>()));
        }
        HashSet<String> retval = new HashSet<String>();
        for (Dependency dep : deps) {
            retval.add(dep.toString());
        }
        return retval;
    }

    private static List<ModuleInfo> getModuleInfos(Collection<UpdateElement> elements) {
        ArrayList<ModuleInfo> infos = new ArrayList<ModuleInfo>(elements.size());
        for (UpdateElement el : elements) {
            if (el.getUpdateUnit() != null && el.getUpdateUnit().isPending()) continue;
            UpdateElementImpl impl = Trampoline.API.impl(el);
            infos.addAll(impl.getModuleInfos());
        }
        return infos;
    }

    private static Module getModuleInstance(String codeNameBase, SpecificationVersion specificationVersion) {
        for (ModuleInfo mi : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            if (!codeNameBase.equals(mi.getCodeNameBase()) || !(mi instanceof Module)) continue;
            Module m = (Module)mi;
            if (specificationVersion == null || m == null) {
                err.log(Level.FINE, "no module {0} for {1}", new Object[]{m, specificationVersion});
                return m;
            }
            SpecificationVersion version = m.getSpecificationVersion();
            if (version == null) {
                err.log(Level.FINER, "No version for {0}", m);
                return null;
            }
            int res = version.compareTo((Object)specificationVersion);
            err.log(Level.FINE, "Comparing versions: {0}.compareTo({1}) = {2}", new Object[]{version, specificationVersion, res});
            return res >= 0 ? m : null;
        }
        return null;
    }

    public static boolean isAutomaticallyEnabled(String codeNameBase) {
        Module m = Utilities.getModuleInstance(codeNameBase, null);
        return m != null ? m.isAutoload() || m.isEager() || m.isFixed() : false;
    }

    public static ModuleInfo takeModuleInfo(UpdateElement el) {
        UpdateElementImpl impl = Trampoline.API.impl(el);
        assert (impl instanceof ModuleUpdateElementImpl);
        return ((ModuleUpdateElementImpl)impl).getModuleInfo();
    }

    public static String getProductVersion() {
        if (productVersion == null) {
            String buildNumber = System.getProperty("netbeans.buildnumber");
            productVersion = NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)buildNumber);
        }
        return productVersion;
    }

    private static Node getModuleConfiguration(File moduleUpdateTracking) {
        Document document = null;
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(moduleUpdateTracking));
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse((InputSource)xmlInputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (SAXException saxe) {
            Utilities.getLogger().log(Level.INFO, "SAXException when reading " + moduleUpdateTracking, saxe);
            return null;
        }
        catch (IOException ioe) {
            Utilities.getLogger().log(Level.INFO, "IOException when reading " + moduleUpdateTracking, ioe);
            return null;
        }
        assert (document.getDocumentElement() != null) : "File " + moduleUpdateTracking + " must contain <module> element.";
        if (document.getDocumentElement() == null) {
            return null;
        }
        return Utilities.getModuleElement(document.getDocumentElement());
    }

    private static Node getModuleElement(Element element) {
        Node lastElement = null;
        assert ("module".equals(element.getTagName())) : "The root element is: module but was: " + element.getTagName();
        NodeList listModuleVersions = element.getElementsByTagName("module_version");
        for (int i = 0; i < listModuleVersions.getLength() && (lastElement = Utilities.getModuleLastVersion(listModuleVersions.item(i))) == null; ++i) {
        }
        return lastElement;
    }

    private static Node getModuleLastVersion(Node version) {
        Node attrLast = version.getAttributes().getNamedItem("last");
        assert (attrLast != null) : "ELEMENT_VERSION must contain ATTR_LAST attribute.";
        if (Boolean.valueOf(attrLast.getNodeValue()).booleanValue()) {
            return version;
        }
        return null;
    }

    private static File getAdditionalInformation(File root) {
        File file = new File(root.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + "additional_information.xml");
        return file;
    }

    private static void writeAdditionalInformationToCluster(File cluster, Map<UpdateElementImpl, File> updates) {
        if (updates.isEmpty()) {
            return;
        }
        Document document = XMLUtil.createDocument((String)"module_additional", null, null, null);
        Element root = document.getDocumentElement();
        boolean isEmpty = true;
        for (UpdateElementImpl impl : updates.keySet()) {
            File c = updates.get(impl);
            if (!cluster.equals(c)) continue;
            Element module = document.createElement("module");
            module.setAttribute(ATTR_NBM_NAME, InstallSupportImpl.getDestination(cluster, impl.getCodeName(), impl.getInstallInfo().getDistribution()).getName());
            module.setAttribute("source-display-name", impl.getSource());
            root.appendChild(module);
            isEmpty = false;
        }
        if (isEmpty) {
            return;
        }
        Utilities.writeXMLDocumentToFile(document, Utilities.getAdditionalInformation(cluster));
    }

    public static UpdateItem createUpdateItem(UpdateItemImpl impl) {
        assert (Trampoline.SPI != null);
        return Trampoline.SPI.createUpdateItem(impl);
    }

    public static UpdateItemImpl getUpdateItemImpl(UpdateItem item) {
        assert (Trampoline.SPI != null);
        return Trampoline.SPI.impl(item);
    }

    public static boolean canDisable(Module m) {
        return m != null && m.isEnabled() && !Utilities.isEssentialModule((ModuleInfo)m) && !m.isAutoload() && !m.isEager();
    }

    public static boolean canEnable(Module m) {
        return m != null && !m.isEnabled() && !m.isAutoload() && !m.isEager();
    }

    public static boolean isElementInstalled(UpdateElement el) {
        assert (el != null) : "Invalid call isElementInstalled with null parameter.";
        if (el == null) {
            return false;
        }
        return el.equals(el.getUpdateUnit().getInstalled());
    }

    public static boolean isKitModule(ModuleInfo mi) {
        Object o = mi.getAttribute(ATTR_VISIBLE);
        return o == null || Boolean.parseBoolean(o.toString());
    }

    public static boolean isEssentialModule(ModuleInfo mi) {
        Object o = mi.getAttribute(ATTR_ESSENTIAL);
        return Utilities.isFixed(mi) || o != null && Boolean.parseBoolean(o.toString());
    }

    public static boolean isFirstClassModule(UpdateUnit u) {
        String codeName = u.getCodeName();
        String names = System.getProperty(PLUGIN_MANAGER_FIRST_CLASS_MODULES);
        if (names == null || names.length() == 0) {
            for (String m : FIRST_CLASS_MODULES) {
                if (!m.equals(codeName)) continue;
                return true;
            }
        } else {
            StringTokenizer en = new StringTokenizer(names, ",");
            while (en.hasMoreTokens()) {
                if (!en.nextToken().trim().equals(codeName)) continue;
                return true;
            }
        }
        return false;
    }

    private static Logger getLogger() {
        return err;
    }

    public static Set<Module> findRequiredModules(Module m, ModuleManager mm, Map<Module, Set<Module>> m2reqs) {
        Set res = null;
        if (m2reqs != null) {
            res = m2reqs.get(m);
            if (res == null) {
                res = mm.getModuleInterdependencies(m, false, false);
                m2reqs.put(m, res);
            }
        } else {
            res = mm.getModuleInterdependencies(m, false, false);
        }
        return res;
    }

    public static Set<Module> findDependingModules(Module m, ModuleManager mm, Map<Module, Set<Module>> m2deps) {
        Set res = null;
        if (m2deps != null) {
            res = m2deps.get(m);
            if (res == null) {
                res = mm.getModuleInterdependencies(m, true, false);
                m2deps.put(m, res);
            }
        } else {
            res = mm.getModuleInterdependencies(m, true, false);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String date) throws ParseException {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.parse(date);
        }
    }

    public static boolean canWriteInCluster(File cluster) {
        assert (cluster != null) : "dir cannot be null";
        if (cluster == null) {
            return false;
        }
        if (cluster.exists() && cluster.isDirectory()) {
            File dir4test = null;
            File update = new File(cluster, UPDATE_DIR);
            File download = new File(cluster, DOWNLOAD_DIR);
            dir4test = download.exists() ? download : (update.exists() ? update : cluster);
            if (dir4test.canWrite() && dir4test.canRead()) {
                boolean canWrite = Utilities.canWrite(dir4test);
                Utilities.getLogger().log(Level.FINE, "Can write into {0}? {1}", new Object[]{dir4test, canWrite});
                return canWrite;
            }
            Utilities.getLogger().log(Level.FINE, "Can write into {0}? {1}", new Object[]{dir4test, dir4test.canWrite()});
            return dir4test.canWrite();
        }
        cluster.mkdirs();
        Utilities.getLogger().log(Level.FINE, "Can write into new cluster {0}? {1}", new Object[]{cluster, cluster.canWrite()});
        return cluster.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File f) {
        if (org.openide.util.Utilities.isWindows()) {
            if (f.isFile()) {
                FileWriter fw = null;
                try {
                    fw = new FileWriter(f, true);
                    Utilities.getLogger().log(Level.FINE, "{0} has write permission", f);
                }
                catch (IOException ioe) {
                    Utilities.getLogger().log(Level.FINE, f + " has no write permission", ioe);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                    }
                    catch (IOException ex) {
                        Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                }
                return true;
            }
            try {
                File dummy = File.createTempFile("dummy", null, f);
                dummy.delete();
                Utilities.getLogger().log(Level.FINE, "{0} has write permission", f);
            }
            catch (IOException ioe) {
                Utilities.getLogger().log(Level.FINE, f + " has no write permission", ioe);
                return false;
            }
            return true;
        }
        return f.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore() {
        String fileName = Utilities.getPreferences().get(USER_KS_KEY, null);
        if (fileName == null) {
            return null;
        }
        InputStream is = null;
        KeyStore ks = null;
        try {
            File f = new File(Utilities.getCacheDirectory(), fileName);
            if (!f.exists()) {
                KeyStore keyStore = null;
                return keyStore;
            }
            is = new BufferedInputStream(new FileInputStream(f));
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(is, KS_USER_PASSWORD.toCharArray());
        }
        catch (IOException ex) {
            Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        catch (CertificateException ex) {
            Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        catch (KeyStoreException ex) {
            Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeKeyStore(KeyStore ks) {
        OutputStream os = null;
        try {
            File f = new File(Utilities.getCacheDirectory(), USER_KS_FILE_NAME);
            os = new BufferedOutputStream(new FileOutputStream(f));
            ks.store(os, KS_USER_PASSWORD.toCharArray());
            Utilities.getPreferences().put(USER_KS_KEY, USER_KS_FILE_NAME);
        }
        catch (KeyStoreException ex) {
            Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        catch (IOException ex) {
            Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        catch (CertificateException ex) {
            Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex) {
                Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
    }

    public static void addCertificates(Collection<Certificate> certs) {
        KeyStore ks = Utilities.loadKeyStore();
        if (ks == null) {
            try {
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, KS_USER_PASSWORD.toCharArray());
            }
            catch (IOException ex) {
                Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
                return;
            }
            catch (NoSuchAlgorithmException ex) {
                Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
                return;
            }
            catch (CertificateException ex) {
                Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
                return;
            }
            catch (KeyStoreException ex) {
                Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
                return;
            }
        }
        for (Certificate c : certs) {
            try {
                if (ks.getCertificateAlias(c) != null) continue;
                String alias = null;
                for (int i = 0; i < 9999 && ks.containsAlias(alias = "genAlias" + i); ++i) {
                }
                if (alias == null) {
                    Utilities.getLogger().log(Level.INFO, "Too many certificates with {0}", c);
                }
                ks.setCertificateEntry(alias, c);
            }
            catch (KeyStoreException ex) {
                Utilities.getLogger().log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
        Utilities.storeKeyStore(ks);
    }

    private static File getCacheDirectory() {
        File cacheDir = null;
        String userDir = System.getProperty("netbeans.user");
        if (userDir != null) {
            cacheDir = new File(new File(new File(userDir, "var"), "cache"), "catalogcache");
        } else {
            File dir = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            cacheDir = new File(dir, "catalogcache");
        }
        cacheDir.mkdirs();
        return cacheDir;
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    static {
        err = Logger.getLogger(Utilities.class.getName());
        productVersion = null;
    }

    private static class KeyStoreProviderListener
    implements LookupListener {
        private KeyStoreProviderListener() {
        }

        public void resultChanged(LookupEvent ev) {
            result = null;
        }
    }
}

