/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.netbeans.modules.websvc.rest.codegen.model.Method;
import org.netbeans.modules.websvc.rest.codegen.model.Resource;
import org.netbeans.modules.websvc.rest.codegen.model.ResourceModel;
import org.netbeans.modules.websvc.rest.codegen.model.RestEntity;
import org.netbeans.modules.websvc.rest.codegen.model.State;
import org.netbeans.modules.websvc.rest.support.AbstractTask;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.wizard.ClientStubsSetupPanelVisual;
import org.openide.util.NbBundle;

public class SourceModeler
extends ResourceModel {
    private static final Logger LOG = Logger.getLogger(SourceModeler.class.getCanonicalName());
    private Project project;
    private Set<String> resourceFqns;

    public SourceModeler(Project project) {
        this.project = project;
    }

    @Override
    public State validate() {
        return State.VALID;
    }

    @Override
    public void build() throws IOException {
        State state = this.validate();
        if (state != State.VALID) {
            throw new IOException(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"MSG_ProjectsWithoutREST") + ", " + state.value());
        }
        List<JavaSource> list = JavaSourceHelper.getJavaSources(this.project);
        for (JavaSource javaSource : list) {
            Resource resource;
            String string;
            if (JavaSourceHelper.isEntity(javaSource) || (string = JavaSourceHelper.getClassNameQuietly(javaSource)) == null || !RestUtils.isStaticResource(javaSource) || (resource = this.createResource(javaSource)) == null) continue;
            this.addResource(resource);
        }
    }

    private Resource createResource(JavaSource javaSource) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = RestUtils.findUri(javaSource);
        this.resourceFqns = new HashSet<String>();
        if (string3 != null) {
            string2 = string3;
            string = string2;
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            string = string.substring(0, 1).toUpperCase() + string.substring(1);
            Resource resource = new Resource(ClientStubModel.normalizeName(string), string2);
            this.buildResource(resource, javaSource);
            return resource;
        }
        return null;
    }

    private void buildResource(final Resource resource, JavaSource javaSource) throws IOException {
        resource.setSource(javaSource);
        try {
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = JavaSourceHelper.getTopLevelClassElement(compilationController);
                    Collection collection = SourceModeler.this.doBuildResource(resource, typeElement, compilationController, SourceModeler.this.getBoxedPrimitives(compilationController));
                    for (Method method : collection) {
                        resource.addMethod(method);
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
    }

    private Collection<TypeMirror> getBoxedPrimitives(CompilationController compilationController) {
        TypeKind[] typeKindArray = TypeKind.values();
        ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(typeKindArray.length);
        for (TypeKind typeKind : typeKindArray) {
            if (!typeKind.isPrimitive()) continue;
            PrimitiveType primitiveType = compilationController.getTypes().getPrimitiveType(typeKind);
            TypeElement typeElement = compilationController.getTypes().boxedClass(primitiveType);
            arrayList.add(typeElement.asType());
        }
        return arrayList;
    }

    private Collection<Method> doBuildResource(Resource resource, TypeElement typeElement, CompilationController compilationController, Collection<TypeMirror> collection) {
        String string = typeElement.getQualifiedName().toString();
        if (this.resourceFqns.contains(string)) {
            return Collections.emptyList();
        }
        this.resourceFqns.add(string);
        LinkedList<Method> linkedList = new LinkedList<Method>();
        List<ExecutableElement> list = ElementFilter.methodsIn(compilationController.getElements().getAllMembers(typeElement));
        for (ExecutableElement executableElement : list) {
            List<? extends AnnotationMirror> list2 = compilationController.getElements().getAllAnnotationMirrors(executableElement);
            HashMap<String, AnnotationMirror> hashMap = new HashMap<String, AnnotationMirror>();
            for (AnnotationMirror annotationMirror : list2) {
                TypeElement typeElement2;
                String string2;
                DeclaredType declaredType = annotationMirror.getAnnotationType();
                Element element = declaredType.asElement();
                if (!(element instanceof TypeElement) || !this.isRestAnnotation(string2 = (typeElement2 = (TypeElement)element).getQualifiedName().toString())) continue;
                hashMap.put(string2, annotationMirror);
            }
            Collection<Method> collection2 = this.createRestMethods(resource, hashMap, typeElement, executableElement, compilationController, collection);
            linkedList.addAll(collection2);
        }
        return linkedList;
    }

    private Collection<Method> createRestMethods(Resource resource, Map<String, AnnotationMirror> map, TypeElement typeElement, ExecutableElement executableElement, CompilationController compilationController, Collection<TypeMirror> collection) {
        AnnotationMirror annotationMirror = map.get("javax.ws.rs.Path");
        AnnotationMirror annotationMirror2 = map.get("javax.ws.rs.Produces");
        AnnotationMirror annotationMirror3 = map.get("javax.ws.rs.Consumes");
        AnnotationMirror annotationMirror4 = map.get("javax.ws.rs.GET");
        AnnotationMirror annotationMirror5 = map.get("javax.ws.rs.POST");
        AnnotationMirror annotationMirror6 = map.get("javax.ws.rs.PUT");
        AnnotationMirror annotationMirror7 = map.get("javax.ws.rs.DELETE");
        AnnotationMirror annotationMirror8 = this.chooseNotNull(annotationMirror4, annotationMirror5, annotationMirror6, annotationMirror7);
        TypeMirror typeMirror = compilationController.getTypes().asMemberOf((DeclaredType)typeElement.asType(), executableElement);
        TypeMirror typeMirror2 = ((ExecutableType)typeMirror).getReturnType();
        if (annotationMirror != null) {
            Object object;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map2 = annotationMirror.getElementValues();
            String string = null;
            Iterator<? extends AnnotationValue> iterator = map2.values().iterator();
            if (iterator.hasNext() && (object = iterator.next().getValue()) != null) {
                string = object.toString();
            }
            if (string == null) {
                return Collections.emptyList();
            }
            if (annotationMirror8 != null) {
                object = this.createMethod(executableElement.getSimpleName().toString(), typeElement, compilationController);
                StringBuilder stringBuilder = new StringBuilder();
                if (resource.getName() == null) {
                    stringBuilder.append(resource.getPath());
                    if (!resource.getPath().endsWith("/")) {
                        stringBuilder.append('/');
                    }
                }
                stringBuilder.append(string);
                this.configureMethod((Method)object, annotationMirror2, annotationMirror3, annotationMirror8, stringBuilder.toString(), executableElement, (ExecutableType)typeMirror, compilationController, collection);
                return Collections.singletonList(object);
            }
            object = compilationController.getTypes().asElement(typeMirror2);
            if (object instanceof TypeElement) {
                String string2 = resource.getPath();
                if (resource.getName() != null) {
                    string2 = "";
                }
                StringBuilder stringBuilder = new StringBuilder(string2);
                if (!resource.getPath().endsWith("/")) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(string);
                Resource resource2 = new Resource(null, stringBuilder.toString());
                return this.doBuildResource(resource2, (TypeElement)object, compilationController, collection);
            }
            return Collections.emptyList();
        }
        if (annotationMirror8 != null) {
            Method method = this.createMethod(executableElement.getSimpleName().toString(), typeElement, compilationController);
            String string = resource.getPath();
            if (resource.getName() != null) {
                string = null;
            }
            this.configureMethod(method, annotationMirror2, annotationMirror3, annotationMirror8, string, executableElement, (ExecutableType)typeMirror, compilationController, collection);
            return Collections.singletonList(method);
        }
        return Collections.emptyList();
    }

    private void configureMethod(Method method, AnnotationMirror annotationMirror, AnnotationMirror annotationMirror2, AnnotationMirror annotationMirror3, String string, ExecutableElement executableElement, ExecutableType executableType, CompilationController compilationController, Collection<TypeMirror> collection) {
        List<String> list;
        String string2 = ((TypeElement)annotationMirror3.getAnnotationType().asElement()).getQualifiedName().toString();
        if ("javax.ws.rs.GET".equals(string2)) {
            list = this.getAnnotationMimes(annotationMirror);
            if (list != null) {
                method.setResponseMimes(list);
            }
        } else {
            list = this.getAnnotationMimes(annotationMirror);
            if (list != null) {
                method.setResponseMimes(list);
            }
            if ((list = this.getAnnotationMimes(annotationMirror2)) != null) {
                method.setRequestMimes(list);
            }
        }
        method.setPath(string);
        list = executableType.getReturnType();
        RestEntity restEntity = this.getRestEntity(compilationController, collection, (TypeMirror)((Object)list));
        method.setReturnType(restEntity);
        RestEntity restEntity2 = this.getParamEntity(compilationController, collection, executableElement, executableType);
        method.setParamType(restEntity2);
        for (Constants.HttpMethodType httpMethodType : Constants.HttpMethodType.values()) {
            String string3 = httpMethodType.getAnnotationType();
            if (!string3.equals(string2)) continue;
            method.setType(httpMethodType);
            break;
        }
    }

    private RestEntity getParamEntity(CompilationController compilationController, Collection<TypeMirror> collection, ExecutableElement executableElement, ExecutableType executableType) {
        List<? extends VariableElement> list = executableElement.getParameters();
        int n = -1;
        int n2 = 0;
        for (VariableElement annotatedConstruct2 : list) {
            List<? extends AnnotationMirror> list2 = annotatedConstruct2.getAnnotationMirrors();
            boolean bl = false;
            for (AnnotationMirror annotationMirror : list2) {
                String string;
                DeclaredType declaredType = annotationMirror.getAnnotationType();
                Element element = declaredType.asElement();
                if (!(element instanceof TypeElement) || !(string = ((TypeElement)element).getQualifiedName().toString()).equals("javax.ws.rs.QueryParam") && !string.equals("javax.ws.rs.PathParam")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return new RestEntity(true);
        }
        List<? extends TypeMirror> list3 = executableType.getParameterTypes();
        TypeMirror typeMirror = (TypeMirror)list3.get(n);
        return this.getRestEntity(compilationController, collection, typeMirror);
    }

    private RestEntity getRestEntity(CompilationController compilationController, Collection<TypeMirror> collection, TypeMirror typeMirror) {
        Object object;
        if (typeMirror.getKind() == TypeKind.VOID) {
            return new RestEntity(true);
        }
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        if (compilationController.getTypes().isSubtype(compilationController.getTypes().erasure(typeMirror), compilationController.getTypes().erasure(compilationController.getElements().getTypeElement(Collection.class.getCanonicalName()).asType()))) {
            bl = true;
            object = ((DeclaredType)typeMirror).getTypeArguments();
            if (object.size() != 0) {
                TypeMirror typeMirror2 = object.get(0);
                string = this.getQualifiedName(compilationController, typeMirror2);
            }
        } else if (typeMirror.getKind() == TypeKind.ARRAY) {
            bl = true;
            object = ((ArrayType)typeMirror).getComponentType();
            string = this.getQualifiedName(compilationController, (TypeMirror)object);
        }
        if (typeMirror.getKind().isPrimitive() || compilationController.getTypes().isSameType(typeMirror, compilationController.getElements().getTypeElement(String.class.getCanonicalName()).asType())) {
            bl2 = true;
        } else {
            for (TypeMirror typeMirror2 : collection) {
                if (!compilationController.getTypes().isSameType(typeMirror, typeMirror2)) continue;
                bl2 = true;
                break;
            }
        }
        if (!bl && !bl2) {
            string = this.getQualifiedName(compilationController, typeMirror);
        }
        if (string == null) {
            string = Object.class.getCanonicalName();
        }
        if (bl2) {
            return new RestEntity(false);
        }
        return new RestEntity(string, bl);
    }

    private String getQualifiedName(CompilationController compilationController, TypeMirror typeMirror) {
        Element element;
        String string = null;
        if (typeMirror instanceof DeclaredType && (element = compilationController.getTypes().asElement(typeMirror)) instanceof TypeElement) {
            string = ((TypeElement)element).getQualifiedName().toString();
        }
        return string;
    }

    private <T> T chooseNotNull(T ... TArray) {
        for (T t : TArray) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    private boolean isRestAnnotation(String string) {
        return string.equals("javax.ws.rs.Path") || string.equals("javax.ws.rs.Produces") || string.equals("javax.ws.rs.Consumes") || string.equals("javax.ws.rs.GET") || string.equals("javax.ws.rs.POST") || string.equals("javax.ws.rs.PUT") || string.equals("javax.ws.rs.DELETE");
    }

    private List<String> getAnnotationMimes(AnnotationMirror annotationMirror) {
        if (annotationMirror == null) {
            return null;
        }
        String string = RestUtils.getValueFromAnnotation(annotationMirror);
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            if ((string2 = string2.trim()).startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    private Method createMethod(String string, TypeElement typeElement, CompilationController compilationController) {
        Method method = new Method(string);
        List<? extends AnnotationMirror> list = compilationController.getElements().getAllAnnotationMirrors(typeElement);
        for (AnnotationMirror annotationMirror : list) {
            List<String> list2;
            Element element = annotationMirror.getAnnotationType().asElement();
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement2 = (TypeElement)element;
            String string2 = typeElement2.getQualifiedName().toString();
            if ("javax.ws.rs.Produces".equals(string2)) {
                list2 = this.getAnnotationMimes(annotationMirror);
                method.setResponseMimes(list2);
                continue;
            }
            if (!"javax.ws.rs.Consumes".equals(string2)) continue;
            list2 = this.getAnnotationMimes(annotationMirror);
            method.setRequestMimes(list2);
        }
        return method;
    }
}

