/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.AbstractGenerator;
import org.netbeans.modules.websvc.rest.codegen.ResourceJavaScript;
import org.netbeans.modules.websvc.rest.codegen.TokenReplacer;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.netbeans.modules.websvc.rest.codegen.model.Resource;
import org.netbeans.modules.websvc.rest.codegen.model.ResourceModel;
import org.netbeans.modules.websvc.rest.codegen.model.WadlModeler;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class ClientStubsGenerator
extends AbstractGenerator {
    public static final String REST = "rest";
    public static final String RJS = "rjs";
    public static final String CSS = "css";
    public static final String JS = "js";
    public static final String HTML = "html";
    public static final String HTM = "htm";
    public static final String TXT = "txt";
    public static final String JSON = "json";
    public static final String GIF = "gif";
    public static final String IMAGES = "images";
    public static final String BUNDLE = "Bundle";
    public static final String PROPERTIES = "properties";
    public static final String JS_SUPPORT = "Support";
    public static final String JS_TESTSTUBS = "TestStubs";
    public static final String JS_README = "Readme";
    public static final String JS_TESTSTUBS_TEMPLATE = "Templates/WebServices/JsTestStubs.html";
    public static final String JS_STUBSUPPORT_TEMPLATE = "Templates/WebServices/JsStubSupport.js";
    public static final String JS_PROJECTSTUB_TEMPLATE = "Templates/WebServices/JsProjectStub.js";
    public static final String JS_STUB_TEMPLATE = "Templates/WebServices/JsStub.js";
    public static final String JS_ENTITY_TEMPLATE = "Templates/WebServices/JsEntity.js";
    public static final String JS_README_TEMPLATE = "Templates/WebServices/JsReadme.html";
    public static final String PROXY = "RestProxyServlet";
    public static final String PROXY_URL = "/restproxy";
    public static final String PROXY_TEMPLATE = "Templates/WebServices/RestProxyServlet.txt";
    public static final String TTL_DojoResources_Stubs = "TTL_DojoResources_Stubs";
    public static final String MSG_Readme = "MSG_Readme";
    public static final String MSG_TestPage = "MSG_TestPage";
    public static final String TTL_RestClient_Stubs = "TTL_RestClient_Stubs";
    public static final String MSG_SelectResource = "MSG_SelectResource";
    public static final String MSG_JS_Readme_Content = "MSG_JS_Readme_Content";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "8080";
    public static final String DEFAULT_BASE_URL = "http://localhost:8080";
    public static final String BASE_URL_TOKEN = "__BASE_URL__";
    public static final String FILE_ENCODING_TOKEN = "__FILE_ENCODING__";
    private FileObject stubFolder;
    private Project p;
    private boolean overwrite;
    private String projectName;
    private ResourceModel model;
    private FileObject rjsDir;
    private FileObject wadl;
    private String folderName;
    private String baseUrl;
    private String proxyUrl;
    private Charset baseEncoding;
    private FileObject rootFolder;

    public ClientStubsGenerator(FileObject fileObject, String string, Project project, boolean bl) throws IOException {
        assert (project != null);
        this.rootFolder = fileObject;
        this.folderName = string;
        this.p = project;
        this.overwrite = bl;
        this.projectName = ProjectUtils.getInformation((Project)this.getProject()).getName();
        this.baseEncoding = FileEncodingQuery.getEncoding((FileObject)fileObject);
    }

    public ClientStubsGenerator(FileObject fileObject, String string, FileObject fileObject2, boolean bl) throws IOException {
        this.rootFolder = fileObject;
        this.folderName = string;
        this.wadl = fileObject2;
        this.overwrite = bl;
        this.projectName = "NewProject";
        this.baseEncoding = FileEncodingQuery.getEncoding((FileObject)fileObject);
    }

    public FileObject getRootFolder() {
        return this.rootFolder;
    }

    public FileObject getStubFolder() {
        if (this.stubFolder == null) {
            try {
                this.stubFolder = this.createFolder(this.getRootFolder(), this.getFolderName());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.stubFolder;
    }

    public void setStubFolder(FileObject fileObject) {
        this.stubFolder = fileObject;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public Project getProject() {
        return this.p;
    }

    public boolean canOverwrite() {
        return this.overwrite;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ResourceModel getModel() {
        return this.model;
    }

    public String getDefaultBaseUrl() {
        return DEFAULT_BASE_URL;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String string) {
        this.proxyUrl = string;
    }

    public Charset getBaseEncoding() {
        return this.baseEncoding;
    }

    private String getApplicationNameFromUrl(String string) {
        String[] stringArray;
        String string2 = string.replaceAll("http://", "");
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((stringArray = string2.split("/")) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3 == null || !string3.startsWith(DEFAULT_HOST) || i + 1 >= stringArray.length || stringArray[i + 1] == null || stringArray[i + 1].trim().length() <= 0) continue;
                return ClientStubModel.normalizeName(stringArray[i + 1]);
            }
        }
        return ClientStubModel.normalizeName(string2);
    }

    private String findBaseUrl(Project project) {
        String string = null;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            String string2 = j2eeModuleProvider.getServerInstanceID();
            ServerInstance serverInstance = Deployment.getDefault().getServerInstance(string2);
            if (serverInstance != null) {
                try {
                    ServerInstance.Descriptor descriptor = serverInstance.getDescriptor();
                    string = descriptor.getHttpPort() == 80 ? descriptor.getHostname() : descriptor.getHostname() + ":" + descriptor.getHttpPort();
                    string = "http://" + string;
                }
                catch (InstanceRemovedException instanceRemovedException) {
                    string = null;
                }
            }
        }
        return string;
    }

    private String findAppContext(Project project) {
        String string = WebModule.getWebModule((FileObject)project.getProjectDirectory()).getContextPath();
        string = string != null ? string.substring(1) : ProjectUtils.getInformation((Project)project).getName();
        return string;
    }

    @Override
    public Set<FileObject> generate(ProgressHandle progressHandle) throws IOException {
        ResourceJavaScript resourceJavaScript;
        Resource resource;
        HashSet<FileObject> hashSet;
        Object object;
        Object object2;
        Object object3;
        if (progressHandle != null) {
            this.initProgressReporting(progressHandle, false);
        }
        Project project = FileOwnerQuery.getOwner((FileObject)this.getRootFolder());
        if (this.p != null) {
            this.model = new ClientStubModel().createModel(this.p);
            this.model.build();
            object3 = this.findBaseUrl(this.p);
            if (object3 == null) {
                object3 = this.getDefaultBaseUrl();
            }
            if ((object2 = this.findBaseUrl(project)) == null) {
                object2 = object3;
            }
            object = (RestSupport)this.p.getLookup().lookup(RestSupport.class);
            hashSet = object.getApplicationPath();
            this.setBaseUrl((String)(((String)object3).endsWith("/") ? object3 : (String)object3 + "/") + this.findAppContext(this.getProject()) + (String)(((String)((Object)hashSet)).startsWith("/") ? hashSet : "/" + (String)((Object)hashSet)));
            this.setProxyUrl((String)(((String)object2).endsWith("/") ? object2 : (String)object2 + "/") + this.findAppContext(project) + PROXY_URL);
        } else if (this.wadl != null) {
            this.model = new ClientStubModel().createModel(this.wadl);
            this.model.build();
            object3 = ((WadlModeler)this.model).getBaseUrl();
            if (object3 == null) {
                object3 = this.getDefaultBaseUrl();
            }
            this.setBaseUrl((String)object3);
            this.setProxyUrl((String)object3 + ".." + PROXY_URL);
            this.projectName = this.getApplicationNameFromUrl((String)object3);
        }
        object3 = this.getModel().getResources();
        this.rjsDir = this.getStubFolder();
        this.initJs(this.p);
        object2 = this.createFolder(this.rjsDir, this.getProjectName().toLowerCase());
        this.createDataObjectFromTemplate(JS_PROJECTSTUB_TEMPLATE, (FileObject)object2, this.getProjectName(), JS, this.canOverwrite());
        object = new HashSet();
        hashSet = object3.iterator();
        while (hashSet.hasNext()) {
            resource = (Resource)hashSet.next();
            if (progressHandle != null) {
                this.reportProgress(NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_GeneratingClass", (Object)resource.getName(), (Object)JS));
            }
            resourceJavaScript = new ResourceJavaScript(this, resource, (FileObject)object2, (Set<String>)object);
            resourceJavaScript.generate();
            resource.getEntities();
            Set<String> set = resource.getEntities();
            object.addAll(set);
        }
        this.updateProjectStub(object2.getFileObject(this.getProjectName(), JS), this.getProjectName());
        this.updateRestStub(this.rjsDir.getFileObject(JS_TESTSTUBS, HTML), (List<Resource>)object3, "");
        hashSet = new HashSet<FileObject>();
        resource = this.rjsDir.getFileObject(JS_TESTSTUBS, HTML);
        if (resource != null) {
            hashSet.add((FileObject)resource);
        }
        if ((resourceJavaScript = this.rjsDir.getFileObject(JS_README, TXT)) != null) {
            hashSet.add((FileObject)resourceJavaScript);
        }
        return hashSet;
    }

    protected FileObject createDataObjectFromTemplate(String string, FileObject fileObject, String string2, String string3, boolean bl) throws IOException {
        DataObject dataObject;
        FileObject fileObject2 = fileObject.getFileObject(string2, string3);
        if (fileObject2 != null) {
            if (bl) {
                dataObject = DataObject.find((FileObject)fileObject2);
                if (dataObject != null) {
                    dataObject.delete();
                }
            } else {
                return fileObject2;
            }
        }
        dataObject = RestUtils.createDataObjectFromTemplate(string, fileObject, string2);
        return dataObject.getPrimaryFile();
    }

    protected void copyDirectory(FileSystem fileSystem, final File file, final File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.copyDirectory(fileSystem, new File(file, stringArray[i]), new File(file2, stringArray[i]));
            }
        } else {
            if (!file.exists()) {
                throw new IOException("File or directory does not exist.");
            }
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    try {
                        int n;
                        byte[] byArray = new byte[1024];
                        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                            ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        }
                    }
                    finally {
                        ((InputStream)fileInputStream).close();
                        ((OutputStream)fileOutputStream).close();
                    }
                }
            });
        }
    }

    private void initJs(Project project) throws IOException {
        TokenReplacer tokenReplacer = new TokenReplacer(this);
        tokenReplacer.addToken(TTL_RestClient_Stubs, NbBundle.getMessage(ClientStubsGenerator.class, (String)TTL_RestClient_Stubs));
        tokenReplacer.addToken(MSG_Readme, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_Readme));
        tokenReplacer.addToken(MSG_TestPage, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_TestPage));
        tokenReplacer.addToken(MSG_JS_Readme_Content, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_JS_Readme_Content));
        tokenReplacer.addToken(FILE_ENCODING_TOKEN, this.getBaseEncoding().name());
        FileObject fileObject = this.createDataObjectFromTemplate(JS_TESTSTUBS_TEMPLATE, this.rjsDir, JS_TESTSTUBS, HTML, false);
        tokenReplacer.replaceTokens(fileObject);
        this.createDataObjectFromTemplate(JS_STUBSUPPORT_TEMPLATE, this.rjsDir, JS_SUPPORT, JS, false);
        fileObject = this.createDataObjectFromTemplate(JS_README_TEMPLATE, this.rjsDir, JS_README, HTML, false);
        tokenReplacer.replaceTokens(fileObject);
        fileObject = this.createDataObjectFromTemplate(PROXY_TEMPLATE, this.rjsDir, PROXY, TXT, false);
        File file = new File(FileUtil.toFile((FileObject)this.rjsDir), CSS);
        file.mkdirs();
        this.copySupportFiles(file);
    }

    private void copySupportFiles(File file) throws IOException {
        String[] stringArray = new String[]{"clientstubs.css", "css_master-all.css", "images/background_border_bottom.gif", "images/pbsel.png", "images/bg_gradient.gif", "images/pname-clientstubs.png", "images/level1_selected-1lvl.jpg", "images/primary-enabled.gif", "images/masthead.png", "images/primary-roll.gif", "images/pbdis.png", "images/secondary-enabled.gif", "images/pbena.png", "images/tbsel.png", "images/pbmou.png", "images/tbuns.png"};
        File file2 = new File(file, IMAGES);
        file2.mkdirs();
        for (String string : stringArray) {
            RestSupport.copyFile((File)file, (String)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(String string, File file) throws IOException {
        String string2 = "resources/" + string;
        if (!file.exists()) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                inputStream = ClientStubsGenerator.class.getResourceAsStream(string2);
                outputStream = new FileOutputStream(file);
                while ((n = inputStream.read()) != -1) {
                    outputStream.write(n);
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    protected FileObject createFolder(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createFolder(string);
        }
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProjectStub(FileObject fileObject, String string) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            Object object;
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.contains(BASE_URL_TOKEN)) {
                    object = this.getBaseUrl();
                    if (((String)object).endsWith("/")) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    stringBuilder.append(string2.replaceAll(BASE_URL_TOKEN, (String)object));
                } else if (string2.contains("__PROJECT_NAME__")) {
                    stringBuilder.append(string2.replaceAll("__PROJECT_NAME__", string));
                } else if (string2.contains("__PROJECT_INIT_BODY__")) {
                    object = new StringBuilder();
                    int n = 0;
                    List<Resource> list = this.getModel().getResources();
                    for (Resource resource : list) {
                        if (!resource.hasDefaultGet()) continue;
                        String string3 = resource.getPath();
                        if (!string3.startsWith("/")) {
                            string3 = "/" + string3;
                        }
                        ((StringBuilder)object).append("      this.resources[");
                        ((StringBuilder)object).append(n++);
                        ((StringBuilder)object).append("] = new ");
                        ((StringBuilder)object).append(resource.getName());
                        ((StringBuilder)object).append("(this.uri+'");
                        ((StringBuilder)object).append(string3);
                        ((StringBuilder)object).append("');\n");
                    }
                    stringBuilder.append((CharSequence)object);
                } else {
                    stringBuilder.append(string2);
                }
                stringBuilder.append("\n");
            }
            object = new OutputStreamWriter(fileObject.getOutputStream(fileLock), this.getBaseEncoding());
            try {
                ((Writer)object).write(stringBuilder.toString());
            }
            finally {
                ((OutputStreamWriter)object).close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateRestStub(FileObject fileObject, List<Resource> list, String string) throws IOException {
        void var8_11;
        FileLock fileLock;
        String string2 = this.getProjectName();
        String string3 = string2.toLowerCase();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t<script type='text/javascript' src='./");
        stringBuilder.append(string3);
        stringBuilder.append('/');
        stringBuilder.append(string2);
        stringBuilder.append('.');
        stringBuilder.append(JS);
        stringBuilder.append("'></script>\n");
        for (Resource object2 : list) {
            stringBuilder.append("\t<script type='text/javascript' src='./");
            stringBuilder.append(string3);
            stringBuilder.append('/');
            stringBuilder.append(object2.getName());
            stringBuilder.append('.');
            stringBuilder.append(JS);
            stringBuilder.append("'></script>\n");
            fileLock = object2.getEntities().iterator();
            while (fileLock.hasNext()) {
                stringBuilder.append("\t<script type='text/javascript' src='./");
                stringBuilder.append(string3);
                stringBuilder.append('/');
                stringBuilder.append(fileLock.next());
                stringBuilder.append('.');
                stringBuilder.append(JS);
                stringBuilder.append("'></script>\n");
            }
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        String string4 = this.getBaseUrl();
        if (string4.endsWith("/")) {
            String string5 = string4.substring(0, string4.length() - 1);
        }
        stringBuilder2.append("\n\t<!-- Using JavaScript files for project " + string2 + "-->\n");
        stringBuilder2.append("\t<script language='Javascript'>\n");
        stringBuilder2.append("\t\tvar str = '';\n");
        stringBuilder2.append("\t\t//Example test code for " + string2 + "\n");
        stringBuilder2.append("\t\tstr = '<h2>Resources for " + string2 + ":</h2><br><table border=\"1\">';\n");
        stringBuilder2.append("\t\tvar app = new " + string + string2 + "('" + (String)var8_11 + "');\n");
        stringBuilder2.append("\t\t//Uncomment below if using proxy for javascript cross-domain.\n");
        stringBuilder2.append("\t\t//app.setProxy(\"" + this.getProxyUrl() + "\");\n");
        stringBuilder2.append("\t\tvar resources = app.getResources();\n");
        stringBuilder2.append("\t\tfor(i=0;i<resources.length;i++) {\n");
        stringBuilder2.append("\t\t  var resource = resources[i];\n");
        stringBuilder2.append("\t\t  var uri = resource.getUri();\n");
        stringBuilder2.append("\t\t  str += '<tr><td valign=\"top\"><a href=\"'+uri+'\" target=\"_blank\">'+uri+'</a></td><td>';\n");
        stringBuilder2.append("\t\t  var items  = resource.getEntities();\n");
        stringBuilder2.append("\t\t  if (items != undefined) {\n");
        stringBuilder2.append("\t\t    if (items.length > 0) {\n");
        stringBuilder2.append("\t\t      for(j=0;j<items.length;j++) {\n");
        stringBuilder2.append("\t\t        var item = items[j];\n");
        stringBuilder2.append("\t\t        var uri2 = item.getUri();\n");
        stringBuilder2.append("\t\t        if ( uri2 != null && uri2 != undefined ){\n");
        stringBuilder2.append("\t\t            str += '<a href=\"'+uri2+'\" target=\"_blank\">'+uri2+'</a><br/>';\n");
        stringBuilder2.append("\t\t        }\n");
        stringBuilder2.append("\t\t        str += '&nbsp;&nbsp;<font size=\"-3\">'+item.toString()+'</font><br/>';\n");
        stringBuilder2.append("\t\t      }\n");
        stringBuilder2.append("\t\t    } else {\n");
        stringBuilder2.append("\t\t      str += 'No items detected';\n");
        stringBuilder2.append("\t\t    }\n");
        stringBuilder2.append("\t\t  } else {\n");
        stringBuilder2.append("\t\t    str += 'No items, please check the url: <a href=\"'+uri+'\" target=\"_blank\">'+uri+'</a>.<br/>Set proxy if RESTful web service is not running on the same domain as this application.';\n");
        stringBuilder2.append("\t\t  }\n");
        stringBuilder2.append("\t\t  str += '</td></tr>';\n");
        stringBuilder2.append("\t\t}\n");
        stringBuilder2.append("\t\tstr += '</table><br>';\n");
        stringBuilder2.append("\t\tvar n = document.getElementById('containerContent');\n");
        stringBuilder2.append("\t\tn.innerHTML = n.innerHTML + str;\n\n");
        stringBuilder2.append("\t</script>\n");
        fileLock = fileObject.lock();
        try {
            String string6;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
            StringBuilder stringBuilder3 = new StringBuilder();
            while ((string6 = bufferedReader.readLine()) != null) {
                if (string6.contains("JS_DECLARE_END")) {
                    stringBuilder3.append(stringBuilder.toString());
                } else if (string6.contains("JS_USAGE_END")) {
                    stringBuilder3.append(stringBuilder2.toString());
                }
                stringBuilder3.append(string6);
                stringBuilder3.append("\n");
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream(fileLock), this.getBaseEncoding());
            try {
                outputStreamWriter.write(stringBuilder3.toString());
            }
            finally {
                outputStreamWriter.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }
}

