/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerAnnotation;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisassemblyService;
import org.netbeans.modules.cnd.debugger.gdb2.Disassembly;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class GdbDisassemblyService
implements DisassemblyService {
    public int getAddressLine(String address) {
        Disassembly dis = Disassembly.getCurrent();
        if (dis == null) {
            return -1;
        }
        return dis.getAddressLine(address);
    }

    public String getLineAddress(int lineNo) {
        Disassembly dis = Disassembly.getCurrent();
        if (dis == null) {
            return null;
        }
        return dis.getLineAddress(lineNo);
    }

    public boolean isDis(String url) {
        return Disassembly.isDisasm(url);
    }

    public boolean isInDis() {
        return Disassembly.isInDisasm();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean showLine(int line) {
        if (line != -1) {
            FileObject fo = Disassembly.getFileObject();
            if (fo == null) return false;
        }
        Disassembly.open();
        return false;
    }

    public boolean showAddress(String address) {
        return this.showLine(this.getAddressLine(address));
    }

    public void movePC(long address, DebuggerAnnotation pcMarker, boolean andShow) {
        FileObject fo;
        Disassembly dis = Disassembly.getCurrent();
        if (dis == null) {
            return;
        }
        int line = dis.getAddressLine(address);
        if (line != -1 && (fo = Disassembly.getFileObject()) != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                Line disLine = EditorBridge.lineNumberToLine((DataObject)dobj, (int)line);
                if (andShow) {
                    EditorBridge.showInEditor((Line)disLine);
                }
                pcMarker.setLine(disLine, true);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public Annotation annotateAddress(String address, String annotationType) {
        FileObject fo;
        Disassembly dis = Disassembly.getCurrent();
        if (dis == null) {
            return null;
        }
        int line = dis.getAddressLine(address);
        if (line == -1 || (fo = Disassembly.getFileObject()) != null) {
            // empty if block
        }
        return null;
    }
}

