/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.completion;

import com.sun.el.parser.AstDeferredExpression;
import com.sun.el.parser.AstDynamicExpression;
import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstMethodSuffix;
import com.sun.el.parser.AstPropertySuffix;
import com.sun.el.parser.AstString;
import com.sun.el.parser.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.web.el.AstPath;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELParserResult;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.ELVariableResolvers;
import org.netbeans.modules.web.el.ResourceBundles;
import org.netbeans.modules.web.el.completion.ELElementHandle;
import org.netbeans.modules.web.el.completion.ELImplictObjectCompletionItem;
import org.netbeans.modules.web.el.completion.ELJavaCompletionItem;
import org.netbeans.modules.web.el.completion.ELKeywordCompletionItem;
import org.netbeans.modules.web.el.completion.ELRawObjectPropertyCompletionItem;
import org.netbeans.modules.web.el.completion.ELResourceBundleCompletionItem;
import org.netbeans.modules.web.el.completion.ELResourceBundleKeyCompletionItem;
import org.netbeans.modules.web.el.completion.ELSanitizer;
import org.netbeans.modules.web.el.completion.ELVariableCompletionItem;
import org.netbeans.modules.web.el.refactoring.RefactoringUtil;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.openide.filesystems.FileObject;

public final class ELCodeCompletionHandler
implements CodeCompletionHandler {
    public CodeCompletionResult complete(CodeCompletionContext context) {
        ResourceBundles bundle;
        String bundleIdentifier;
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(50);
        DefaultCompletionResult result = new DefaultCompletionResult(proposals, false);
        ELElement element = this.getElementAt(context.getParserResult(), context.getCaretOffset());
        if (element == null || !element.isValid()) {
            return CodeCompletionResult.NONE;
        }
        Node target = this.getTargetNode(element, context.getCaretOffset());
        AstPath path = new AstPath(element.getNode());
        List<Node> rootToNode = path.rootToNode(target);
        if (rootToNode.isEmpty()) {
            return result;
        }
        PrefixMatcher prefixMatcher = PrefixMatcher.create(target, context);
        if (prefixMatcher == null) {
            return CodeCompletionResult.NONE;
        }
        if (target instanceof AstString && (bundleIdentifier = (bundle = ResourceBundles.get(this.getFileObject(context))).findResourceBundleIdentifier(path)) != null) {
            this.proposeBundleKeys(context, prefixMatcher, element, bundleIdentifier, (AstString)target, proposals);
            return proposals.isEmpty() ? CodeCompletionResult.NONE : result;
        }
        ELTypeUtilities typeUtilities = ELTypeUtilities.create(this.getFileObject(context));
        Node previous = rootToNode.get(rootToNode.size() - 1);
        Node nodeToResolve = this.getNodeToResolve(target, previous);
        Element resolved = typeUtilities.resolveElement(element, nodeToResolve);
        if (typeUtilities.isRawObject(nodeToResolve)) {
            this.proposeRawObjectProperties(context, prefixMatcher, element, nodeToResolve, typeUtilities, proposals);
        } else if (typeUtilities.isScopeObject(nodeToResolve)) {
            this.proposeBeansFromScope(context, prefixMatcher, element, nodeToResolve, typeUtilities, proposals);
        } else if (resolved == null) {
            this.proposeManagedBeans(context, prefixMatcher, element, typeUtilities, proposals);
            this.proposeBundles(context, prefixMatcher, element, proposals);
            this.proposeVariables(context, prefixMatcher, element, typeUtilities, proposals);
            this.proposeImpicitObjects(context, prefixMatcher, element, typeUtilities, proposals);
            this.proposeKeywords(context, prefixMatcher, element, typeUtilities, proposals);
        } else {
            this.proposeMethods(context, resolved, prefixMatcher, element, typeUtilities, proposals);
        }
        return proposals.isEmpty() ? CodeCompletionResult.NONE : result;
    }

    private Node getNodeToResolve(Node target, Node previous) {
        if (target instanceof AstIdentifier && (previous instanceof AstIdentifier || previous instanceof AstPropertySuffix || previous instanceof AstMethodSuffix)) {
            return target;
        }
        return previous;
    }

    private ELElement getElementAt(ParserResult parserResult, int offset) {
        ELParserResult elParserResult = (ELParserResult)parserResult;
        ELElement result = elParserResult.getElementAt(offset);
        if (result == null || result.isValid()) {
            return result;
        }
        ELSanitizer sanitizer = new ELSanitizer(result);
        return sanitizer.sanitized();
    }

    private Node getTargetNode(ELElement element, int offset) {
        Node realTarget;
        Node result = element.findNodeAt(offset);
        if ((result instanceof AstDeferredExpression || result instanceof AstDynamicExpression) && (realTarget = element.findNodeAt(offset - 1)) != null) {
            result = realTarget;
        }
        return result;
    }

    private FileObject getFileObject(CodeCompletionContext context) {
        return context.getParserResult().getSnapshot().getSource().getFileObject();
    }

    private void proposeMethods(CodeCompletionContext context, Element resolved, PrefixMatcher prefix, ELElement elElement, ELTypeUtilities typeUtilities, List<CompletionProposal> proposals) {
        if ((resolved = typeUtilities.getTypeFor(resolved)) == null || resolved.getKind() == ElementKind.TYPE_PARAMETER) {
            return;
        }
        for (ExecutableElement enclosed : ElementFilter.methodsIn(resolved.getEnclosedElements())) {
            String methodName;
            String propertyName;
            if (!enclosed.getModifiers().contains((Object)Modifier.PUBLIC) || !prefix.matches(propertyName = RefactoringUtil.getPropertyName(methodName = enclosed.getSimpleName().toString(), true))) continue;
            ELJavaCompletionItem item = new ELJavaCompletionItem(enclosed, elElement, typeUtilities);
            item.setSmart(true);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeImpicitObjects(CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, ELTypeUtilities typeUtilities, List<CompletionProposal> proposals) {
        for (ImplicitObject implicitObject : typeUtilities.getImplicitObjects()) {
            if (!prefix.matches(implicitObject.getName())) continue;
            ELImplictObjectCompletionItem item = new ELImplictObjectCompletionItem(implicitObject.getName(), implicitObject.getClazz());
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeKeywords(CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, ELTypeUtilities typeUtilities, List<CompletionProposal> proposals) {
        for (ELTokenId elToken : ELTokenId.values()) {
            if (!ELTokenId.ELTokenCategories.KEYWORDS.hasCategory((TokenId)elToken) || elToken.fixedText() == null || !prefix.matches(elToken.fixedText())) continue;
            ELKeywordCompletionItem item = new ELKeywordCompletionItem(elToken.fixedText());
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeManagedBeans(CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, ELTypeUtilities typeUtilities, List<CompletionProposal> proposals) {
        for (ELVariableResolver.VariableInfo bean : ELVariableResolvers.getManagedBeans(this.getFileObject(context))) {
            TypeElement element;
            if (!prefix.matches(bean.name) || (element = typeUtilities.getElementForType(bean.clazz)) == null) continue;
            ELJavaCompletionItem item = new ELJavaCompletionItem(element, bean.name, elElement, typeUtilities);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeBeansFromScope(CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, Node scopeNode, ELTypeUtilities typeUtilities, List<CompletionProposal> proposals) {
        String scope = scopeNode.getImage();
        String scopeString = "Scope";
        if (scope.endsWith("Scope")) {
            scope = scope.substring(0, scope.length() - "Scope".length());
        }
        for (ELVariableResolver.VariableInfo bean : ELVariableResolvers.getBeansInScope(scope, context.getParserResult().getSnapshot())) {
            if (!prefix.matches(bean.name)) continue;
            TypeElement element = typeUtilities.getElementForType(bean.clazz);
            ELJavaCompletionItem item = new ELJavaCompletionItem(element, elElement, typeUtilities);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeRawObjectProperties(CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, Node scopeNode, ELTypeUtilities typeUtilities, List<CompletionProposal> proposals) {
        for (ELVariableResolver.VariableInfo property : ELVariableResolvers.getRawObjectProperties(scopeNode.getImage(), context.getParserResult().getSnapshot())) {
            if (!prefix.matches(property.name)) continue;
            ELRawObjectPropertyCompletionItem item = new ELRawObjectPropertyCompletionItem(property.name);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeVariables(CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, ELTypeUtilities typeUtilities, List<CompletionProposal> proposals) {
        for (ELVariableResolver.VariableInfo bean : ELVariableResolvers.getVariables(context.getParserResult().getSnapshot(), context.getCaretOffset())) {
            if (!prefix.matches(bean.name)) continue;
            if (bean.clazz == null) {
                ELVariableCompletionItem item = new ELVariableCompletionItem(bean.name, bean.expression);
                item.setAnchorOffset(context.getCaretOffset() - prefix.length());
                item.setSmart(true);
                proposals.add((CompletionProposal)item);
                continue;
            }
            TypeElement element = typeUtilities.getElementForType(bean.clazz);
            if (element == null) continue;
            ELJavaCompletionItem item = new ELJavaCompletionItem(element, elElement, typeUtilities);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeBundles(CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, List<CompletionProposal> proposals) {
        ResourceBundles resourceBundles = ResourceBundles.get(this.getFileObject(context));
        if (!resourceBundles.canHaveBundles()) {
            return;
        }
        for (String bundle : resourceBundles.getBundles()) {
            if (!prefix.matches(bundle)) continue;
            ELResourceBundleCompletionItem item = new ELResourceBundleCompletionItem(bundle);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeBundleKeys(CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, String bundleKey, AstString target, List<CompletionProposal> proposals) {
        if (target.getImage().isEmpty() || elElement.getOriginalOffset((Node)target).getStart() >= context.getCaretOffset()) {
            return;
        }
        ResourceBundles resourceBundles = ResourceBundles.get(this.getFileObject(context));
        if (!resourceBundles.canHaveBundles()) {
            return;
        }
        for (Map.Entry<String, String> entry : resourceBundles.getEntries(bundleKey).entrySet()) {
            if (!prefix.matches(entry.getKey())) continue;
            ELResourceBundleKeyCompletionItem item = new ELResourceBundleKeyCompletionItem(entry.getKey(), entry.getValue(), elElement);
            item.setSmart(true);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    public String document(ParserResult info, ElementHandle element) {
        if (!(element instanceof ELElementHandle)) {
            return null;
        }
        return ((ELElementHandle)element).document(info);
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        ELElement element = this.getElementAt(info, caretOffset);
        if (element == null) {
            return null;
        }
        Node node = element.findNodeAt(caretOffset);
        if (node instanceof AstString) {
            int startOffset = element.getOriginalOffset(node).getStart();
            int end = caretOffset - startOffset;
            String image = node.getImage();
            if (end > 0 && !image.isEmpty()) {
                return image.substring(1, end);
            }
        }
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return Collections.emptySet();
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    private static class PrefixMatcher {
        private final String prefix;
        private final boolean exact;

        private PrefixMatcher(String value, boolean exact) {
            this.prefix = value;
            this.exact = exact;
        }

        static PrefixMatcher create(Node target, CodeCompletionContext context) {
            boolean isDoc;
            String prefix = context.getPrefix() != null ? context.getPrefix() : "";
            boolean bl = isDoc = context.getQueryType() == CodeCompletionHandler.QueryType.DOCUMENTATION;
            if (isDoc) {
                prefix = PrefixMatcher.getPrefixForDocumentation(target);
            }
            if (isDoc && prefix.isEmpty()) {
                return null;
            }
            return new PrefixMatcher(prefix, isDoc);
        }

        private static String getPrefixForDocumentation(Node target) {
            if (target instanceof AstString) {
                return ((AstString)target).getString();
            }
            return target.getImage() == null ? "" : target.getImage();
        }

        boolean matches(String str) {
            if (this.exact) {
                return this.prefix.equals(str);
            }
            return str.startsWith(this.prefix);
        }

        int length() {
            return this.prefix.length();
        }
    }
}

