/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import com.sun.el.parser.AstBracketSuffix;
import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstString;
import com.sun.el.parser.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.el.AstPath;
import org.netbeans.modules.web.el.Pair;
import org.netbeans.modules.web.el.spi.ELPlugin;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class ResourceBundles {
    private static final Logger LOGGER = Logger.getLogger(ResourceBundles.class.getName());
    private static final Map<FileObject, ResourceBundles> CACHE = new WeakHashMap<FileObject, ResourceBundles>(1);
    private final WebModule webModule;
    private final Project project;
    private List<String> bundles;
    private Map<String, ResourceBundle> bundlesMap;

    private ResourceBundles(WebModule webModule, Project project) {
        this.webModule = webModule;
        this.project = project;
    }

    public static ResourceBundles get(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        if (CACHE.containsKey(fileObject)) {
            return CACHE.get(fileObject);
        }
        CACHE.clear();
        Project owner = FileOwnerQuery.getOwner((FileObject)fileObject);
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        ResourceBundles result = new ResourceBundles(webModule, owner);
        CACHE.put(fileObject, result);
        return result;
    }

    public boolean canHaveBundles() {
        return this.webModule != null && this.project != null;
    }

    public boolean isResourceBundleIdentifier(String identifier) {
        for (String bundle : this.getBundles()) {
            if (!bundle.equals(identifier)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidKey(String bundle, String key) {
        ResourceBundle bundleFile = this.getBundlesMap().get(bundle);
        if (bundleFile == null) {
            return true;
        }
        return bundleFile.containsKey(key);
    }

    public List<Pair<AstIdentifier, AstString>> collectKeys(Node root) {
        ArrayList<Pair<AstIdentifier, AstString>> result = new ArrayList<Pair<AstIdentifier, AstString>>();
        List<Node> path = new AstPath(root).rootToLeaf();
        for (int i = 0; i < path.size(); ++i) {
            Node node = path.get(i);
            if (!(node instanceof AstIdentifier) || !this.isResourceBundleIdentifier(node.getImage()) || i + 2 >= path.size()) continue;
            Node brackets = path.get(i + 1);
            Node string = path.get(i + 2);
            if (!(brackets instanceof AstBracketSuffix) || !(string instanceof AstString)) continue;
            result.add(Pair.of((AstIdentifier)node, (AstString)string));
        }
        return result;
    }

    public String findResourceBundleIdentifier(AstPath astPath) {
        List<Node> path = astPath.leafToRoot();
        for (int i = 0; i < path.size(); ++i) {
            Node node = path.get(i);
            if (!(node instanceof AstString) || i + 2 >= path.size()) continue;
            Node brackets = path.get(i + 1);
            Node identifier = path.get(i + 2);
            if (!(brackets instanceof AstBracketSuffix) || !(identifier instanceof AstIdentifier) || !this.isResourceBundleIdentifier(identifier.getImage())) continue;
            return identifier.getImage();
        }
        return null;
    }

    public String getValue(String bundle, String key) {
        ResourceBundle bundleFile = this.getBundlesMap().get(bundle);
        if (bundleFile == null || !bundleFile.containsKey(key)) {
            return null;
        }
        try {
            return bundleFile.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public Map<String, String> getEntries(String bundleName) {
        ResourceBundle resourceBundle = this.getBundlesMap().get(bundleName);
        if (resourceBundle == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : resourceBundle.keySet()) {
            String value = resourceBundle.getString(key);
            result.put(key, value);
        }
        return result;
    }

    public List<String> getBundles() {
        if (this.bundles == null) {
            this.bundles = this.initJSFResourceBundles();
        }
        return this.bundles;
    }

    private List<String> initJSFResourceBundles() {
        return this.webModule != null ? ELPlugin.Query.getResourceBundles(this.webModule.getDocumentBase()) : Collections.emptyList();
    }

    private Map<String, ResourceBundle> getBundlesMap() {
        if (this.bundlesMap == null) {
            this.bundlesMap = this.initResourceBundleMap();
        }
        return this.bundlesMap;
    }

    private Map<String, ResourceBundle> initResourceBundleMap() {
        HashMap<String, ResourceBundle> result = new HashMap<String, ResourceBundle>();
        ClassPathProvider provider = (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
        if (provider == null) {
            return null;
        }
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        for (String bundleFile : this.getBundles()) {
            block3: for (SourceGroup sourceGroup : sourceGroups) {
                FileObject rootFolder = sourceGroup.getRootFolder();
                for (String classPathType : new String[]{"classpath/source", "classpath/compile"}) {
                    ClassPath classPath = ClassPath.getClassPath((FileObject)rootFolder, (String)classPathType);
                    if (classPath == null) continue;
                    ClassLoader classLoader = classPath.getClassLoader(false);
                    try {
                        ResourceBundle found = ResourceBundle.getBundle(bundleFile, Locale.getDefault(), classLoader);
                        result.put(bundleFile, found);
                        continue block3;
                    }
                    catch (MissingResourceException exception) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }
}

