/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.php.dbgp.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public class BreakpointsReader
implements Properties.Reader {
    private static final String LINE_NUMBER = "lineNumber";
    private static final String URL = "url";
    private static final String ENABED = "enabled";
    private static final String FUNC_NAME = "functionName";
    private static final String TYPE = "type";

    public String[] getSupportedClassNames() {
        return new String[]{LineBreakpoint.class.getName(), FunctionBreakpoint.class.getName()};
    }

    public Object read(String typeID, Properties properties) {
        if (typeID.equals(LineBreakpoint.class.getName())) {
            Line line = this.getLine(properties.getString(URL, null), properties.getInt(LINE_NUMBER, 1));
            if (line == null) {
                return null;
            }
            LineBreakpoint breakpoint = new LineBreakpoint(line);
            if (!properties.getBoolean(ENABED, true)) {
                breakpoint.disable();
            }
            return new LineBreakpoint(line);
        }
        if (typeID.equals(FunctionBreakpoint.class.getName())) {
            String func = properties.getString(FUNC_NAME, null);
            FunctionBreakpoint.Type type = FunctionBreakpoint.Type.forString(properties.getString(TYPE, null));
            if (func == null || type == null) {
                return null;
            }
            return new FunctionBreakpoint(type, func);
        }
        return null;
    }

    public void write(Object object, Properties properties) {
        if (object instanceof LineBreakpoint) {
            LineBreakpoint breakpoint = (LineBreakpoint)((Object)object);
            FileObject fileObject = (FileObject)breakpoint.getLine().getLookup().lookup(FileObject.class);
            try {
                properties.setString(URL, fileObject.getURL().toString());
                properties.setInt(LINE_NUMBER, breakpoint.getLine().getLineNumber());
                properties.setBoolean(ENABED, breakpoint.isEnabled());
            }
            catch (FileStateInvalidException ex) {
                this.log(ex);
            }
        } else if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint breakpoint = (FunctionBreakpoint)((Object)object);
            String func = breakpoint.getFunction();
            properties.setString(FUNC_NAME, func);
            properties.setString(TYPE, breakpoint.getType().toString());
            properties.setBoolean(ENABED, breakpoint.isEnabled());
        }
    }

    private void log(FileStateInvalidException ex) {
        Logger.getLogger(BreakpointsReader.class.getName()).log(Level.SEVERE, null, ex);
    }

    private Line getLine(String url, int lineNumber) {
        FileObject file = this.getFileObject(url);
        if (file == null) {
            return null;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        if (dataObject == null) {
            return null;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        Line.Set ls = lineCookie.getLineSet();
        if (ls == null) {
            return null;
        }
        try {
            return ls.getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private FileObject getFileObject(String url) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        return file;
    }
}

