/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.netbeans.modules.php.dbgp.models.ViewModelSupport;
import org.netbeans.modules.php.dbgp.packets.Stack;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class BreakpointModel
extends ViewModelSupport
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpointHit";
    public static final String CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/BreakpointHit";
    public static final String DISABLED_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpoint";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    public static final String DISABLED_CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpointHit";
    public static final String DISABLED_CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpointHit";
    public static final String LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpoint";
    public static final String CURRENT_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpointHit";
    public static final String DISABLED_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledConditionalBreakpoint";
    private static final String METHOD = "TXT_Method";
    private static final String PARENS = "()";
    private Map<DebugSession, AbstractBreakpoint> myCurrentBreakpoints = new WeakHashMap<DebugSession, AbstractBreakpoint>();

    @Override
    public void clearModel() {
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof LineBreakpoint) {
            LineBreakpoint breakpoint = (LineBreakpoint)((Object)node);
            FileObject fileObject = (FileObject)breakpoint.getLine().getLookup().lookup(FileObject.class);
            return fileObject.getNameExt() + ":" + (breakpoint.getLine().getLineNumber() + 1);
        }
        if (node instanceof FunctionBreakpoint) {
            FunctionBreakpoint breakpoint = (FunctionBreakpoint)((Object)node);
            StringBuilder builder = new StringBuilder(NbBundle.getMessage(BreakpointModel.class, (String)METHOD));
            builder.append(" ");
            builder.append(breakpoint.getFunction());
            builder.append(PARENS);
            return builder.toString();
        }
        throw new UnknownTypeException(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIconBase(Object node) throws UnknownTypeException {
        AbstractBreakpoint breakpoint;
        Map<DebugSession, AbstractBreakpoint> map = this.myCurrentBreakpoints;
        synchronized (map) {
            for (AbstractBreakpoint breakpoint2 : this.myCurrentBreakpoints.values()) {
                if (!node.equals((Object)breakpoint2)) continue;
                return this.getCurrentBreakpointIconBase(breakpoint2);
            }
        }
        if (node instanceof LineBreakpoint) {
            breakpoint = (LineBreakpoint)((Object)node);
            if (!breakpoint.isEnabled()) {
                return DISABLED_LINE_BREAKPOINT;
            }
            return LINE_BREAKPOINT;
        }
        if (node instanceof AbstractBreakpoint) {
            breakpoint = (AbstractBreakpoint)((Object)node);
            if (!breakpoint.isEnabled()) {
                return DISABLED_BREAKPOINT;
            }
            return BREAKPOINT;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof LineBreakpoint) {
            return ((LineBreakpoint)((Object)node)).getLine().getDisplayName();
        }
        throw new UnknownTypeException(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentStack(Stack stack, DebugSession session) {
        if (stack == null) {
            Map<DebugSession, AbstractBreakpoint> map = this.myCurrentBreakpoints;
            synchronized (map) {
                AbstractBreakpoint breakpoint = this.myCurrentBreakpoints.remove(session);
                this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)breakpoint));
            }
            return;
        }
        String currentCommand = stack.getCurrentCommandName();
        if (this.foundLineBreakpoint(stack.getLine() - 1, session)) {
            return;
        }
        this.foundFunctionBreakpoint(currentCommand, session);
    }

    private String getCurrentBreakpointIconBase(AbstractBreakpoint breakpoint) {
        if (breakpoint instanceof LineBreakpoint) {
            return CURRENT_LINE_BREAKPOINT;
        }
        return CURRENT_BREAKPOINT;
    }

    private boolean foundFunctionBreakpoint(String currentCommand, DebugSession session) {
        return this.foundBreakpoint(session, new FunctionBreakpointAcceptor(currentCommand));
    }

    private boolean foundLineBreakpoint(int line, DebugSession session) {
        return this.foundBreakpoint(session, new LineBreakpointAcceptor(line));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean foundBreakpoint(DebugSession session, Acceptor acceptor) {
        Breakpoint[] breakpoints;
        for (Breakpoint breakpoint : breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!(breakpoint instanceof AbstractBreakpoint) || !((AbstractBreakpoint)breakpoint).isSessionRelated(session) || !acceptor.accept(breakpoint)) continue;
            AbstractBreakpoint abpnt = (AbstractBreakpoint)breakpoint;
            Map<DebugSession, AbstractBreakpoint> map = this.myCurrentBreakpoints;
            synchronized (map) {
                AbstractBreakpoint bpnt = this.myCurrentBreakpoints.get(session);
                this.myCurrentBreakpoints.put(session, abpnt);
                this.fireChangeEvents(new ModelEvent[]{new ModelEvent.NodeChanged((Object)this, (Object)bpnt), new ModelEvent.NodeChanged((Object)this, (Object)abpnt)});
            }
            return true;
        }
        return false;
    }

    private class FunctionBreakpointAcceptor
    implements Acceptor {
        private String myFunction;

        FunctionBreakpointAcceptor(String function) {
            this.myFunction = function;
        }

        @Override
        public boolean accept(Breakpoint breakpoint) {
            if (!(breakpoint instanceof FunctionBreakpoint)) {
                return false;
            }
            String function = ((FunctionBreakpoint)breakpoint).getFunction();
            return function == null ? false : function.equals(this.myFunction);
        }
    }

    private class LineBreakpointAcceptor
    implements Acceptor {
        private int myLine;

        LineBreakpointAcceptor(int lineNumber) {
            this.myLine = lineNumber;
        }

        @Override
        public boolean accept(Breakpoint breakpoint) {
            if (!(breakpoint instanceof LineBreakpoint)) {
                return false;
            }
            LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpoint;
            return this.myLine == lineBreakpoint.getLine().getLineNumber();
        }
    }

    private static interface Acceptor {
        public boolean accept(Breakpoint var1);
    }
}

